/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.backends.opensearch.json;

import jakarta.json.JsonValue;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.lang.reflect.Field;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpSerializable;
import org.opensearch.client.json.JsonpSerializer;

public abstract class JsonpMapperBase
implements JsonpMapper {
    protected abstract <T> JsonpDeserializer<T> getDefaultDeserializer(Class<T> var1);

    public <T> T deserialize(JsonParser parser, Class<T> clazz) {
        JsonpDeserializer<T> deserializer = JsonpMapperBase.findDeserializer(clazz);
        if (deserializer != null) {
            return (T)deserializer.deserialize(parser, (JsonpMapper)this);
        }
        return (T)this.getDefaultDeserializer(clazz).deserialize(parser, (JsonpMapper)this);
    }

    @Nullable
    public static <T> JsonpDeserializer<T> findDeserializer(Class<T> clazz) {
        JsonpDeserializable annotation = clazz.getAnnotation(JsonpDeserializable.class);
        if (annotation != null) {
            try {
                Field field = clazz.getDeclaredField(annotation.field());
                return (JsonpDeserializer)field.get(null);
            }
            catch (Exception e) {
                throw new RuntimeException("No deserializer found in '" + clazz.getName() + "." + annotation.field() + "'");
            }
        }
        return null;
    }

    @Nullable
    public static <T> JsonpSerializer<T> findSerializer(T value) {
        Class<?> valueClass = value.getClass();
        if (JsonpSerializable.class.isAssignableFrom(valueClass)) {
            return JsonpSerializableSerializer.INSTANCE;
        }
        if (JsonValue.class.isAssignableFrom(valueClass)) {
            return JsonpValueSerializer.INSTANCE;
        }
        return null;
    }

    protected static class JsonpSerializableSerializer<T extends JsonpSerializable>
    implements JsonpSerializer<T> {
        protected static final JsonpSerializer<?> INSTANCE = new JsonpSerializableSerializer();

        protected JsonpSerializableSerializer() {
        }

        public void serialize(T value, JsonGenerator generator, JsonpMapper mapper) {
            value.serialize(generator, mapper);
        }
    }

    protected static class JsonpValueSerializer
    implements JsonpSerializer<JsonValue> {
        protected static final JsonpSerializer<?> INSTANCE = new JsonpValueSerializer();

        protected JsonpValueSerializer() {
        }

        public void serialize(JsonValue value, JsonGenerator generator, JsonpMapper mapper) {
            generator.write(value);
        }
    }
}

