/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.queue.rabbitmq.view.cassandra;

import com.google.common.collect.ImmutableList;
import java.time.Clock;
import java.time.Instant;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.IntStream;
import javax.inject.Inject;
import org.apache.james.queue.rabbitmq.EnqueueId;
import org.apache.james.queue.rabbitmq.MailQueueName;
import org.apache.james.queue.rabbitmq.view.cassandra.BrowseStartDAO;
import org.apache.james.queue.rabbitmq.view.cassandra.CassandraMailQueueBrowser;
import org.apache.james.queue.rabbitmq.view.cassandra.ContentStartDAO;
import org.apache.james.queue.rabbitmq.view.cassandra.DeletedMailsDAO;
import org.apache.james.queue.rabbitmq.view.cassandra.EnqueuedMailsDAO;
import org.apache.james.queue.rabbitmq.view.cassandra.configuration.CassandraMailQueueViewConfiguration;
import org.apache.james.queue.rabbitmq.view.cassandra.model.BucketedSlices;
import org.apache.james.queue.rabbitmq.view.cassandra.model.EnqueuedItemWithSlicingContext;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class CassandraMailQueueMailDelete {
    private final DeletedMailsDAO deletedMailsDao;
    private final BrowseStartDAO browseStartDao;
    private final ContentStartDAO contentStartDAO;
    private final EnqueuedMailsDAO enqueuedMailsDAO;
    private final CassandraMailQueueBrowser cassandraMailQueueBrowser;
    private final CassandraMailQueueViewConfiguration configuration;
    private final Clock clock;

    @Inject
    CassandraMailQueueMailDelete(DeletedMailsDAO deletedMailsDao, BrowseStartDAO browseStartDao, ContentStartDAO contentStartDAO, EnqueuedMailsDAO enqueuedMailsDAO, CassandraMailQueueBrowser cassandraMailQueueBrowser, CassandraMailQueueViewConfiguration configuration, Clock clock) {
        this.deletedMailsDao = deletedMailsDao;
        this.browseStartDao = browseStartDao;
        this.contentStartDAO = contentStartDAO;
        this.enqueuedMailsDAO = enqueuedMailsDAO;
        this.cassandraMailQueueBrowser = cassandraMailQueueBrowser;
        this.configuration = configuration;
        this.clock = clock;
    }

    Mono<Void> considerDeleted(EnqueueId enqueueId, MailQueueName mailQueueName) {
        return this.deletedMailsDao.markAsDeleted(mailQueueName, enqueueId).doFinally(any -> this.maybeUpdateBrowseStart(mailQueueName));
    }

    Mono<Boolean> isDeleted(EnqueueId enqueueId, MailQueueName mailQueueName) {
        return this.deletedMailsDao.isDeleted(mailQueueName, enqueueId);
    }

    void updateBrowseStart(MailQueueName mailQueueName) {
        this.findNewBrowseStart(mailQueueName).flatMap(newBrowseStart -> this.updateNewBrowseStart(mailQueueName, (Instant)newBrowseStart).then(this.clearContentBeforeBrowse(mailQueueName, (Instant)newBrowseStart))).subscribeOn(Schedulers.parallel()).subscribe();
    }

    private void maybeUpdateBrowseStart(MailQueueName mailQueueName) {
        if (this.shouldUpdateBrowseStart()) {
            this.updateBrowseStart(mailQueueName);
        }
    }

    private Mono<Instant> findNewBrowseStart(MailQueueName mailQueueName) {
        BucketedSlices.Slice currentSlice = BucketedSlices.Slice.of(this.clock.instant());
        return this.browseStartDao.findBrowseStart(mailQueueName).filter(browseStart -> browseStart.isBefore(currentSlice.getStartSliceInstant())).flatMapMany(browseStart -> this.cassandraMailQueueBrowser.browseReferences(mailQueueName, (Instant)browseStart)).map(enqueuedItem -> enqueuedItem.getSlicingContext().getTimeRangeStart()).next();
    }

    private Mono<Void> updateNewBrowseStart(MailQueueName mailQueueName, Instant newBrowseStartInstant) {
        return this.browseStartDao.updateBrowseStart(mailQueueName, newBrowseStartInstant);
    }

    private Mono<Void> clearContentBeforeBrowse(MailQueueName mailQueueName, Instant newBrowseStartInstant) {
        return this.contentStartDAO.findContentStart(mailQueueName).flatMapIterable(contentStart -> (Iterable)BucketedSlices.Slice.of(contentStart).allSlicesTill(newBrowseStartInstant, this.configuration.getSliceWindow()).filter(slice -> slice.getStartSliceInstant().isBefore(newBrowseStartInstant)).flatMap(slice -> IntStream.range(0, this.configuration.getBucketCount()).boxed().map(bucket -> EnqueuedItemWithSlicingContext.SlicingContext.of(BucketedSlices.BucketId.of(bucket), slice.getStartSliceInstant()))).collect(ImmutableList.toImmutableList())).concatMap(slice -> this.deleteEmailsFromBrowseProjection(mailQueueName, (EnqueuedItemWithSlicingContext.SlicingContext)slice)).concatMap(slice -> this.enqueuedMailsDAO.deleteBucket(mailQueueName, BucketedSlices.Slice.of(slice.getTimeRangeStart()), slice.getBucketId())).then(this.contentStartDAO.updateContentStart(mailQueueName, newBrowseStartInstant));
    }

    private Mono<EnqueuedItemWithSlicingContext.SlicingContext> deleteEmailsFromBrowseProjection(MailQueueName mailQueueName, EnqueuedItemWithSlicingContext.SlicingContext slicingContext) {
        return this.enqueuedMailsDAO.selectEnqueuedMails(mailQueueName, BucketedSlices.Slice.of(slicingContext.getTimeRangeStart()), slicingContext.getBucketId()).flatMap(item -> this.deletedMailsDao.removeDeletedMark(mailQueueName, item.getEnqueuedItem().getEnqueueId()).then(Mono.fromRunnable(item::dispose).subscribeOn(Schedulers.boundedElastic())), 16).then().thenReturn((Object)slicingContext);
    }

    private boolean shouldUpdateBrowseStart() {
        int threshold = this.configuration.getUpdateBrowseStartPace();
        return Math.abs(ThreadLocalRandom.current().nextInt()) % threshold == 0;
    }
}

