/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.queue.rabbitmq.view.api;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.james.blob.mail.MimeMessagePartsId;
import org.apache.james.queue.api.ManageableMailQueue;
import org.apache.james.queue.rabbitmq.EnqueueId;
import org.apache.james.queue.rabbitmq.EnqueuedItem;

public interface DeleteCondition {
    public boolean shouldBeDeleted(EnqueuedItem var1);

    public static DeleteCondition from(ManageableMailQueue.Type deletionType, String value) {
        switch (deletionType) {
            case Name: {
                return DeleteCondition.withName(value);
            }
            case Sender: {
                return DeleteCondition.withSender(value);
            }
            case Recipient: {
                return DeleteCondition.withRecipient(value);
            }
        }
        throw new NotImplementedException(deletionType + " is not handled");
    }

    public static WithRecipient withRecipient(String value) {
        Preconditions.checkNotNull((Object)value);
        return new WithRecipient(value);
    }

    public static WithSender withSender(String value) {
        Preconditions.checkNotNull((Object)value);
        return new WithSender(value);
    }

    public static WithName withName(String value) {
        Preconditions.checkNotNull((Object)value);
        return new WithName(value);
    }

    public static WithEnqueueId withEnqueueId(EnqueueId value, MimeMessagePartsId blobIds) {
        Preconditions.checkNotNull((Object)value);
        return new WithEnqueueId(value, blobIds);
    }

    public static DeleteCondition all() {
        return new All();
    }

    public static class WithName
    implements DeleteCondition {
        private final String name;

        private WithName(String name) {
            this.name = name;
        }

        @Override
        public boolean shouldBeDeleted(EnqueuedItem enqueuedItem) {
            Preconditions.checkNotNull((Object)enqueuedItem);
            return enqueuedItem.getMail().getName().equals(this.name);
        }

        public final boolean equals(Object obj) {
            if (obj instanceof WithName) {
                WithName that = (WithName)obj;
                return Objects.equals(this.name, that.name);
            }
            return false;
        }

        public final int hashCode() {
            return Objects.hashCode(this.name);
        }
    }

    public static class WithSender
    implements DeleteCondition {
        private final String senderAsString;

        private WithSender(String senderAsString) {
            this.senderAsString = senderAsString;
        }

        @Override
        public boolean shouldBeDeleted(EnqueuedItem enqueuedItem) {
            Preconditions.checkNotNull((Object)enqueuedItem);
            return enqueuedItem.getMail().getMaybeSender().asString().equals(this.senderAsString);
        }

        public final boolean equals(Object obj) {
            if (obj instanceof WithSender) {
                WithSender that = (WithSender)obj;
                return Objects.equals(this.senderAsString, that.senderAsString);
            }
            return false;
        }

        public final int hashCode() {
            return Objects.hashCode(this.senderAsString);
        }
    }

    public static class WithRecipient
    implements DeleteCondition {
        private final String recipientAsString;

        private WithRecipient(String recipientAsString) {
            this.recipientAsString = recipientAsString;
        }

        @Override
        public boolean shouldBeDeleted(EnqueuedItem enqueuedItem) {
            Preconditions.checkNotNull((Object)enqueuedItem);
            return enqueuedItem.getMail().getRecipients().stream().anyMatch(mailAddress -> mailAddress.asString().equals(this.recipientAsString));
        }

        public final boolean equals(Object obj) {
            if (obj instanceof WithRecipient) {
                WithRecipient that = (WithRecipient)obj;
                return Objects.equals(this.recipientAsString, that.recipientAsString);
            }
            return false;
        }

        public final int hashCode() {
            return Objects.hashCode(this.recipientAsString);
        }
    }

    public static class WithEnqueueId
    implements DeleteCondition {
        private final EnqueueId enqueueId;
        private final MimeMessagePartsId blobIds;

        WithEnqueueId(EnqueueId enqueueId, MimeMessagePartsId blobIds) {
            this.enqueueId = enqueueId;
            this.blobIds = blobIds;
        }

        public EnqueueId getEnqueueId() {
            return this.enqueueId;
        }

        public MimeMessagePartsId getBlobIds() {
            return this.blobIds;
        }

        @Override
        public boolean shouldBeDeleted(EnqueuedItem enqueuedItem) {
            Preconditions.checkNotNull((Object)enqueuedItem);
            return enqueuedItem.getEnqueueId().equals(this.enqueueId);
        }
    }

    public static class All
    implements DeleteCondition {
        @Override
        public boolean shouldBeDeleted(EnqueuedItem enqueuedItem) {
            Preconditions.checkNotNull((Object)enqueuedItem);
            return true;
        }

        public final boolean equals(Object obj) {
            return obj instanceof All;
        }

        public final int hashCode() {
            return Objects.hashCode(All.class);
        }
    }
}

