/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.queue.rabbitmq;

import com.github.fge.lambdas.Throwing;
import java.util.function.Function;
import javax.mail.MessagingException;
import javax.mail.internet.AddressException;
import javax.mail.internet.MimeMessage;
import org.apache.james.blob.api.BlobId;
import org.apache.james.blob.api.Store;
import org.apache.james.blob.mail.MimeMessagePartsId;
import org.apache.james.queue.api.MailQueue;
import org.apache.james.queue.rabbitmq.MailReference;
import org.apache.james.queue.rabbitmq.MailReferenceDTO;
import org.apache.james.queue.rabbitmq.MailWithEnqueueId;
import org.apache.james.server.core.MailImpl;
import org.apache.james.server.core.MimeMessageWrapper;
import org.apache.mailet.Mail;
import reactor.core.publisher.Mono;

class MailLoader {
    private final Store<MimeMessage, MimeMessagePartsId> mimeMessageStore;
    private final BlobId.Factory blobIdFactory;

    MailLoader(Store<MimeMessage, MimeMessagePartsId> mimeMessageStore, BlobId.Factory blobIdFactory) {
        this.mimeMessageStore = mimeMessageStore;
        this.blobIdFactory = blobIdFactory;
    }

    Mono<MailWithEnqueueId> load(MailReferenceDTO dto) {
        return Mono.fromCallable(() -> dto.toMailReference(this.blobIdFactory)).flatMap(mailReference -> this.buildMail((MailReference)mailReference).map(mail -> new MailWithEnqueueId(mailReference.getEnqueueId(), (Mail)mail, mailReference.getPartsId())));
    }

    private Mono<Mail> buildMail(MailReference mailReference) {
        return this.mimeMessageStore.read((Object)mailReference.getPartsId()).flatMap(mimeMessage -> this.buildMailWithMessageReference(mailReference, (MimeMessage)mimeMessage));
    }

    private Mono<Mail> buildMailWithMessageReference(MailReference mailReference, MimeMessage mimeMessage) {
        Function<Mail, Mono> setMessage = mail -> Mono.fromRunnable((Runnable)Throwing.runnable(() -> {
            if (mimeMessage instanceof MimeMessageWrapper && mail instanceof MailImpl) {
                MailImpl mailImpl = (MailImpl)mail;
                mailImpl.setMessageNoCopy((MimeMessageWrapper)mimeMessage);
            } else {
                mail.setMessage(mimeMessage);
            }
        }).sneakyThrow()).onErrorResume(AddressException.class, e -> Mono.error((Throwable)new MailQueue.MailQueueException("Failed to parse mail address", (Exception)((Object)e)))).onErrorResume(MessagingException.class, e -> Mono.error((Throwable)new MailQueue.MailQueueException("Failed to generate mime message", (Exception)((Object)e))));
        return Mono.just((Object)mailReference.getMail()).flatMap(mail -> ((Mono)setMessage.apply((Mail)mail)).thenReturn(mail));
    }
}

