/*
 * Decompiled with CFR 0.152.
 */
package reactor.rabbitmq;

import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import java.time.Duration;
import java.util.function.Function;
import java.util.function.Supplier;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.rabbitmq.Utils;
import reactor.util.annotation.Nullable;

public class ReceiverOptions {
    private ConnectionFactory connectionFactory = ((Supplier<ConnectionFactory>)() -> {
        ConnectionFactory connectionFactory = new ConnectionFactory();
        connectionFactory.useNio();
        return connectionFactory;
    }).get();
    private Mono<? extends Connection> connectionMono;
    private Scheduler connectionSubscriptionScheduler;
    private Utils.ExceptionFunction<ConnectionFactory, ? extends Connection> connectionSupplier;
    private Function<Mono<? extends Connection>, Mono<? extends Connection>> connectionMonoConfigurator = cm -> cm;
    private Duration connectionClosingTimeout = Duration.ofSeconds(30L);

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public ReceiverOptions connectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
        return this;
    }

    @Nullable
    public Scheduler getConnectionSubscriptionScheduler() {
        return this.connectionSubscriptionScheduler;
    }

    public ReceiverOptions connectionSubscriptionScheduler(@Nullable Scheduler connectionSubscriptionScheduler) {
        this.connectionSubscriptionScheduler = connectionSubscriptionScheduler;
        return this;
    }

    public ReceiverOptions connectionSupplier(Utils.ExceptionFunction<ConnectionFactory, ? extends Connection> function) {
        return this.connectionSupplier(this.connectionFactory, function);
    }

    public ReceiverOptions connectionSupplier(ConnectionFactory connectionFactory, Utils.ExceptionFunction<ConnectionFactory, ? extends Connection> function) {
        this.connectionSupplier = ignored -> (Connection)function.apply(connectionFactory);
        return this;
    }

    public ReceiverOptions connectionMono(@Nullable Mono<? extends Connection> connectionMono) {
        this.connectionMono = connectionMono;
        return this;
    }

    public ReceiverOptions connectionMonoConfigurator(Function<Mono<? extends Connection>, Mono<? extends Connection>> connectionMonoConfigurator) {
        this.connectionMonoConfigurator = connectionMonoConfigurator;
        return this;
    }

    @Nullable
    public Mono<? extends Connection> getConnectionMono() {
        return this.connectionMono;
    }

    @Nullable
    public Utils.ExceptionFunction<ConnectionFactory, ? extends Connection> getConnectionSupplier() {
        return this.connectionSupplier;
    }

    public Function<Mono<? extends Connection>, Mono<? extends Connection>> getConnectionMonoConfigurator() {
        return this.connectionMonoConfigurator;
    }

    public ReceiverOptions connectionClosingTimeout(@Nullable Duration connectionClosingTimeout) {
        this.connectionClosingTimeout = connectionClosingTimeout;
        return this;
    }

    @Nullable
    public Duration getConnectionClosingTimeout() {
        return this.connectionClosingTimeout;
    }
}

