/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.backup;

import com.github.fge.lambdas.Throwing;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.apache.james.core.Username;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.backup.ArchiveService;
import org.apache.james.mailbox.backup.MailArchiveRestorer;
import org.apache.james.mailbox.backup.MailboxBackup;
import org.apache.james.mailbox.backup.MailboxWithAnnotations;
import org.apache.james.mailbox.exception.BadCredentialsException;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.FetchGroup;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.MailboxMetaData;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.MessageRange;
import org.apache.james.mailbox.model.MessageResult;
import org.apache.james.mailbox.model.search.MailboxQuery;
import org.apache.james.util.ReactorUtils;
import org.apache.james.util.streams.Iterators;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class DefaultMailboxBackup
implements MailboxBackup {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultMailboxBackup.class);
    private final MailboxManager mailboxManager;
    private final ArchiveService archiveService;
    private final MailArchiveRestorer archiveRestorer;

    @Inject
    public DefaultMailboxBackup(MailboxManager mailboxManager, ArchiveService archiveService, MailArchiveRestorer archiveRestorer) {
        this.mailboxManager = mailboxManager;
        this.archiveService = archiveService;
        this.archiveRestorer = archiveRestorer;
    }

    @Override
    public void backupAccount(Username username, OutputStream destination) throws IOException, MailboxException {
        MailboxSession session = this.mailboxManager.createSystemSession(username);
        List<MailAccountContent> accountContents = this.getAccountContentForUser(session);
        List mailboxes = (List)accountContents.stream().map(MailAccountContent::getMailboxWithAnnotations).collect(ImmutableList.toImmutableList());
        Stream<MessageResult> messages = this.allMessagesForUser(accountContents);
        this.archive(mailboxes, messages, destination);
    }

    private boolean isAccountNonEmpty(Username username) throws BadCredentialsException, MailboxException, IOException {
        MailboxSession session = this.mailboxManager.createSystemSession(username);
        return this.getAccountContentForUser(session).stream().findFirst().isPresent();
    }

    @Override
    public Publisher<MailboxBackup.BackupStatus> restore(Username username, InputStream source) {
        try {
            if (this.isAccountNonEmpty(username)) {
                return Mono.just((Object)((Object)MailboxBackup.BackupStatus.NON_EMPTY_RECEIVER_ACCOUNT));
            }
        }
        catch (Exception e2) {
            LOGGER.error("Error during account restoration for user : " + username.asString(), (Throwable)e2);
            return Mono.just((Object)((Object)MailboxBackup.BackupStatus.FAILED));
        }
        return Mono.fromRunnable((Runnable)Throwing.runnable(() -> this.archiveRestorer.restore(username, source)).sneakyThrow()).subscribeOn(ReactorUtils.BLOCKING_CALL_WRAPPER).doOnError(e -> LOGGER.error("Error during account restoration for user : " + username.asString(), e)).doOnTerminate(Throwing.runnable(source::close).sneakyThrow()).thenReturn((Object)MailboxBackup.BackupStatus.DONE).onErrorReturn((Object)MailboxBackup.BackupStatus.FAILED);
    }

    private Stream<MailAccountContent> getMailboxWithAnnotationsFromPath(MailboxSession session, MailboxPath path) {
        try {
            MessageManager messageManager = this.mailboxManager.getMailbox(path, session);
            Mailbox mailbox = messageManager.getMailboxEntity();
            List annotations = this.mailboxManager.getAllAnnotations(path, session);
            MailboxWithAnnotations mailboxWithAnnotations = new MailboxWithAnnotations(mailbox, annotations);
            Stream messages = Iterators.toStream((Iterator)messageManager.getMessages(MessageRange.all(), FetchGroup.FULL_CONTENT, session));
            return Stream.of(new MailAccountContent(mailboxWithAnnotations, messages));
        }
        catch (MailboxException e) {
            LOGGER.error("Error while fetching Mailbox during backup", (Throwable)e);
            return Stream.empty();
        }
    }

    @VisibleForTesting
    List<MailAccountContent> getAccountContentForUser(MailboxSession session) throws MailboxException {
        MailboxQuery queryUser = MailboxQuery.builder().privateNamespace().user(session.getUser()).build();
        Stream<MailboxPath> paths = this.mailboxManager.search(queryUser, MailboxManager.MailboxSearchFetchType.Minimal, session).toStream().map(MailboxMetaData::getPath);
        List mailboxes = (List)paths.flatMap(path -> this.getMailboxWithAnnotationsFromPath(session, (MailboxPath)path)).collect(ImmutableList.toImmutableList());
        return mailboxes;
    }

    private void archive(List<MailboxWithAnnotations> mailboxes, Stream<MessageResult> messages, OutputStream destination) throws IOException {
        this.archiveService.archive(mailboxes, messages, destination);
    }

    private Stream<MessageResult> allMessagesForUser(List<MailAccountContent> mailboxes) {
        return mailboxes.stream().flatMap(MailAccountContent::getMessages);
    }

    @VisibleForTesting
    static class MailAccountContent {
        private final MailboxWithAnnotations mailboxWithAnnotations;
        private final Stream<MessageResult> messages;

        MailAccountContent(MailboxWithAnnotations mailboxWithAnnotations, Stream<MessageResult> messages) {
            this.mailboxWithAnnotations = mailboxWithAnnotations;
            this.messages = messages;
        }

        public MailboxWithAnnotations getMailboxWithAnnotations() {
            return this.mailboxWithAnnotations;
        }

        public Stream<MessageResult> getMessages() {
            return this.messages;
        }
    }
}

