/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util;

import com.unboundid.ldap.sdk.ANONYMOUSBindRequest;
import com.unboundid.ldap.sdk.CRAMMD5BindRequest;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DIGESTMD5BindRequest;
import com.unboundid.ldap.sdk.DIGESTMD5BindRequestProperties;
import com.unboundid.ldap.sdk.EXTERNALBindRequest;
import com.unboundid.ldap.sdk.GSSAPIBindRequest;
import com.unboundid.ldap.sdk.GSSAPIBindRequestProperties;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.OAUTHBEARERBindRequest;
import com.unboundid.ldap.sdk.PLAINBindRequest;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SASLBindRequest;
import com.unboundid.ldap.sdk.SASLQualityOfProtection;
import com.unboundid.ldap.sdk.SCRAMSHA1BindRequest;
import com.unboundid.ldap.sdk.SCRAMSHA256BindRequest;
import com.unboundid.ldap.sdk.SCRAMSHA512BindRequest;
import com.unboundid.ldap.sdk.unboundidds.SingleUseTOTPBindRequest;
import com.unboundid.ldap.sdk.unboundidds.UnboundIDCertificatePlusPasswordBindRequest;
import com.unboundid.ldap.sdk.unboundidds.UnboundIDDeliveredOTPBindRequest;
import com.unboundid.ldap.sdk.unboundidds.UnboundIDYubiKeyOTPBindRequest;
import com.unboundid.util.CommandLineTool;
import com.unboundid.util.InternalUseOnly;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.PasswordReader;
import com.unboundid.util.SASLMechanismInfo;
import com.unboundid.util.SASLOption;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.UtilityMessages;
import com.unboundid.util.Validator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class SASLUtils {
    @NotNull
    public static final String SASL_OPTION_ACCESS_TOKEN = "accessToken";
    @NotNull
    public static final String SASL_OPTION_AUTH_ID = "authID";
    @NotNull
    public static final String SASL_OPTION_AUTHZ_ID = "authzID";
    @NotNull
    public static final String SASL_OPTION_CONFIG_FILE = "configFile";
    @NotNull
    public static final String SASL_OPTION_DEBUG = "debug";
    @NotNull
    public static final String SASL_OPTION_KDC_ADDRESS = "kdcAddress";
    @NotNull
    public static final String SASL_OPTION_MECHANISM = "mech";
    @NotNull
    public static final String SASL_OPTION_OTP = "otp";
    @NotNull
    public static final String SASL_OPTION_PROMPT_FOR_STATIC_PW = "promptForStaticPassword";
    @NotNull
    public static final String SASL_OPTION_PROTOCOL = "protocol";
    @NotNull
    public static final String SASL_OPTION_QOP = "qop";
    @NotNull
    public static final String SASL_OPTION_REALM = "realm";
    @NotNull
    public static final String SASL_OPTION_REQUIRE_CACHE = "requireCache";
    @NotNull
    public static final String SASL_OPTION_RENEW_TGT = "renewTGT";
    @NotNull
    public static final String SASL_OPTION_TICKET_CACHE_PATH = "ticketCache";
    @NotNull
    public static final String SASL_OPTION_TOTP_PASSWORD = "totpPassword";
    @NotNull
    public static final String SASL_OPTION_TRACE = "trace";
    @NotNull
    public static final String SASL_OPTION_USERNAME = "username";
    @NotNull
    public static final String SASL_OPTION_USE_TICKET_CACHE = "useTicketCache";
    @NotNull
    private static final Map<String, SASLMechanismInfo> SASL_MECHANISMS;

    private SASLUtils() {
    }

    @NotNull
    public static List<SASLMechanismInfo> getSupportedSASLMechanisms() {
        return Collections.unmodifiableList(new ArrayList<SASLMechanismInfo>(SASL_MECHANISMS.values()));
    }

    @Nullable
    public static SASLMechanismInfo getSASLMechanismInfo(@NotNull String mechanism) {
        return SASL_MECHANISMS.get(StaticUtils.toLowerCase(mechanism));
    }

    @NotNull
    public static SASLBindRequest createBindRequest(@Nullable String bindDN, @Nullable String password, @Nullable String mechanism, String ... options) throws LDAPException {
        return SASLUtils.createBindRequest(bindDN, password == null ? null : StaticUtils.getBytes(password), mechanism, StaticUtils.toList(options), new Control[0]);
    }

    @NotNull
    public static SASLBindRequest createBindRequest(@Nullable String bindDN, @Nullable String password, @Nullable String mechanism, @Nullable List<String> options, Control ... controls) throws LDAPException {
        return SASLUtils.createBindRequest(bindDN, password == null ? null : StaticUtils.getBytes(password), mechanism, options, controls);
    }

    @NotNull
    public static SASLBindRequest createBindRequest(@Nullable String bindDN, @Nullable byte[] password, @Nullable String mechanism, String ... options) throws LDAPException {
        return SASLUtils.createBindRequest(bindDN, password, mechanism, StaticUtils.toList(options), new Control[0]);
    }

    @NotNull
    public static SASLBindRequest createBindRequest(@Nullable String bindDN, @Nullable byte[] password, @Nullable String mechanism, @Nullable List<String> options, Control ... controls) throws LDAPException {
        return SASLUtils.createBindRequest(bindDN, password, false, null, mechanism, options, controls);
    }

    @NotNull
    public static SASLBindRequest createBindRequest(@Nullable String bindDN, @Nullable byte[] password, boolean promptForPassword, @Nullable CommandLineTool tool, @Nullable String mechanism, @Nullable List<String> options, Control ... controls) throws LDAPException {
        String mech;
        Map<String, String> optionsMap;
        String mechOption;
        if (promptForPassword) {
            Validator.ensureNotNull(tool);
        }
        if ((mechOption = (optionsMap = SASLUtils.parseOptions(options)).remove(StaticUtils.toLowerCase(SASL_OPTION_MECHANISM))) != null) {
            mech = mechOption;
            if (mechanism != null && !mech.equalsIgnoreCase(mechanism)) {
                throw new LDAPException(ResultCode.PARAM_ERROR, UtilityMessages.ERR_SASL_OPTION_MECH_CONFLICT.get(mechanism, mech));
            }
        } else {
            mech = mechanism;
        }
        if (mech == null) {
            throw new LDAPException(ResultCode.PARAM_ERROR, UtilityMessages.ERR_SASL_OPTION_NO_MECH.get());
        }
        if (mech.equalsIgnoreCase("ANONYMOUS")) {
            return SASLUtils.createANONYMOUSBindRequest(password, optionsMap, controls);
        }
        if (mech.equalsIgnoreCase("CRAM-MD5")) {
            return SASLUtils.createCRAMMD5BindRequest(password, promptForPassword, tool, optionsMap, controls);
        }
        if (mech.equalsIgnoreCase("DIGEST-MD5")) {
            return SASLUtils.createDIGESTMD5BindRequest(password, promptForPassword, tool, optionsMap, controls);
        }
        if (mech.equalsIgnoreCase("EXTERNAL")) {
            return SASLUtils.createEXTERNALBindRequest(password, optionsMap, controls);
        }
        if (mech.equalsIgnoreCase("GSSAPI")) {
            return SASLUtils.createGSSAPIBindRequest(password, promptForPassword, tool, optionsMap, controls);
        }
        if (mech.equalsIgnoreCase("OAUTHBEARER")) {
            return SASLUtils.createOAUTHBEARERBindRequest(password, promptForPassword, tool, optionsMap, controls);
        }
        if (mech.equalsIgnoreCase("PLAIN")) {
            return SASLUtils.createPLAINBindRequest(password, promptForPassword, tool, optionsMap, controls);
        }
        if (mech.equalsIgnoreCase("SCRAM-SHA-1")) {
            return SASLUtils.createSCRAMSHA1BindRequest(password, promptForPassword, tool, optionsMap, controls);
        }
        if (mech.equalsIgnoreCase("SCRAM-SHA-256")) {
            return SASLUtils.createSCRAMSHA256BindRequest(password, promptForPassword, tool, optionsMap, controls);
        }
        if (mech.equalsIgnoreCase("SCRAM-SHA-512")) {
            return SASLUtils.createSCRAMSHA512BindRequest(password, promptForPassword, tool, optionsMap, controls);
        }
        if (mech.equalsIgnoreCase("UNBOUNDID-CERTIFICATE-PLUS-PASSWORD")) {
            return SASLUtils.createUnboundIDCertificatePlusPasswordBindRequest(password, tool, optionsMap, controls);
        }
        if (mech.equalsIgnoreCase("UNBOUNDID-DELIVERED-OTP")) {
            return SASLUtils.createUNBOUNDIDDeliveredOTPBindRequest(password, optionsMap, controls);
        }
        if (mech.equalsIgnoreCase("UNBOUNDID-TOTP")) {
            return SASLUtils.createUNBOUNDIDTOTPBindRequest(password, tool, optionsMap, controls);
        }
        if (mech.equalsIgnoreCase("UNBOUNDID-YUBIKEY-OTP")) {
            return SASLUtils.createUNBOUNDIDYUBIKEYOTPBindRequest(password, tool, optionsMap, controls);
        }
        throw new LDAPException(ResultCode.PARAM_ERROR, UtilityMessages.ERR_SASL_OPTION_UNSUPPORTED_MECH.get(mech));
    }

    @NotNull
    private static ANONYMOUSBindRequest createANONYMOUSBindRequest(@Nullable byte[] password, @NotNull Map<String, String> options, @Nullable Control[] controls) throws LDAPException {
        if (password != null) {
            throw new LDAPException(ResultCode.PARAM_ERROR, UtilityMessages.ERR_SASL_OPTION_MECH_DOESNT_ACCEPT_PASSWORD.get("ANONYMOUS"));
        }
        String trace = options.remove(StaticUtils.toLowerCase(SASL_OPTION_TRACE));
        SASLUtils.ensureNoUnsupportedOptions(options, "ANONYMOUS");
        return new ANONYMOUSBindRequest(trace, controls);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    private static CRAMMD5BindRequest createCRAMMD5BindRequest(@Nullable byte[] password, boolean promptForPassword, @Nullable CommandLineTool tool, @NotNull Map<String, String> options, @Nullable Control[] controls) throws LDAPException {
        byte[] pw;
        if (password == null) {
            if (!promptForPassword) throw new LDAPException(ResultCode.PARAM_ERROR, UtilityMessages.ERR_SASL_OPTION_MECH_REQUIRES_PASSWORD.get("CRAM-MD5"));
            tool.getOriginalOut().print(UtilityMessages.INFO_LDAP_TOOL_ENTER_BIND_PASSWORD.get());
            pw = PasswordReader.readPassword();
            tool.getOriginalOut().println();
        } else {
            pw = password;
        }
        String authID = options.remove(StaticUtils.toLowerCase(SASL_OPTION_AUTH_ID));
        if (authID == null) {
            throw new LDAPException(ResultCode.PARAM_ERROR, UtilityMessages.ERR_SASL_MISSING_REQUIRED_OPTION.get(SASL_OPTION_AUTH_ID, "CRAM-MD5"));
        }
        SASLUtils.ensureNoUnsupportedOptions(options, "CRAM-MD5");
        return new CRAMMD5BindRequest(authID, pw, controls);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    private static DIGESTMD5BindRequest createDIGESTMD5BindRequest(@Nullable byte[] password, boolean promptForPassword, @Nullable CommandLineTool tool, @NotNull Map<String, String> options, @Nullable Control[] controls) throws LDAPException {
        byte[] pw;
        if (password == null) {
            if (!promptForPassword) throw new LDAPException(ResultCode.PARAM_ERROR, UtilityMessages.ERR_SASL_OPTION_MECH_REQUIRES_PASSWORD.get("DIGEST-MD5"));
            tool.getOriginalOut().print(UtilityMessages.INFO_LDAP_TOOL_ENTER_BIND_PASSWORD.get());
            pw = PasswordReader.readPassword();
            tool.getOriginalOut().println();
        } else {
            pw = password;
        }
        String authID = options.remove(StaticUtils.toLowerCase(SASL_OPTION_AUTH_ID));
        if (authID == null) {
            throw new LDAPException(ResultCode.PARAM_ERROR, UtilityMessages.ERR_SASL_MISSING_REQUIRED_OPTION.get(SASL_OPTION_AUTH_ID, "DIGEST-MD5"));
        }
        DIGESTMD5BindRequestProperties properties = new DIGESTMD5BindRequestProperties(authID, pw);
        properties.setAuthorizationID(options.remove(StaticUtils.toLowerCase(SASL_OPTION_AUTHZ_ID)));
        properties.setRealm(options.remove(StaticUtils.toLowerCase(SASL_OPTION_REALM)));
        String qopString = options.remove(StaticUtils.toLowerCase(SASL_OPTION_QOP));
        if (qopString != null) {
            properties.setAllowedQoP(SASLQualityOfProtection.decodeQoPList(qopString));
        }
        SASLUtils.ensureNoUnsupportedOptions(options, "DIGEST-MD5");
        return new DIGESTMD5BindRequest(properties, controls);
    }

    @NotNull
    private static EXTERNALBindRequest createEXTERNALBindRequest(@Nullable byte[] password, @NotNull Map<String, String> options, @Nullable Control[] controls) throws LDAPException {
        if (password != null) {
            throw new LDAPException(ResultCode.PARAM_ERROR, UtilityMessages.ERR_SASL_OPTION_MECH_DOESNT_ACCEPT_PASSWORD.get("EXTERNAL"));
        }
        SASLUtils.ensureNoUnsupportedOptions(options, "EXTERNAL");
        return new EXTERNALBindRequest(controls);
    }

    @NotNull
    private static GSSAPIBindRequest createGSSAPIBindRequest(@Nullable byte[] password, boolean promptForPassword, @Nullable CommandLineTool tool, @NotNull Map<String, String> options, @Nullable Control[] controls) throws LDAPException {
        String authID = options.remove(StaticUtils.toLowerCase(SASL_OPTION_AUTH_ID));
        if (authID == null) {
            throw new LDAPException(ResultCode.PARAM_ERROR, UtilityMessages.ERR_SASL_MISSING_REQUIRED_OPTION.get(SASL_OPTION_AUTH_ID, "GSSAPI"));
        }
        GSSAPIBindRequestProperties gssapiProperties = new GSSAPIBindRequestProperties(authID, password);
        gssapiProperties.setAuthorizationID(options.remove(StaticUtils.toLowerCase(SASL_OPTION_AUTHZ_ID)));
        gssapiProperties.setConfigFilePath(options.remove(StaticUtils.toLowerCase(SASL_OPTION_CONFIG_FILE)));
        gssapiProperties.setEnableGSSAPIDebugging(SASLUtils.getBooleanValue(options, SASL_OPTION_DEBUG, false));
        gssapiProperties.setKDCAddress(options.remove(StaticUtils.toLowerCase(SASL_OPTION_KDC_ADDRESS)));
        String protocol = options.remove(StaticUtils.toLowerCase(SASL_OPTION_PROTOCOL));
        if (protocol != null) {
            gssapiProperties.setServicePrincipalProtocol(protocol);
        }
        gssapiProperties.setRealm(options.remove(StaticUtils.toLowerCase(SASL_OPTION_REALM)));
        String qopString = options.remove(StaticUtils.toLowerCase(SASL_OPTION_QOP));
        if (qopString != null) {
            gssapiProperties.setAllowedQoP(SASLQualityOfProtection.decodeQoPList(qopString));
        }
        gssapiProperties.setRenewTGT(SASLUtils.getBooleanValue(options, SASL_OPTION_RENEW_TGT, false));
        gssapiProperties.setRequireCachedCredentials(SASLUtils.getBooleanValue(options, SASL_OPTION_REQUIRE_CACHE, false));
        gssapiProperties.setTicketCachePath(options.remove(StaticUtils.toLowerCase(SASL_OPTION_TICKET_CACHE_PATH)));
        gssapiProperties.setUseTicketCache(SASLUtils.getBooleanValue(options, SASL_OPTION_USE_TICKET_CACHE, true));
        SASLUtils.ensureNoUnsupportedOptions(options, "GSSAPI");
        if (!(password != null || gssapiProperties.useTicketCache() && gssapiProperties.requireCachedCredentials())) {
            if (promptForPassword) {
                tool.getOriginalOut().print(UtilityMessages.INFO_LDAP_TOOL_ENTER_BIND_PASSWORD.get());
                gssapiProperties.setPassword(PasswordReader.readPassword());
                tool.getOriginalOut().println();
            } else {
                throw new LDAPException(ResultCode.PARAM_ERROR, UtilityMessages.ERR_SASL_OPTION_GSSAPI_PASSWORD_REQUIRED.get());
            }
        }
        return new GSSAPIBindRequest(gssapiProperties, controls);
    }

    @NotNull
    private static OAUTHBEARERBindRequest createOAUTHBEARERBindRequest(@Nullable byte[] password, boolean promptForPassword, @Nullable CommandLineTool tool, @NotNull Map<String, String> options, @Nullable Control[] controls) throws LDAPException {
        String accessToken = options.remove(StaticUtils.toLowerCase(SASL_OPTION_ACCESS_TOKEN));
        if (accessToken == null) {
            if (promptForPassword) {
                tool.getOriginalOut().print(UtilityMessages.INFO_SASL_TOOL_ENTER_OAUTHBEARER_ACCESS_TOKEN.get());
                accessToken = StaticUtils.toUTF8String(PasswordReader.readPassword());
                tool.getOriginalOut().println();
            } else {
                throw new LDAPException(ResultCode.PARAM_ERROR, UtilityMessages.ERR_SASL_MISSING_REQUIRED_OPTION.get(SASL_OPTION_ACCESS_TOKEN, "OAUTHBEARER"));
            }
        }
        SASLUtils.ensureNoUnsupportedOptions(options, "OAUTHBEARER");
        return new OAUTHBEARERBindRequest(accessToken, controls);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    private static PLAINBindRequest createPLAINBindRequest(@Nullable byte[] password, boolean promptForPassword, @Nullable CommandLineTool tool, @NotNull Map<String, String> options, @Nullable Control[] controls) throws LDAPException {
        byte[] pw;
        if (password == null) {
            if (!promptForPassword) throw new LDAPException(ResultCode.PARAM_ERROR, UtilityMessages.ERR_SASL_OPTION_MECH_REQUIRES_PASSWORD.get("PLAIN"));
            tool.getOriginalOut().print(UtilityMessages.INFO_LDAP_TOOL_ENTER_BIND_PASSWORD.get());
            pw = PasswordReader.readPassword();
            tool.getOriginalOut().println();
        } else {
            pw = password;
        }
        String authID = options.remove(StaticUtils.toLowerCase(SASL_OPTION_AUTH_ID));
        if (authID == null) {
            throw new LDAPException(ResultCode.PARAM_ERROR, UtilityMessages.ERR_SASL_MISSING_REQUIRED_OPTION.get(SASL_OPTION_AUTH_ID, "PLAIN"));
        }
        String authzID = options.remove(StaticUtils.toLowerCase(SASL_OPTION_AUTHZ_ID));
        SASLUtils.ensureNoUnsupportedOptions(options, "PLAIN");
        return new PLAINBindRequest(authID, authzID, pw, controls);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    private static SCRAMSHA1BindRequest createSCRAMSHA1BindRequest(@Nullable byte[] password, boolean promptForPassword, @Nullable CommandLineTool tool, @NotNull Map<String, String> options, @Nullable Control[] controls) throws LDAPException {
        byte[] pw;
        if (password == null) {
            if (!promptForPassword) throw new LDAPException(ResultCode.PARAM_ERROR, UtilityMessages.ERR_SASL_OPTION_MECH_REQUIRES_PASSWORD.get("SCRAM-SHA-1"));
            tool.getOriginalOut().print(UtilityMessages.INFO_LDAP_TOOL_ENTER_BIND_PASSWORD.get());
            pw = PasswordReader.readPassword();
            tool.getOriginalOut().println();
        } else {
            pw = password;
        }
        String username = options.remove(StaticUtils.toLowerCase(SASL_OPTION_USERNAME));
        if (username == null) {
            throw new LDAPException(ResultCode.PARAM_ERROR, UtilityMessages.ERR_SASL_MISSING_REQUIRED_OPTION.get(SASL_OPTION_USERNAME, "SCRAM-SHA-1"));
        }
        SASLUtils.ensureNoUnsupportedOptions(options, "SCRAM-SHA-1");
        return new SCRAMSHA1BindRequest(username, pw, controls);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    private static SCRAMSHA256BindRequest createSCRAMSHA256BindRequest(@Nullable byte[] password, boolean promptForPassword, @Nullable CommandLineTool tool, @NotNull Map<String, String> options, @Nullable Control[] controls) throws LDAPException {
        byte[] pw;
        if (password == null) {
            if (!promptForPassword) throw new LDAPException(ResultCode.PARAM_ERROR, UtilityMessages.ERR_SASL_OPTION_MECH_REQUIRES_PASSWORD.get("SCRAM-SHA-256"));
            tool.getOriginalOut().print(UtilityMessages.INFO_LDAP_TOOL_ENTER_BIND_PASSWORD.get());
            pw = PasswordReader.readPassword();
            tool.getOriginalOut().println();
        } else {
            pw = password;
        }
        String username = options.remove(StaticUtils.toLowerCase(SASL_OPTION_USERNAME));
        if (username == null) {
            throw new LDAPException(ResultCode.PARAM_ERROR, UtilityMessages.ERR_SASL_MISSING_REQUIRED_OPTION.get(SASL_OPTION_USERNAME, "SCRAM-SHA-256"));
        }
        SASLUtils.ensureNoUnsupportedOptions(options, "SCRAM-SHA-256");
        return new SCRAMSHA256BindRequest(username, pw, controls);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    private static SCRAMSHA512BindRequest createSCRAMSHA512BindRequest(@Nullable byte[] password, boolean promptForPassword, @Nullable CommandLineTool tool, @NotNull Map<String, String> options, @Nullable Control[] controls) throws LDAPException {
        byte[] pw;
        if (password == null) {
            if (!promptForPassword) throw new LDAPException(ResultCode.PARAM_ERROR, UtilityMessages.ERR_SASL_OPTION_MECH_REQUIRES_PASSWORD.get("SCRAM-SHA-512"));
            tool.getOriginalOut().print(UtilityMessages.INFO_LDAP_TOOL_ENTER_BIND_PASSWORD.get());
            pw = PasswordReader.readPassword();
            tool.getOriginalOut().println();
        } else {
            pw = password;
        }
        String username = options.remove(StaticUtils.toLowerCase(SASL_OPTION_USERNAME));
        if (username == null) {
            throw new LDAPException(ResultCode.PARAM_ERROR, UtilityMessages.ERR_SASL_MISSING_REQUIRED_OPTION.get(SASL_OPTION_USERNAME, "SCRAM-SHA-512"));
        }
        SASLUtils.ensureNoUnsupportedOptions(options, "SCRAM-SHA-512");
        return new SCRAMSHA512BindRequest(username, pw, controls);
    }

    @NotNull
    private static UnboundIDCertificatePlusPasswordBindRequest createUnboundIDCertificatePlusPasswordBindRequest(@Nullable byte[] password, @Nullable CommandLineTool tool, @NotNull Map<String, String> options, @Nullable Control[] controls) throws LDAPException {
        byte[] pw;
        if (password == null) {
            tool.getOriginalOut().print(UtilityMessages.INFO_LDAP_TOOL_ENTER_BIND_PASSWORD.get());
            pw = PasswordReader.readPassword();
            tool.getOriginalOut().println();
        } else {
            pw = password;
        }
        SASLUtils.ensureNoUnsupportedOptions(options, "UNBOUNDID-CERTIFICATE-PLUS-PASSWORD");
        return new UnboundIDCertificatePlusPasswordBindRequest(pw, controls);
    }

    @NotNull
    private static UnboundIDDeliveredOTPBindRequest createUNBOUNDIDDeliveredOTPBindRequest(@Nullable byte[] password, @NotNull Map<String, String> options, Control ... controls) throws LDAPException {
        if (password != null) {
            throw new LDAPException(ResultCode.PARAM_ERROR, UtilityMessages.ERR_SASL_OPTION_MECH_DOESNT_ACCEPT_PASSWORD.get("UNBOUNDID-DELIVERED-OTP"));
        }
        String authID = options.remove(StaticUtils.toLowerCase(SASL_OPTION_AUTH_ID));
        if (authID == null) {
            throw new LDAPException(ResultCode.PARAM_ERROR, UtilityMessages.ERR_SASL_MISSING_REQUIRED_OPTION.get(SASL_OPTION_AUTH_ID, "UNBOUNDID-DELIVERED-OTP"));
        }
        String otp = options.remove(StaticUtils.toLowerCase(SASL_OPTION_OTP));
        if (otp == null) {
            throw new LDAPException(ResultCode.PARAM_ERROR, UtilityMessages.ERR_SASL_MISSING_REQUIRED_OPTION.get(SASL_OPTION_OTP, "UNBOUNDID-DELIVERED-OTP"));
        }
        String authzID = options.remove(StaticUtils.toLowerCase(SASL_OPTION_AUTHZ_ID));
        SASLUtils.ensureNoUnsupportedOptions(options, "UNBOUNDID-DELIVERED-OTP");
        return new UnboundIDDeliveredOTPBindRequest(authID, authzID, otp, controls);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    private static SingleUseTOTPBindRequest createUNBOUNDIDTOTPBindRequest(@Nullable byte[] password, @Nullable CommandLineTool tool, @NotNull Map<String, String> options, Control ... controls) throws LDAPException {
        String authID = options.remove(StaticUtils.toLowerCase(SASL_OPTION_AUTH_ID));
        if (authID == null) {
            throw new LDAPException(ResultCode.PARAM_ERROR, UtilityMessages.ERR_SASL_MISSING_REQUIRED_OPTION.get(SASL_OPTION_AUTH_ID, "UNBOUNDID-TOTP"));
        }
        String totpPassword = options.remove(StaticUtils.toLowerCase(SASL_OPTION_TOTP_PASSWORD));
        if (totpPassword == null) {
            throw new LDAPException(ResultCode.PARAM_ERROR, UtilityMessages.ERR_SASL_MISSING_REQUIRED_OPTION.get(SASL_OPTION_TOTP_PASSWORD, "UNBOUNDID-TOTP"));
        }
        byte[] pwBytes = password;
        String authzID = options.remove(StaticUtils.toLowerCase(SASL_OPTION_AUTHZ_ID));
        String promptStr = options.remove(StaticUtils.toLowerCase(SASL_OPTION_PROMPT_FOR_STATIC_PW));
        if (promptStr != null) {
            if (promptStr.equalsIgnoreCase("true")) {
                if (pwBytes != null) throw new LDAPException(ResultCode.PARAM_ERROR, UtilityMessages.ERR_SASL_PROMPT_FOR_PROVIDED_PW.get(SASL_OPTION_PROMPT_FOR_STATIC_PW));
                tool.getOriginalOut().print(UtilityMessages.INFO_SASL_ENTER_STATIC_PW.get());
                pwBytes = PasswordReader.readPassword();
                tool.getOriginalOut().println();
            } else if (!promptStr.equalsIgnoreCase("false")) {
                throw new LDAPException(ResultCode.PARAM_ERROR, UtilityMessages.ERR_SASL_PROMPT_FOR_STATIC_PW_BAD_VALUE.get(SASL_OPTION_PROMPT_FOR_STATIC_PW));
            }
        }
        SASLUtils.ensureNoUnsupportedOptions(options, "UNBOUNDID-TOTP");
        return new SingleUseTOTPBindRequest(authID, authzID, totpPassword, pwBytes, controls);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    private static UnboundIDYubiKeyOTPBindRequest createUNBOUNDIDYUBIKEYOTPBindRequest(@Nullable byte[] password, @Nullable CommandLineTool tool, @NotNull Map<String, String> options, Control ... controls) throws LDAPException {
        String authID = options.remove(StaticUtils.toLowerCase(SASL_OPTION_AUTH_ID));
        if (authID == null) {
            throw new LDAPException(ResultCode.PARAM_ERROR, UtilityMessages.ERR_SASL_MISSING_REQUIRED_OPTION.get(SASL_OPTION_AUTH_ID, "UNBOUNDID-YUBIKEY-OTP"));
        }
        String otp = options.remove(StaticUtils.toLowerCase(SASL_OPTION_OTP));
        if (otp == null) {
            throw new LDAPException(ResultCode.PARAM_ERROR, UtilityMessages.ERR_SASL_MISSING_REQUIRED_OPTION.get(SASL_OPTION_OTP, "UNBOUNDID-YUBIKEY-OTP"));
        }
        String authzID = options.remove(StaticUtils.toLowerCase(SASL_OPTION_AUTHZ_ID));
        byte[] pwBytes = password;
        String promptStr = options.remove(StaticUtils.toLowerCase(SASL_OPTION_PROMPT_FOR_STATIC_PW));
        if (promptStr != null) {
            if (promptStr.equalsIgnoreCase("true")) {
                if (pwBytes != null) throw new LDAPException(ResultCode.PARAM_ERROR, UtilityMessages.ERR_SASL_PROMPT_FOR_PROVIDED_PW.get(SASL_OPTION_PROMPT_FOR_STATIC_PW));
                tool.getOriginalOut().print(UtilityMessages.INFO_SASL_ENTER_STATIC_PW.get());
                pwBytes = PasswordReader.readPassword();
                tool.getOriginalOut().println();
            } else if (!promptStr.equalsIgnoreCase("false")) {
                throw new LDAPException(ResultCode.PARAM_ERROR, UtilityMessages.ERR_SASL_PROMPT_FOR_STATIC_PW_BAD_VALUE.get(SASL_OPTION_PROMPT_FOR_STATIC_PW));
            }
        }
        SASLUtils.ensureNoUnsupportedOptions(options, "UNBOUNDID-YUBIKEY-OTP");
        return new UnboundIDYubiKeyOTPBindRequest(authID, authzID, pwBytes, otp, controls);
    }

    @NotNull
    private static Map<String, String> parseOptions(@Nullable List<String> options) throws LDAPException {
        if (options == null) {
            return new HashMap<String, String>(0);
        }
        HashMap<String, String> m = new HashMap<String, String>(StaticUtils.computeMapCapacity(options.size()));
        for (String s : options) {
            int equalPos = s.indexOf(61);
            if (equalPos < 0) {
                throw new LDAPException(ResultCode.PARAM_ERROR, UtilityMessages.ERR_SASL_OPTION_MISSING_EQUAL.get(s));
            }
            if (equalPos == 0) {
                throw new LDAPException(ResultCode.PARAM_ERROR, UtilityMessages.ERR_SASL_OPTION_STARTS_WITH_EQUAL.get(s));
            }
            String name = s.substring(0, equalPos);
            String value = s.substring(equalPos + 1);
            if (m.put(StaticUtils.toLowerCase(name), value) == null) continue;
            throw new LDAPException(ResultCode.PARAM_ERROR, UtilityMessages.ERR_SASL_OPTION_NOT_MULTI_VALUED.get(name));
        }
        return m;
    }

    @InternalUseOnly
    public static void ensureNoUnsupportedOptions(@NotNull Map<String, String> options, @NotNull String mechanism) throws LDAPException {
        Iterator<String> i$;
        if (!options.isEmpty() && (i$ = options.keySet().iterator()).hasNext()) {
            String s = i$.next();
            throw new LDAPException(ResultCode.PARAM_ERROR, UtilityMessages.ERR_SASL_OPTION_UNSUPPORTED_FOR_MECH.get(s, mechanism));
        }
    }

    static boolean getBooleanValue(@NotNull Map<String, String> m, @NotNull String o, boolean d) throws LDAPException {
        String s = StaticUtils.toLowerCase(m.remove(StaticUtils.toLowerCase(o)));
        if (s == null) {
            return d;
        }
        if (s.equals("true") || s.equals("t") || s.equals("yes") || s.equals("y") || s.equals("on") || s.equals("1")) {
            return true;
        }
        if (s.equals("false") || s.equals("f") || s.equals("no") || s.equals("n") || s.equals("off") || s.equals("0")) {
            return false;
        }
        throw new LDAPException(ResultCode.PARAM_ERROR, UtilityMessages.ERR_SASL_OPTION_MALFORMED_BOOLEAN_VALUE.get(o));
    }

    @NotNull
    public static String getUsageString(int maxWidth) {
        return SASLUtils.getUsageString(null, maxWidth);
    }

    @NotNull
    public static String getUsageString(@Nullable String mechanism, int maxWidth) {
        StringBuilder buffer = new StringBuilder();
        for (String line : SASLUtils.getUsage(mechanism, maxWidth)) {
            buffer.append(line);
            buffer.append(StaticUtils.EOL);
        }
        return buffer.toString();
    }

    @NotNull
    public static List<String> getUsage(int maxWidth) {
        return SASLUtils.getUsage(null, maxWidth);
    }

    @NotNull
    public static List<String> getUsage(@Nullable String mechanism, int maxWidth) {
        ArrayList<String> lines = new ArrayList<String>(100);
        boolean first = true;
        for (SASLMechanismInfo i : SASLUtils.getSupportedSASLMechanisms()) {
            if (mechanism != null && !i.getName().equalsIgnoreCase(mechanism)) continue;
            if (first) {
                first = false;
            } else {
                lines.add("");
                lines.add("");
            }
            lines.addAll(StaticUtils.wrapLine(UtilityMessages.INFO_SASL_HELP_MECHANISM.get(i.getName()), maxWidth));
            lines.add("");
            for (String line : StaticUtils.wrapLine(i.getDescription(), maxWidth - 4)) {
                lines.add("  " + line);
            }
            lines.add("");
            for (String line : StaticUtils.wrapLine(UtilityMessages.INFO_SASL_HELP_MECHANISM_OPTIONS.get(i.getName()), maxWidth - 4)) {
                lines.add("  " + line);
            }
            if (i.acceptsPassword()) {
                lines.add("");
                if (i.requiresPassword()) {
                    for (String line : StaticUtils.wrapLine(UtilityMessages.INFO_SASL_HELP_PASSWORD_REQUIRED.get(i.getName()), maxWidth - 4)) {
                        lines.add("  " + line);
                    }
                } else {
                    for (String line : StaticUtils.wrapLine(UtilityMessages.INFO_SASL_HELP_PASSWORD_OPTIONAL.get(i.getName()), maxWidth - 4)) {
                        lines.add("  " + line);
                    }
                }
            }
            for (SASLOption o : i.getOptions()) {
                lines.add("");
                lines.add("  * " + o.getName());
                for (String line : StaticUtils.wrapLine(o.getDescription(), maxWidth - 14)) {
                    lines.add("       " + line);
                }
            }
        }
        if (mechanism != null && lines.isEmpty()) {
            return SASLUtils.getUsage(null, maxWidth);
        }
        return lines;
    }

    static {
        TreeMap<String, SASLMechanismInfo> m = new TreeMap<String, SASLMechanismInfo>();
        m.put(StaticUtils.toLowerCase("ANONYMOUS"), new SASLMechanismInfo("ANONYMOUS", UtilityMessages.INFO_SASL_ANONYMOUS_DESCRIPTION.get(), false, false, new SASLOption(SASL_OPTION_TRACE, UtilityMessages.INFO_SASL_ANONYMOUS_OPTION_TRACE.get(), false, false)));
        m.put(StaticUtils.toLowerCase("CRAM-MD5"), new SASLMechanismInfo("CRAM-MD5", UtilityMessages.INFO_SASL_CRAM_MD5_DESCRIPTION.get(), true, true, new SASLOption(SASL_OPTION_AUTH_ID, UtilityMessages.INFO_SASL_CRAM_MD5_OPTION_AUTH_ID.get(), true, false)));
        m.put(StaticUtils.toLowerCase("DIGEST-MD5"), new SASLMechanismInfo("DIGEST-MD5", UtilityMessages.INFO_SASL_DIGEST_MD5_DESCRIPTION.get(), true, true, new SASLOption(SASL_OPTION_AUTH_ID, UtilityMessages.INFO_SASL_DIGEST_MD5_OPTION_AUTH_ID.get(), true, false), new SASLOption(SASL_OPTION_AUTHZ_ID, UtilityMessages.INFO_SASL_DIGEST_MD5_OPTION_AUTHZ_ID.get(), false, false), new SASLOption(SASL_OPTION_REALM, UtilityMessages.INFO_SASL_DIGEST_MD5_OPTION_REALM.get(), false, false), new SASLOption(SASL_OPTION_QOP, UtilityMessages.INFO_SASL_DIGEST_MD5_OPTION_QOP.get(), false, false)));
        m.put(StaticUtils.toLowerCase("EXTERNAL"), new SASLMechanismInfo("EXTERNAL", UtilityMessages.INFO_SASL_EXTERNAL_DESCRIPTION.get(), false, false, new SASLOption[0]));
        m.put(StaticUtils.toLowerCase("GSSAPI"), new SASLMechanismInfo("GSSAPI", UtilityMessages.INFO_SASL_GSSAPI_DESCRIPTION.get(), true, false, new SASLOption(SASL_OPTION_AUTH_ID, UtilityMessages.INFO_SASL_GSSAPI_OPTION_AUTH_ID.get(), true, false), new SASLOption(SASL_OPTION_AUTHZ_ID, UtilityMessages.INFO_SASL_GSSAPI_OPTION_AUTHZ_ID.get(), false, false), new SASLOption(SASL_OPTION_CONFIG_FILE, UtilityMessages.INFO_SASL_GSSAPI_OPTION_CONFIG_FILE.get(), false, false), new SASLOption(SASL_OPTION_DEBUG, UtilityMessages.INFO_SASL_GSSAPI_OPTION_DEBUG.get(), false, false), new SASLOption(SASL_OPTION_KDC_ADDRESS, UtilityMessages.INFO_SASL_GSSAPI_OPTION_KDC_ADDRESS.get(), false, false), new SASLOption(SASL_OPTION_PROTOCOL, UtilityMessages.INFO_SASL_GSSAPI_OPTION_PROTOCOL.get(), false, false), new SASLOption(SASL_OPTION_REALM, UtilityMessages.INFO_SASL_GSSAPI_OPTION_REALM.get(), false, false), new SASLOption(SASL_OPTION_QOP, UtilityMessages.INFO_SASL_GSSAPI_OPTION_QOP.get(), false, false), new SASLOption(SASL_OPTION_RENEW_TGT, UtilityMessages.INFO_SASL_GSSAPI_OPTION_RENEW_TGT.get(), false, false), new SASLOption(SASL_OPTION_REQUIRE_CACHE, UtilityMessages.INFO_SASL_GSSAPI_OPTION_REQUIRE_TICKET_CACHE.get(), false, false), new SASLOption(SASL_OPTION_TICKET_CACHE_PATH, UtilityMessages.INFO_SASL_GSSAPI_OPTION_TICKET_CACHE.get(), false, false), new SASLOption(SASL_OPTION_USE_TICKET_CACHE, UtilityMessages.INFO_SASL_GSSAPI_OPTION_USE_TICKET_CACHE.get(), false, false)));
        m.put(StaticUtils.toLowerCase("OAUTHBEARER"), new SASLMechanismInfo("OAUTHBEARER", UtilityMessages.INFO_SASL_PLAIN_DESCRIPTION.get(), false, false, new SASLOption(SASL_OPTION_ACCESS_TOKEN, UtilityMessages.INFO_SASL_OAUTHBEARER_OPTION_ACCESS_TOKEN.get(), false, false)));
        m.put(StaticUtils.toLowerCase("PLAIN"), new SASLMechanismInfo("PLAIN", UtilityMessages.INFO_SASL_PLAIN_DESCRIPTION.get(), true, true, new SASLOption(SASL_OPTION_AUTH_ID, UtilityMessages.INFO_SASL_PLAIN_OPTION_AUTH_ID.get(), true, false), new SASLOption(SASL_OPTION_AUTHZ_ID, UtilityMessages.INFO_SASL_PLAIN_OPTION_AUTHZ_ID.get(), false, false)));
        m.put(StaticUtils.toLowerCase("SCRAM-SHA-1"), new SASLMechanismInfo("SCRAM-SHA-1", UtilityMessages.INFO_SASL_SCRAM_SHA_1_DESCRIPTION.get(), true, true, new SASLOption(SASL_OPTION_USERNAME, UtilityMessages.INFO_SASL_SCRAM_OPTION_USERNAME.get(), true, false)));
        m.put(StaticUtils.toLowerCase("SCRAM-SHA-256"), new SASLMechanismInfo("SCRAM-SHA-256", UtilityMessages.INFO_SASL_SCRAM_SHA_256_DESCRIPTION.get(), true, true, new SASLOption(SASL_OPTION_USERNAME, UtilityMessages.INFO_SASL_SCRAM_OPTION_USERNAME.get(), true, false)));
        m.put(StaticUtils.toLowerCase("SCRAM-SHA-512"), new SASLMechanismInfo("SCRAM-SHA-512", UtilityMessages.INFO_SASL_SCRAM_SHA_512_DESCRIPTION.get(), true, true, new SASLOption(SASL_OPTION_USERNAME, UtilityMessages.INFO_SASL_SCRAM_OPTION_USERNAME.get(), true, false)));
        m.put(StaticUtils.toLowerCase("UNBOUNDID-CERTIFICATE-PLUS-PASSWORD"), new SASLMechanismInfo("UNBOUNDID-CERTIFICATE-PLUS-PASSWORD", UtilityMessages.INFO_SASL_UNBOUNDID_CERT_PLUS_PASSWORD_DESCRIPTION.get(), true, true, new SASLOption[0]));
        m.put(StaticUtils.toLowerCase("UNBOUNDID-DELIVERED-OTP"), new SASLMechanismInfo("UNBOUNDID-DELIVERED-OTP", UtilityMessages.INFO_SASL_UNBOUNDID_DELIVERED_OTP_DESCRIPTION.get(), false, false, new SASLOption(SASL_OPTION_AUTH_ID, UtilityMessages.INFO_SASL_UNBOUNDID_TOTP_OPTION_AUTH_ID.get(), true, false), new SASLOption(SASL_OPTION_AUTHZ_ID, UtilityMessages.INFO_SASL_UNBOUNDID_TOTP_OPTION_AUTHZ_ID.get(), false, false), new SASLOption(SASL_OPTION_OTP, UtilityMessages.INFO_SASL_UNBOUNDID_DELIVERED_OTP_OPTION_OTP.get(), true, false)));
        m.put(StaticUtils.toLowerCase("UNBOUNDID-TOTP"), new SASLMechanismInfo("UNBOUNDID-TOTP", UtilityMessages.INFO_SASL_UNBOUNDID_TOTP_DESCRIPTION.get(), true, false, new SASLOption(SASL_OPTION_AUTH_ID, UtilityMessages.INFO_SASL_UNBOUNDID_TOTP_OPTION_AUTH_ID.get(), true, false), new SASLOption(SASL_OPTION_AUTHZ_ID, UtilityMessages.INFO_SASL_UNBOUNDID_TOTP_OPTION_AUTHZ_ID.get(), false, false), new SASLOption(SASL_OPTION_PROMPT_FOR_STATIC_PW, UtilityMessages.INFO_SASL_UNBOUNDID_TOTP_OPTION_PROMPT_FOR_PW.get(), false, false), new SASLOption(SASL_OPTION_TOTP_PASSWORD, UtilityMessages.INFO_SASL_UNBOUNDID_TOTP_OPTION_TOTP_PASSWORD.get(), true, false)));
        m.put(StaticUtils.toLowerCase("UNBOUNDID-YUBIKEY-OTP"), new SASLMechanismInfo("UNBOUNDID-YUBIKEY-OTP", UtilityMessages.INFO_SASL_UNBOUNDID_YUBIKEY_OTP_DESCRIPTION.get(), true, false, new SASLOption(SASL_OPTION_AUTH_ID, UtilityMessages.INFO_SASL_UNBOUNDID_YUBIKEY_OTP_OPTION_AUTH_ID.get(), true, false), new SASLOption(SASL_OPTION_AUTHZ_ID, UtilityMessages.INFO_SASL_UNBOUNDID_YUBIKEY_OTP_OPTION_AUTHZ_ID.get(), false, false), new SASLOption(SASL_OPTION_OTP, UtilityMessages.INFO_SASL_UNBOUNDID_YUBIKEY_OTP_OPTION_OTP.get(), true, false), new SASLOption(SASL_OPTION_PROMPT_FOR_STATIC_PW, UtilityMessages.INFO_SASL_UNBOUNDID_YUBIKEY_OTP_OPTION_PROMPT_FOR_PW.get(), false, false)));
        SASL_MECHANISMS = Collections.unmodifiableMap(m);
    }
}

