/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.methods;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import javax.inject.Inject;
import org.apache.james.jmap.draft.methods.UpdateMessagePatchValidator;
import org.apache.james.jmap.draft.model.UpdateMessagePatch;

public class UpdateMessagePatchConverter {
    private final ObjectMapper jsonParser;
    private final UpdateMessagePatchValidator validator;

    @Inject
    @VisibleForTesting
    UpdateMessagePatchConverter(ObjectMapper jsonParser, UpdateMessagePatchValidator validator) {
        this.jsonParser = jsonParser;
        this.validator = validator;
    }

    public UpdateMessagePatch fromJsonNode(ObjectNode updatePatchNode) {
        if (updatePatchNode == null || updatePatchNode.isNull() || updatePatchNode.isMissingNode()) {
            throw new IllegalArgumentException("updatePatchNode");
        }
        if (!this.validator.isValid(updatePatchNode)) {
            return UpdateMessagePatch.builder().validationResult(this.validator.validate(updatePatchNode)).build();
        }
        try {
            return (UpdateMessagePatch)this.jsonParser.readerFor(UpdateMessagePatch.class).readValue((JsonNode)updatePatchNode);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

