/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.cassandra.upload;

import java.time.Clock;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.util.function.Predicate;
import javax.inject.Inject;
import org.apache.james.jmap.cassandra.upload.UploadBucketName;

public class BucketNameGenerator {
    private final Clock clock;

    @Inject
    public BucketNameGenerator(Clock clock) {
        this.clock = clock;
    }

    public UploadBucketName current() {
        int weekCount = this.currentWeekCount();
        return new UploadBucketName(weekCount);
    }

    public Predicate<UploadBucketName> evictionPredicate() {
        int currentWeekCount = this.currentWeekCount();
        return uploadBucketName -> uploadBucketName.getWeekNumber() < currentWeekCount - 1;
    }

    private int currentWeekCount() {
        return Math.toIntExact(ChronoUnit.WEEKS.between(LocalDate.ofEpochDay(0L), LocalDate.ofInstant(this.clock.instant(), ZoneOffset.UTC)));
    }
}

