/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils.collections;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;

public final class SparseArrayLinkedList<E> {
    private static final int SPARSE_ARRAY_DEFAULT_CAPACITY = 16;
    private final LinkedList<SparseArray<E>> list;
    private final int sparseArrayCapacity;
    private long size;

    public static <E> long removeFromSparseArrayList(List<SparseArray<E>> sparseArrayList, Predicate<? super E> filter) {
        if (filter == null) {
            return 0L;
        }
        long removed = 0L;
        Iterator<SparseArray<E>> iter = sparseArrayList.iterator();
        while (iter.hasNext()) {
            SparseArray<? super E> sparseArray = iter.next();
            int justRemoved = sparseArray.remove(filter);
            removed += (long)justRemoved;
            if (justRemoved <= 0 || sparseArrayList.size() <= 1 || sparseArray.size() != 0) continue;
            iter.remove();
        }
        return removed;
    }

    public static <E> void addToSparseArrayList(List<SparseArray<E>> sparseArrayList, E e, int sparseArrayCapacity) {
        int size = sparseArrayList.size();
        if (size == 0 || !sparseArrayList.get(size - 1).add(e)) {
            SparseArray<E> sparseArray = new SparseArray<E>(sparseArrayCapacity);
            sparseArray.add(e);
            sparseArrayList.add(sparseArray);
        }
    }

    public static <E> long clearSparseArrayList(List<SparseArray<E>> sparseArrayList, Consumer<? super E> consumer) {
        int size = sparseArrayList.size();
        long count = 0L;
        if (size > 0) {
            for (int i = 0; i < size - 1; ++i) {
                SparseArray<? super E> removed = sparseArrayList.remove(0);
                count += (long)removed.clear(consumer);
            }
            count += (long)sparseArrayList.get(0).clear(consumer);
        }
        return count;
    }

    public SparseArrayLinkedList() {
        this(16);
    }

    public SparseArrayLinkedList(int sparseArrayCapacity) {
        if (sparseArrayCapacity <= 0) {
            throw new IllegalArgumentException("sparseArrayCapacity must be > 0");
        }
        this.list = new LinkedList();
        this.size = 0L;
        this.sparseArrayCapacity = sparseArrayCapacity;
    }

    public void add(E e) {
        Objects.requireNonNull(e, "e cannot be null");
        SparseArrayLinkedList.addToSparseArrayList(this.list, e, this.sparseArrayCapacity);
        ++this.size;
    }

    public long remove(Predicate<? super E> filter) {
        if (this.size == 0L) {
            return 0L;
        }
        long removed = SparseArrayLinkedList.removeFromSparseArrayList(this.list, filter);
        this.size -= removed;
        assert (this.size >= 0L);
        return removed;
    }

    public long clear(Consumer<? super E> consumer) {
        if (this.size == 0L) {
            return 0L;
        }
        long removed = SparseArrayLinkedList.clearSparseArrayList(this.list, consumer);
        assert (removed == this.size);
        this.size = 0L;
        return removed;
    }

    public long size() {
        return this.size;
    }

    public int sparseArrayCapacity() {
        return this.sparseArrayCapacity;
    }

    public int sparseArraysCount() {
        return this.list.size();
    }

    private static final class SparseArray<E> {
        private final Object[] elements;
        private int size;
        private int tail;

        private SparseArray(int capacity) {
            this.elements = new Object[capacity];
            this.size = 0;
            this.tail = 0;
        }

        private boolean add(E e) {
            int capacity = this.elements.length;
            if (this.tail == capacity) {
                return false;
            }
            this.elements[this.tail] = e;
            ++this.tail;
            ++this.size;
            return true;
        }

        private int remove(Predicate<? super E> filter) {
            if (this.size == 0) {
                return 0;
            }
            int removed = 0;
            Object[] elements = this.elements;
            int visited = 0;
            int originalSize = this.size;
            int capacity = elements.length;
            for (int i = 0; i < capacity; ++i) {
                Object e = elements[i];
                if (e == null) continue;
                if (filter.test(e)) {
                    elements[i] = null;
                    ++removed;
                } else {
                    this.tail = i + 1;
                }
                if (++visited == originalSize) break;
            }
            this.size -= removed;
            if (this.size == 0) {
                this.tail = 0;
            }
            return removed;
        }

        public int clear(Consumer<? super E> consumer) {
            int originalSize = this.size;
            if (originalSize == 0) {
                return 0;
            }
            int visited = 0;
            for (Object e : this.elements) {
                if (e == null) continue;
                if (consumer != null) {
                    consumer.accept(e);
                }
                elements[i] = null;
                --this.size;
                if (++visited == originalSize) break;
            }
            assert (this.size == 0);
            this.tail = 0;
            return originalSize;
        }

        private int size() {
            return this.size;
        }
    }
}

