/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.events;

import com.google.common.collect.ImmutableList;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.james.backends.rabbitmq.RabbitMQConfiguration;
import org.apache.james.backends.rabbitmq.ReactorRabbitMQChannelPool;
import org.apache.james.backends.rabbitmq.ReceiverProvider;
import org.apache.james.events.Event;
import org.apache.james.events.EventBusId;
import org.apache.james.events.EventDeadLetters;
import org.apache.james.events.EventListener;
import org.apache.james.events.EventSerializer;
import org.apache.james.events.Group;
import org.apache.james.events.GroupAlreadyRegistered;
import org.apache.james.events.GroupRegistration;
import org.apache.james.events.GroupRegistrationNotFound;
import org.apache.james.events.ListenerExecutor;
import org.apache.james.events.NamingStrategy;
import org.apache.james.events.Registration;
import org.apache.james.events.RetryBackoffConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;
import reactor.rabbitmq.AcknowledgableDelivery;
import reactor.rabbitmq.BindingSpecification;
import reactor.rabbitmq.ConsumeOptions;
import reactor.rabbitmq.QueueSpecification;
import reactor.rabbitmq.Receiver;
import reactor.rabbitmq.Sender;
import reactor.util.retry.Retry;

class GroupRegistrationHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(GroupRegistrationHandler.class);
    private final GroupRegistration.WorkQueueName queueName;
    static final Group GROUP = new GroupRegistrationHandlerGroup();
    private final NamingStrategy namingStrategy;
    private final Map<Group, GroupRegistration> groupRegistrations;
    private final EventSerializer eventSerializer;
    private final ReactorRabbitMQChannelPool channelPool;
    private final Sender sender;
    private final ReceiverProvider receiverProvider;
    private final RetryBackoffConfiguration retryBackoff;
    private final EventDeadLetters eventDeadLetters;
    private final ListenerExecutor listenerExecutor;
    private final RabbitMQConfiguration configuration;
    private Optional<Disposable> consumer;

    GroupRegistrationHandler(NamingStrategy namingStrategy, EventSerializer eventSerializer, ReactorRabbitMQChannelPool channelPool, Sender sender, ReceiverProvider receiverProvider, RetryBackoffConfiguration retryBackoff, EventDeadLetters eventDeadLetters, ListenerExecutor listenerExecutor, EventBusId eventBusId, RabbitMQConfiguration configuration) {
        this.namingStrategy = namingStrategy;
        this.eventSerializer = eventSerializer;
        this.channelPool = channelPool;
        this.sender = sender;
        this.receiverProvider = receiverProvider;
        this.retryBackoff = retryBackoff;
        this.eventDeadLetters = eventDeadLetters;
        this.listenerExecutor = listenerExecutor;
        this.configuration = configuration;
        this.groupRegistrations = new ConcurrentHashMap<Group, GroupRegistration>();
        this.queueName = namingStrategy.workQueue(GROUP);
        this.consumer = Optional.empty();
    }

    GroupRegistration retrieveGroupRegistration(Group group) {
        return Optional.ofNullable(this.groupRegistrations.get(group)).orElseThrow(() -> new GroupRegistrationNotFound(group));
    }

    public void start() {
        this.channelPool.createWorkQueue(QueueSpecification.queue((String)this.queueName.asString()).durable(true).exclusive(false).autoDelete(false).arguments((Map)this.configuration.workQueueArgumentsBuilder(false).deadLetter(this.namingStrategy.deadLetterExchange()).build()), BindingSpecification.binding().exchange(this.namingStrategy.exchange()).queue(this.queueName.asString()).routingKey("")).retryWhen((Retry)Retry.backoff((long)this.retryBackoff.getMaxRetries(), (Duration)this.retryBackoff.getFirstBackoff()).jitter(this.retryBackoff.getJitterFactor()).scheduler(Schedulers.elastic())).block();
        this.consumer = Optional.of(this.consumeWorkQueue());
    }

    private Disposable consumeWorkQueue() {
        return Flux.using(() -> ((ReceiverProvider)this.receiverProvider).createReceiver(), receiver -> receiver.consumeManualAck(this.queueName.asString(), new ConsumeOptions().qos(10)), Receiver::close).publishOn(Schedulers.parallel()).filter(delivery -> Objects.nonNull(delivery.getBody())).flatMap(this::deliver, 10).subscribeOn(Schedulers.elastic()).subscribe();
    }

    private Mono<Void> deliver(AcknowledgableDelivery acknowledgableDelivery) {
        byte[] eventAsBytes = acknowledgableDelivery.getBody();
        return this.deserializeEvent(eventAsBytes).flatMapIterable(aa -> (Iterable)this.groupRegistrations.values().stream().map(group -> Pair.of((Object)group, (Object)aa)).collect(ImmutableList.toImmutableList())).flatMap(event -> ((GroupRegistration)event.getLeft()).runListenerReliably(0, (Event)event.getRight())).then(Mono.fromRunnable(() -> ((AcknowledgableDelivery)acknowledgableDelivery).ack()).subscribeOn(Schedulers.elastic())).then().onErrorResume(e -> {
            LOGGER.error("Unable to process delivery for group {}", (Object)GROUP, e);
            return Mono.fromRunnable(() -> acknowledgableDelivery.nack(false)).subscribeOn(Schedulers.elastic()).then();
        });
    }

    private Mono<Event> deserializeEvent(byte[] eventAsBytes) {
        return Mono.fromCallable(() -> this.eventSerializer.fromBytes(eventAsBytes)).subscribeOn(Schedulers.parallel());
    }

    void stop() {
        this.groupRegistrations.values().forEach(GroupRegistration::unregister);
        this.consumer.ifPresent(Disposable::dispose);
    }

    void restart() {
        Optional<Disposable> previousConsumer = this.consumer;
        this.consumer = Optional.of(this.consumeWorkQueue());
        previousConsumer.filter(Predicate.not(Disposable::isDisposed)).ifPresent(Disposable::dispose);
        this.groupRegistrations.values().forEach(GroupRegistration::restart);
    }

    Registration register(EventListener.ReactiveEventListener listener, Group group) {
        if (this.groupRegistrations.isEmpty()) {
            this.start();
        }
        return this.groupRegistrations.compute(group, (groupToRegister, oldGroupRegistration) -> {
            if (oldGroupRegistration != null) {
                throw new GroupAlreadyRegistered(group);
            }
            return this.newGroupRegistration(listener, (Group)groupToRegister);
        }).start();
    }

    private GroupRegistration newGroupRegistration(EventListener.ReactiveEventListener listener, Group group) {
        return new GroupRegistration(this.namingStrategy, this.channelPool, this.sender, this.receiverProvider, this.eventSerializer, listener, group, this.retryBackoff, this.eventDeadLetters, () -> this.groupRegistrations.remove(group), this.listenerExecutor, this.configuration);
    }

    public static class GroupRegistrationHandlerGroup
    extends Group {
    }
}

