/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra.mail;

import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import javax.inject.Inject;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.cassandra.ids.CassandraId;
import org.apache.james.mailbox.model.MessageRange;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CassandraDeletedMessageDAO {
    private static final String UID_TO = "uid_to";
    private static final String UID_FROM = "uid_from";
    private final CassandraAsyncExecutor cassandraAsyncExecutor;
    private final PreparedStatement addStatement;
    private final PreparedStatement deleteStatement;
    private final PreparedStatement deleteAllStatement;
    private final PreparedStatement selectAllUidStatement;
    private final PreparedStatement selectOneUidStatement;
    private final PreparedStatement selectBetweenUidStatement;
    private final PreparedStatement selectFromUidStatement;

    @Inject
    public CassandraDeletedMessageDAO(Session session) {
        this.cassandraAsyncExecutor = new CassandraAsyncExecutor(session);
        this.addStatement = this.prepareAddStatement(session);
        this.deleteStatement = this.prepareDeleteStatement(session);
        this.deleteAllStatement = this.prepareDeleteAllStatement(session);
        this.selectAllUidStatement = this.prepareAllUidStatement(session);
        this.selectOneUidStatement = this.prepareOneUidStatement(session);
        this.selectBetweenUidStatement = this.prepareBetweenUidStatement(session);
        this.selectFromUidStatement = this.prepareFromUidStatement(session);
    }

    private PreparedStatement prepareAllUidStatement(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.select((String[])new String[]{"uid"}).from("messageDeleted").where(QueryBuilder.eq((String)"mailboxId", (Object)QueryBuilder.bindMarker((String)"mailboxId"))));
    }

    private PreparedStatement prepareOneUidStatement(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.select((String[])new String[]{"uid"}).from("messageDeleted").where(QueryBuilder.eq((String)"mailboxId", (Object)QueryBuilder.bindMarker((String)"mailboxId"))).and(QueryBuilder.eq((String)"uid", (Object)QueryBuilder.bindMarker((String)"uid"))));
    }

    private PreparedStatement prepareBetweenUidStatement(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.select((String[])new String[]{"uid"}).from("messageDeleted").where(QueryBuilder.eq((String)"mailboxId", (Object)QueryBuilder.bindMarker((String)"mailboxId"))).and(QueryBuilder.gte((String)"uid", (Object)QueryBuilder.bindMarker((String)UID_FROM))).and(QueryBuilder.lte((String)"uid", (Object)QueryBuilder.bindMarker((String)UID_TO))));
    }

    private PreparedStatement prepareFromUidStatement(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.select((String[])new String[]{"uid"}).from("messageDeleted").where(QueryBuilder.eq((String)"mailboxId", (Object)QueryBuilder.bindMarker((String)"mailboxId"))).and(QueryBuilder.gte((String)"uid", (Object)QueryBuilder.bindMarker((String)UID_FROM))));
    }

    private PreparedStatement prepareDeleteStatement(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.delete().from("messageDeleted").where(QueryBuilder.eq((String)"mailboxId", (Object)QueryBuilder.bindMarker((String)"mailboxId"))).and(QueryBuilder.eq((String)"uid", (Object)QueryBuilder.bindMarker((String)"uid"))));
    }

    private PreparedStatement prepareDeleteAllStatement(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.delete().from("messageDeleted").where(QueryBuilder.eq((String)"mailboxId", (Object)QueryBuilder.bindMarker((String)"mailboxId"))));
    }

    private PreparedStatement prepareAddStatement(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.insertInto((String)"messageDeleted").value("mailboxId", (Object)QueryBuilder.bindMarker((String)"mailboxId")).value("uid", (Object)QueryBuilder.bindMarker((String)"uid")));
    }

    public Mono<Void> addDeleted(CassandraId cassandraId, MessageUid uid) {
        return this.cassandraAsyncExecutor.executeVoid((Statement)this.addStatement.bind().setUUID("mailboxId", cassandraId.asUuid()).setLong("uid", uid.asLong()));
    }

    public Mono<Void> removeDeleted(CassandraId cassandraId, MessageUid uid) {
        return this.cassandraAsyncExecutor.executeVoid((Statement)this.deleteStatement.bind().setUUID("mailboxId", cassandraId.asUuid()).setLong("uid", uid.asLong()));
    }

    public Mono<Void> removeAll(CassandraId cassandraId) {
        return this.cassandraAsyncExecutor.executeVoid((Statement)this.deleteAllStatement.bind().setUUID("mailboxId", cassandraId.asUuid()));
    }

    public Flux<MessageUid> retrieveDeletedMessage(CassandraId cassandraId, MessageRange range) {
        return this.retrieveResultSetOfDeletedMessage(cassandraId, range).map(row -> MessageUid.of((long)row.getLong("uid")));
    }

    private Flux<Row> retrieveResultSetOfDeletedMessage(CassandraId cassandraId, MessageRange range) {
        switch (range.getType()) {
            case ALL: {
                return this.retrieveAllDeleted(cassandraId);
            }
            case FROM: {
                return this.retrieveDeletedAfter(cassandraId, range.getUidFrom());
            }
            case RANGE: {
                return this.retrieveDeletedBetween(cassandraId, range.getUidFrom(), range.getUidTo());
            }
            case ONE: {
                return this.retrieveOneDeleted(cassandraId, range.getUidFrom());
            }
        }
        throw new UnsupportedOperationException();
    }

    private Flux<Row> retrieveAllDeleted(CassandraId cassandraId) {
        return this.cassandraAsyncExecutor.executeRows((Statement)this.selectAllUidStatement.bind().setUUID("mailboxId", cassandraId.asUuid()));
    }

    private Flux<Row> retrieveOneDeleted(CassandraId cassandraId, MessageUid uid) {
        return this.cassandraAsyncExecutor.executeRows((Statement)this.selectOneUidStatement.bind().setUUID("mailboxId", cassandraId.asUuid()).setLong("uid", uid.asLong()));
    }

    private Flux<Row> retrieveDeletedBetween(CassandraId cassandraId, MessageUid from, MessageUid to) {
        return this.cassandraAsyncExecutor.executeRows((Statement)this.selectBetweenUidStatement.bind().setUUID("mailboxId", cassandraId.asUuid()).setLong(UID_FROM, from.asLong()).setLong(UID_TO, to.asLong()));
    }

    private Flux<Row> retrieveDeletedAfter(CassandraId cassandraId, MessageUid from) {
        return this.cassandraAsyncExecutor.executeRows((Statement)this.selectFromUidStatement.bind().setUUID("mailboxId", cassandraId.asUuid()).setLong(UID_FROM, from.asLong()));
    }
}

