/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.channel;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import java.net.SocketAddress;
import java.time.Duration;
import reactor.netty.channel.AbstractChannelMetricsHandler;
import reactor.netty.channel.ChannelMetricsRecorder;
import reactor.util.annotation.Nullable;

public class ChannelMetricsHandler
extends AbstractChannelMetricsHandler {
    final ChannelMetricsRecorder recorder;

    ChannelMetricsHandler(ChannelMetricsRecorder recorder, @Nullable SocketAddress remoteAddress, boolean onServer) {
        super(remoteAddress, onServer);
        this.recorder = recorder;
    }

    @Override
    public ChannelHandler connectMetricsHandler() {
        return new ConnectMetricsHandler(this.recorder());
    }

    @Override
    public ChannelMetricsRecorder recorder() {
        return this.recorder;
    }

    static final class ConnectMetricsHandler
    extends ChannelOutboundHandlerAdapter {
        final ChannelMetricsRecorder recorder;

        ConnectMetricsHandler(ChannelMetricsRecorder recorder) {
            this.recorder = recorder;
        }

        public void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) throws Exception {
            long connectTimeStart = System.nanoTime();
            super.connect(ctx, remoteAddress, localAddress, promise);
            promise.addListener(future -> {
                ctx.pipeline().remove((ChannelHandler)this);
                this.recorder.recordConnectTime(remoteAddress, Duration.ofNanos(System.nanoTime() - connectTimeStart), future.isSuccess() ? "SUCCESS" : "ERROR");
            });
        }
    }
}

