/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.model;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class Cid {
    public static final StrictCidValidator DEFAULT_VALIDATOR = new StrictCidValidator();
    private final String value;

    public static CidParser parser() {
        return new CidParser();
    }

    public static Cid from(String value) {
        return Cid.parser().strict().unwrap().parse(value).get();
    }

    private static Optional<Cid> toCid(CidValidator cidValidator, String value) {
        cidValidator.validate(value);
        return Cid.toCid(value);
    }

    private static Optional<Cid> toCid(String cidAsString) {
        if (Strings.isNullOrEmpty((String)cidAsString) || StringUtils.isBlank((CharSequence)cidAsString)) {
            return Optional.empty();
        }
        return Optional.of(new Cid(cidAsString));
    }

    private Cid(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public final boolean equals(Object obj) {
        if (obj instanceof Cid) {
            Cid other = (Cid)obj;
            return Objects.equal((Object)this.value, (Object)other.value);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.value});
    }

    public static class CidParser {
        private Optional<CidValidator> validator = Optional.empty();
        private Optional<CidTransformation> transformation = Optional.empty();

        private CidParser() {
        }

        public CidParser relaxed() {
            this.validator = Optional.of(new RelaxedCidValidator());
            return this;
        }

        public CidParser strict() {
            this.validator = Optional.of(new StrictCidValidator());
            return this;
        }

        public CidParser unwrap() {
            this.transformation = Optional.of(new Unwrap());
            return this;
        }

        public Optional<Cid> parse(String value) {
            CidValidator cidValidator = this.validator.orElse(DEFAULT_VALIDATOR);
            CidTransformation cidTransformation = this.transformation.orElse(new Identity());
            return cidTransformation.apply(cidValidator, value);
        }
    }

    public static class RelaxedCidValidator
    implements CidValidator {
        @Override
        public void validate(String cidValue) {
        }
    }

    public static class StrictCidValidator
    implements CidValidator {
        @Override
        public void validate(String cidValue) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)cidValue) ? 1 : 0) != 0);
            Preconditions.checkArgument((!StringUtils.isBlank((CharSequence)cidValue) ? 1 : 0) != 0, (Object)"'cidAsString' is mandatory");
        }
    }

    public static interface CidValidator {
        public void validate(String var1);
    }

    public static class Unwrap
    implements CidTransformation {
        @Override
        public Optional<Cid> apply(CidValidator cidValidator, String value) {
            cidValidator.validate(value);
            if (this.isWrappedWithAngleBrackets(value)) {
                return this.unwrap(value, cidValidator);
            }
            return Cid.toCid(cidValidator, value);
        }

        private Optional<Cid> unwrap(String cidAsString, CidValidator cidValidator) {
            String unwrapCid = cidAsString.substring(1, cidAsString.length() - 1);
            return Cid.toCid(cidValidator, unwrapCid);
        }

        private boolean isWrappedWithAngleBrackets(String cidAsString) {
            return cidAsString != null && cidAsString.startsWith("<") && cidAsString.endsWith(">");
        }
    }

    public static class Identity
    implements CidTransformation {
        @Override
        public Optional<Cid> apply(CidValidator cidValidator, String value) {
            return Cid.toCid(cidValidator, value);
        }
    }

    public static interface CidTransformation {
        public Optional<Cid> apply(CidValidator var1, String var2);
    }
}

