/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules.data;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JPAConfiguration {
    private final String driverName;
    private final String driverURL;
    private final Optional<Boolean> testOnBorrow;
    private final Optional<Integer> validationQueryTimeoutSec;
    private final Optional<Credential> credential;
    private final Optional<String> validationQuery;

    public static RequireDriverName builder() {
        return driverName -> driverURL -> new ReadyToBuild(driverName, driverURL, Credential.NO_CREDENTIAL, ReadyToBuild.NO_TEST_ON_BORROW, ReadyToBuild.NO_VALIDATION_QUERY_TIMEOUT_SEC, ReadyToBuild.NO_VALIDATION_QUERY);
    }

    @VisibleForTesting
    JPAConfiguration(String driverName, String driverURL, Optional<Credential> credential, Optional<Boolean> testOnBorrow, Optional<Integer> validationQueryTimeoutSec, Optional<String> validationQuery) {
        Preconditions.checkNotNull((Object)driverName, (Object)"driverName cannot be null");
        Preconditions.checkNotNull((Object)driverURL, (Object)"driverURL cannot be null");
        validationQueryTimeoutSec.ifPresent(timeoutInSec -> Preconditions.checkArgument((timeoutInSec > 0 ? 1 : 0) != 0, (Object)"validationQueryTimeoutSec is required to be greater than 0"));
        this.driverName = driverName;
        this.driverURL = driverURL;
        this.credential = credential;
        this.testOnBorrow = testOnBorrow;
        this.validationQueryTimeoutSec = validationQueryTimeoutSec;
        this.validationQuery = validationQuery;
    }

    public String getDriverName() {
        return this.driverName;
    }

    public String getDriverURL() {
        return this.driverURL;
    }

    public Optional<Boolean> isTestOnBorrow() {
        return this.testOnBorrow;
    }

    public Optional<Integer> getValidationQueryTimeoutSec() {
        return this.validationQueryTimeoutSec;
    }

    public Optional<String> getValidationQuery() {
        return this.validationQuery;
    }

    public Optional<Credential> getCredential() {
        return this.credential;
    }

    @FunctionalInterface
    public static interface RequireDriverName {
        public RequireDriverURL driverName(String var1);
    }

    @FunctionalInterface
    public static interface RequireDriverURL {
        public ReadyToBuild driverURL(String var1);
    }

    public static class ReadyToBuild {
        static final Optional<Boolean> NO_TEST_ON_BORROW = Optional.empty();
        static final Optional<Integer> NO_VALIDATION_QUERY_TIMEOUT_SEC = Optional.empty();
        static final Optional<String> NO_VALIDATION_QUERY = Optional.empty();
        private final String driverName;
        private final String driverURL;
        private Optional<Credential> credential;
        private Optional<Boolean> testOnBorrow;
        private Optional<Integer> validationQueryTimeoutSec;
        private Optional<String> validationQuery;

        private ReadyToBuild(String driverName, String driverURL, Optional<Credential> credential, Optional<Boolean> testOnBorrow, Optional<Integer> validationQueryTimeoutSec, Optional<String> validationQuery) {
            this.driverName = driverName;
            this.driverURL = driverURL;
            this.credential = credential;
            this.testOnBorrow = testOnBorrow;
            this.validationQueryTimeoutSec = validationQueryTimeoutSec;
            this.validationQuery = validationQuery;
        }

        public JPAConfiguration build() {
            return new JPAConfiguration(this.driverName, this.driverURL, this.credential, this.testOnBorrow, this.validationQueryTimeoutSec, this.validationQuery);
        }

        public RequirePassword username(String username) {
            return password -> new ReadyToBuild(this.driverName, this.driverURL, Credential.of(username, password), this.testOnBorrow, this.validationQueryTimeoutSec, this.validationQuery);
        }

        public ReadyToBuild testOnBorrow(Boolean testOnBorrow) {
            this.testOnBorrow = Optional.ofNullable(testOnBorrow);
            return this;
        }

        public ReadyToBuild validationQueryTimeoutSec(Integer validationQueryTimeoutSec) {
            this.validationQueryTimeoutSec = Optional.ofNullable(validationQueryTimeoutSec);
            return this;
        }

        public ReadyToBuild validationQuery(String validationQuery) {
            this.validationQuery = Optional.ofNullable(validationQuery);
            return this;
        }
    }

    public static class Credential {
        private static final Logger LOGGER = LoggerFactory.getLogger(Credential.class);
        static final Optional<Credential> NO_CREDENTIAL = Optional.empty();
        private final String username;
        private final String password;

        public static Optional<Credential> of(String username, String password) {
            if (StringUtils.isBlank((CharSequence)username) && StringUtils.isBlank((CharSequence)password)) {
                LOGGER.debug("username and password are blank, returns no credential by default");
                return NO_CREDENTIAL;
            }
            return Optional.of(new Credential(username, password));
        }

        private Credential(String username, String password) {
            Preconditions.checkArgument((StringUtils.isNotBlank((CharSequence)username) && StringUtils.isNotBlank((CharSequence)password) ? 1 : 0) != 0, (Object)"username and password for connecting to database can't be blank");
            this.username = username;
            this.password = password;
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }
    }

    @FunctionalInterface
    public static interface RequirePassword {
        public ReadyToBuild password(String var1);
    }
}

