/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.task.eventsourcing.distributed;

import com.google.common.collect.ImmutableMap;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import java.util.Map;
import javax.inject.Inject;
import org.apache.james.backends.rabbitmq.SimpleConnectionPool;
import org.apache.james.task.eventsourcing.EventSourcingTaskManager;
import org.apache.james.task.eventsourcing.distributed.CancelRequestQueueName;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class RabbitMQWorkQueueReconnectionHandler
implements SimpleConnectionPool.ReconnectionHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(RabbitMQWorkQueueReconnectionHandler.class);
    private final CancelRequestQueueName cancelRequestQueueName;
    private final EventSourcingTaskManager taskManager;

    @Inject
    public RabbitMQWorkQueueReconnectionHandler(CancelRequestQueueName cancelRequestQueueName, EventSourcingTaskManager taskManager) {
        this.cancelRequestQueueName = cancelRequestQueueName;
        this.taskManager = taskManager;
    }

    public Publisher<Void> handleReconnection(Connection connection) {
        return Mono.fromRunnable(() -> this.createCancelQueue(connection)).then(Mono.fromRunnable(() -> ((EventSourcingTaskManager)this.taskManager).restart()));
    }

    private void createCancelQueue(Connection connection) {
        try (Channel channel = connection.createChannel();){
            channel.queueDeclare(this.cancelRequestQueueName.asString(), false, false, true, (Map)ImmutableMap.of());
        }
        catch (Exception e) {
            LOGGER.error("Error recovering connection", (Throwable)e);
        }
    }
}

