/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.data.jmap;

import com.github.fge.lambdas.Throwing;
import java.io.IOException;
import java.time.Duration;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.Iterator;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import javax.inject.Inject;
import javax.mail.Flags;
import org.apache.james.jmap.api.projections.EmailQueryView;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.FetchGroup;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MailboxMetaData;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.MessageRange;
import org.apache.james.mailbox.model.MessageResult;
import org.apache.james.mailbox.model.search.MailboxQuery;
import org.apache.james.mime4j.dom.Message;
import org.apache.james.mime4j.message.DefaultMessageBuilder;
import org.apache.james.mime4j.stream.MimeConfig;
import org.apache.james.task.Task;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.api.UsersRepositoryException;
import org.apache.james.util.ReactorUtils;
import org.apache.james.util.streams.Iterators;
import org.apache.james.webadmin.data.jmap.RunningOptions;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class EmailQueryViewPopulator {
    private static final Logger LOGGER = LoggerFactory.getLogger(EmailQueryViewPopulator.class);
    private static final Duration PERIOD = Duration.ofSeconds(1L);
    public static final int USER_CONCURRENCY = 1;
    public static final int MAILBOX_CONCURRENCY = 1;
    private final UsersRepository usersRepository;
    private final MailboxManager mailboxManager;
    private final EmailQueryView emailQueryView;

    @Inject
    EmailQueryViewPopulator(UsersRepository usersRepository, MailboxManager mailboxManager, EmailQueryView emailQueryView) {
        this.usersRepository = usersRepository;
        this.mailboxManager = mailboxManager;
        this.emailQueryView = emailQueryView;
    }

    Mono<Task.Result> populateView(Progress progress, RunningOptions runningOptions) {
        return this.correctProjection(this.listAllMailboxMessages(progress), runningOptions, progress);
    }

    private Flux<MessageResult> listAllMailboxMessages(Progress progress) {
        try {
            return Iterators.toFlux((Iterator)this.usersRepository.list()).map(arg_0 -> ((MailboxManager)this.mailboxManager).createSystemSession(arg_0)).doOnNext(any -> progress.incrementProcessedUserCount()).flatMap(session -> this.listUserMailboxMessages(progress, (MailboxSession)session), 1).filter(messageResult -> !messageResult.getFlags().contains(Flags.Flag.DELETED));
        }
        catch (UsersRepositoryException e) {
            return Flux.error((Throwable)e);
        }
    }

    private Flux<MessageResult> listUserMailboxMessages(Progress progress, MailboxSession session) {
        return this.listUsersMailboxes(session).flatMap(mailboxMetadata -> this.retrieveMailbox(session, (MailboxMetaData)mailboxMetadata), 1).flatMap((Function)Throwing.function(messageManager -> this.listAllMessages((MessageManager)messageManager, session)), 1).onErrorResume(MailboxException.class, e -> {
            LOGGER.error("JMAP emailQuery view re-computation aborted for {} as we failed listing user mailboxes", (Object)session.getUser(), (Object)e);
            progress.incrementFailedUserCount();
            return Flux.empty();
        });
    }

    private Mono<Task.Result> correctProjection(MessageResult messageResult, Progress progress) {
        return Mono.fromCallable(() -> {
            MailboxId mailboxId = messageResult.getMailboxId();
            MessageId messageId = messageResult.getMessageId();
            ZonedDateTime receivedAt = ZonedDateTime.ofInstant(messageResult.getInternalDate().toInstant(), ZoneOffset.UTC);
            Message mime4JMessage = this.parseMessage(messageResult);
            Date sentAtDate = Optional.ofNullable(mime4JMessage.getDate()).orElse(messageResult.getInternalDate());
            ZonedDateTime sentAt = ZonedDateTime.ofInstant(sentAtDate.toInstant(), ZoneOffset.UTC);
            return new EmailQueryView.Entry(mailboxId, messageId, sentAt, receivedAt);
        }).flatMap(entry -> this.emailQueryView.save(entry.getMailboxId(), entry.getSentAt(), entry.getReceivedAt(), entry.getMessageId())).thenReturn((Object)Task.Result.COMPLETED).doOnSuccess(any -> progress.incrementProcessedMessageCount()).onErrorResume(e -> {
            LOGGER.error("JMAP emailQuery view re-computation aborted for {} - {} - {}", new Object[]{messageResult.getMailboxId(), messageResult.getMessageId(), messageResult.getUid(), e});
            progress.incrementFailedMessageCount();
            return Mono.just((Object)Task.Result.PARTIAL);
        });
    }

    private Mono<Task.Result> correctProjection(Flux<MessageResult> entries, RunningOptions runningOptions, Progress progress) {
        return entries.transform(ReactorUtils.throttle().elements(runningOptions.getMessagesPerSecond()).per(PERIOD).forOperation(entry -> this.correctProjection((MessageResult)entry, progress))).reduce(Task::combine).switchIfEmpty(Mono.just((Object)Task.Result.COMPLETED));
    }

    private Flux<MailboxMetaData> listUsersMailboxes(MailboxSession session) {
        return this.mailboxManager.search(MailboxQuery.privateMailboxesBuilder((MailboxSession)session).build(), MailboxManager.MailboxSearchFetchType.Minimal, session);
    }

    private Mono<MessageManager> retrieveMailbox(MailboxSession session, MailboxMetaData mailboxMetadata) {
        return Mono.from((Publisher)this.mailboxManager.getMailboxReactive(mailboxMetadata.getId(), session));
    }

    private Flux<MessageResult> listAllMessages(MessageManager messageManager, MailboxSession session) {
        try {
            return Iterators.toFlux((Iterator)messageManager.getMessages(MessageRange.all(), FetchGroup.HEADERS, session)).subscribeOn(Schedulers.elastic());
        }
        catch (MailboxException e) {
            return Flux.error((Throwable)e);
        }
    }

    private Message parseMessage(MessageResult messageResult) throws IOException, MailboxException {
        DefaultMessageBuilder defaultMessageBuilder = new DefaultMessageBuilder();
        defaultMessageBuilder.setMimeEntityConfig(MimeConfig.PERMISSIVE);
        return defaultMessageBuilder.parseMessage(messageResult.getFullContent().getInputStream());
    }

    static class Progress {
        private final AtomicLong processedUserCount;
        private final AtomicLong processedMessageCount;
        private final AtomicLong failedUserCount = new AtomicLong();
        private final AtomicLong failedMessageCount;

        Progress() {
            this.processedMessageCount = new AtomicLong();
            this.processedUserCount = new AtomicLong();
            this.failedMessageCount = new AtomicLong();
        }

        private void incrementProcessedUserCount() {
            this.processedUserCount.incrementAndGet();
        }

        private void incrementProcessedMessageCount() {
            this.processedMessageCount.incrementAndGet();
        }

        private void incrementFailedUserCount() {
            this.failedUserCount.incrementAndGet();
        }

        private void incrementFailedMessageCount() {
            this.failedMessageCount.incrementAndGet();
        }

        long getProcessedUserCount() {
            return this.processedUserCount.get();
        }

        long getProcessedMessageCount() {
            return this.processedMessageCount.get();
        }

        long getFailedUserCount() {
            return this.failedUserCount.get();
        }

        long getFailedMessageCount() {
            return this.failedMessageCount.get();
        }
    }
}

