/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets.jsieve;

import com.github.fge.lambdas.Throwing;
import java.io.Serializable;
import javax.mail.MessagingException;
import org.apache.james.core.MailAddress;
import org.apache.mailet.Attribute;
import org.apache.mailet.AttributeName;
import org.apache.mailet.AttributeUtils;
import org.apache.mailet.AttributeValue;
import org.apache.mailet.Mail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActionUtils.class);
    private static final String ATTRIBUTE_PREFIX = ActionUtils.class.getPackage().getName() + ".";

    public static MailAddress getSoleRecipient(Mail aMail) throws MessagingException {
        if (aMail.getRecipients() == null) {
            throw new MessagingException("Invalid number of recipients - 0. Exactly 1 recipient is expected.");
        }
        if (1 != aMail.getRecipients().size()) {
            throw new MessagingException("Invalid number of recipients - " + Integer.toString(aMail.getRecipients().size()) + ". Exactly 1 recipient is expected.");
        }
        return (MailAddress)aMail.getRecipients().iterator().next();
    }

    public static void detectAndHandleLocalLooping(Mail aMail, String anAttributeSuffix) throws MessagingException {
        MailAddress thisRecipient = ActionUtils.getSoleRecipient(aMail);
        AttributeName attributeName = AttributeName.of((String)(ATTRIBUTE_PREFIX + anAttributeSuffix));
        AttributeUtils.getValueAndCastFromMail((Mail)aMail, (AttributeName)attributeName, MailAddress.class).filter(lastRecipient -> lastRecipient.equals((Object)thisRecipient)).ifPresent(Throwing.consumer(any -> {
            MessagingException ex = new MessagingException("This message is looping! Message ID: " + aMail.getMessage().getMessageID());
            LOGGER.warn(ex.getMessage(), (Throwable)ex);
            throw ex;
        }).sneakyThrow());
        aMail.setAttribute(new Attribute(attributeName, AttributeValue.ofSerializable((Serializable)thisRecipient)));
    }
}

