/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.queue.rabbitmq.view.cassandra;

import com.datastax.driver.core.CodecRegistry;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.TupleType;
import com.datastax.driver.core.schemabuilder.Create;
import com.datastax.driver.core.schemabuilder.SchemaBuilder;
import com.datastax.driver.core.schemabuilder.TableOptions;
import org.apache.james.backends.cassandra.components.CassandraModule;

public interface CassandraMailQueueViewModule {
    public static final CassandraModule MODULE = CassandraModule.table((String)"enqueuedMailsV4").comment("store enqueued mails, if a mail is enqueued into a mail queue, it also being stored in this table, when a mail is dequeued from a mail queue, the record associated with that mail still available in this table and will not be deleted immediately regarding to the performance impacts, but after some scheduled tasks").options(options -> (Create.Options)options.compactionOptions((TableOptions.CompactionOptions)SchemaBuilder.timeWindowCompactionStrategy().compactionWindowSize(Integer.valueOf(1)).compactionWindowUnit(TableOptions.CompactionOptions.TimeWindowCompactionStrategyOptions.CompactionWindowUnit.HOURS))).statement(statement -> (Create)((Create)((Create)((Create)((Create)((Create)((Create)((Create)((Create)((Create)((Create)((Create)((Create)statement.addPartitionKey("queueName", DataType.text()).addPartitionKey("timeRangeStart", DataType.timestamp()).addPartitionKey("bucketId", DataType.cint()).addClusteringColumn("enqueueId", DataType.uuid()).addColumn("enqueuedTime", DataType.timestamp())).addColumn("name", DataType.text())).addColumn("state", DataType.text())).addColumn("headerBlobId", DataType.text())).addColumn("bodyBlobId", DataType.text())).addColumn("attributes", (DataType)DataType.frozenMap((DataType)DataType.text(), (DataType)DataType.blob()))).addColumn("errorMessage", DataType.text())).addColumn("sender", DataType.text())).addColumn("recipients", (DataType)DataType.frozenList((DataType)DataType.text()))).addColumn("remoteHost", DataType.text())).addColumn("remoteAddr", DataType.text())).addColumn("lastUpdated", DataType.timestamp())).addColumn("perRecipientSpecificHeaders", (DataType)DataType.frozenList((DataType)TupleType.of((ProtocolVersion)ProtocolVersion.NEWEST_SUPPORTED, (CodecRegistry)CodecRegistry.DEFAULT_INSTANCE, (DataType[])new DataType[]{DataType.text(), DataType.text(), DataType.text()})))).table("browseStart").comment("this table allows to find the starting point of iteration from the table: enqueuedMailsV4 in order to make a browse operation through mail queues").options(options -> options).statement(statement -> (Create)statement.addPartitionKey("queueName", DataType.text()).addColumn("browseStart", DataType.timestamp())).table("contentStart").comment("this table allows to find the starting point of content from the table: enqueuedMailsV4 in order to make a browse operation through mail queues. Strictly before browse start, it enables queue cleanup.").options(options -> options).statement(statement -> (Create)statement.addPartitionKey("queueName", DataType.text()).addColumn("contentStart", DataType.timestamp())).table("deletedMailsV2").comment("this table stores the dequeued mails, while browsing mail from table: deletedMailsV2 we need to filter out mails have been dequeued by checking their existence in this table").options(options -> (Create.Options)((Create.Options)options.compactionOptions((TableOptions.CompactionOptions)SchemaBuilder.timeWindowCompactionStrategy())).bloomFilterFPChance(Double.valueOf(0.01))).statement(statement -> statement.addPartitionKey("queueName", DataType.text()).addPartitionKey("enqueueId", DataType.uuid())).build();

    public static interface DeletedMailTable {
        public static final String TABLE_NAME = "deletedMailsV2";
        public static final String QUEUE_NAME = "queueName";
        public static final String ENQUEUE_ID = "enqueueId";
    }

    public static interface ContentStartTable {
        public static final String TABLE_NAME = "contentStart";
        public static final String QUEUE_NAME = "queueName";
        public static final String CONTENT_START = "contentStart";
    }

    public static interface BrowseStartTable {
        public static final String TABLE_NAME = "browseStart";
        public static final String QUEUE_NAME = "queueName";
        public static final String BROWSE_START = "browseStart";
    }

    public static interface EnqueuedMailsTable {
        public static final String TABLE_NAME = "enqueuedMailsV4";
        public static final String QUEUE_NAME = "queueName";
        public static final String TIME_RANGE_START = "timeRangeStart";
        public static final String BUCKET_ID = "bucketId";
        public static final String ENQUEUED_TIME = "enqueuedTime";
        public static final String ENQUEUE_ID = "enqueueId";
        public static final String NAME = "name";
        public static final String HEADER_BLOB_ID = "headerBlobId";
        public static final String BODY_BLOB_ID = "bodyBlobId";
        public static final String STATE = "state";
        public static final String SENDER = "sender";
        public static final String RECIPIENTS = "recipients";
        public static final String ATTRIBUTES = "attributes";
        public static final String ERROR_MESSAGE = "errorMessage";
        public static final String REMOTE_HOST = "remoteHost";
        public static final String REMOTE_ADDR = "remoteAddr";
        public static final String LAST_UPDATED = "lastUpdated";
        public static final String PER_RECIPIENT_SPECIFIC_HEADERS = "perRecipientSpecificHeaders";
    }

    public static interface HeaderEntry {
        public static final int USER_INDEX = 0;
        public static final int HEADER_NAME_INDEX = 1;
        public static final int HEADER_VALUE_INDEX = 2;
    }
}

