/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.geo;

import java.util.Arrays;
import java.util.List;
import org.elasticsearch.common.geo.GeoUtils;
import org.elasticsearch.geometry.Line;
import org.elasticsearch.geometry.MultiLine;

public class GeoLineDecomposer {
    private static final double DATELINE = 180.0;

    private GeoLineDecomposer() {
    }

    public static void decomposeMultiLine(MultiLine multiLine, List<Line> collector) {
        for (Line line : multiLine) {
            GeoLineDecomposer.decomposeLine(line, collector);
        }
    }

    public static void decomposeLine(Line line, List<Line> collector) {
        if (line.isEmpty()) {
            return;
        }
        double[] lons = new double[line.length()];
        double[] lats = new double[lons.length];
        for (int i = 0; i < lons.length; ++i) {
            double[] lonLat = new double[]{line.getX(i), line.getY(i)};
            GeoUtils.normalizePoint(lonLat, false, true);
            lons[i] = lonLat[0];
            lats[i] = lonLat[1];
        }
        GeoLineDecomposer.decompose(lons, lats, collector);
    }

    private static void decompose(double[] lons, double[] lats, List<Line> collector) {
        int offset = 0;
        double shift = 0.0;
        int i = 1;
        while (i < lons.length) {
            int direction = Double.compare(lons[i], lons[i - 1]);
            double newShift = GeoLineDecomposer.calculateShift(lons[i - 1], direction < 0);
            if (i - offset > 1 && newShift != shift) {
                double[] partLons = Arrays.copyOfRange(lons, offset, i);
                double[] partLats = Arrays.copyOfRange(lats, offset, i);
                GeoLineDecomposer.performShift(shift, partLons);
                shift = newShift;
                offset = i - 1;
                collector.add(new Line(partLons, partLats));
                continue;
            }
            shift = newShift;
            double t = GeoLineDecomposer.intersection(lons[i - 1] + shift, lons[i] + shift);
            if (!Double.isNaN(t)) {
                double[] partLons = Arrays.copyOfRange(lons, offset, i + 1);
                double[] partLats = Arrays.copyOfRange(lats, offset, i + 1);
                double d = (direction > 0 ? 180.0 : -180.0) - shift;
                partLons[partLons.length - 1] = d;
                lons[i - 1] = d;
                double d2 = lats[i - 1] + (lats[i] - lats[i - 1]) * t;
                partLats[partLats.length - 1] = d2;
                lats[i - 1] = d2;
                GeoLineDecomposer.performShift(shift, partLons);
                offset = i - 1;
                collector.add(new Line(partLons, partLats));
                continue;
            }
            ++i;
        }
        if (offset == 0) {
            GeoLineDecomposer.performShift(shift, lons);
            collector.add(new Line(lons, lats));
        } else if (offset < lons.length - 1) {
            double[] partLons = Arrays.copyOfRange(lons, offset, lons.length);
            double[] partLats = Arrays.copyOfRange(lats, offset, lats.length);
            GeoLineDecomposer.performShift(shift, partLons);
            collector.add(new Line(partLons, partLats));
        }
    }

    private static void performShift(double shift, double[] lons) {
        if (shift != 0.0) {
            for (int j = 0; j < lons.length; ++j) {
                lons[j] = lons[j] + shift;
            }
        }
    }

    private static double calculateShift(double lon, boolean include180) {
        double normalized = GeoUtils.centeredModulus(lon, 360.0);
        double shift = Math.round(normalized - lon);
        if (!include180 && normalized == 180.0) {
            shift -= 360.0;
        }
        return shift;
    }

    private static double intersection(double p1x, double p2x) {
        if (p1x == p2x) {
            return Double.NaN;
        }
        double t = ((p1x < p2x ? 180.0 : -180.0) - p1x) / (p2x - p1x);
        if (t >= 1.0 || t <= 0.0) {
            return Double.NaN;
        }
        return t;
    }
}

