/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.cassandra.upload;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.Optional;
import org.apache.james.blob.api.BucketName;

public class UploadBucketName {
    private static final String PREFIX = "uploads-";
    private final int weekNumber;

    public static Optional<UploadBucketName> ofBucket(BucketName bucketName) {
        String bucketNameString = bucketName.asString();
        if (!bucketNameString.startsWith(PREFIX)) {
            return Optional.empty();
        }
        String weekPart = bucketNameString.substring(PREFIX.length());
        try {
            int weekNumber = Integer.parseInt(weekPart);
            if (weekNumber >= 0) {
                return Optional.of(new UploadBucketName(weekNumber));
            }
            return Optional.empty();
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public UploadBucketName(int weekNumber) {
        Preconditions.checkArgument((weekNumber >= 0 ? 1 : 0) != 0, (Object)"'weekNumber' should be strictly positive");
        this.weekNumber = weekNumber;
    }

    public BucketName asBucketName() {
        return BucketName.of((String)String.format("uploads-%d", this.weekNumber));
    }

    public int getWeekNumber() {
        return this.weekNumber;
    }

    public boolean equals(Object obj) {
        if (obj instanceof UploadBucketName) {
            UploadBucketName other = (UploadBucketName)obj;
            return Objects.equal((Object)this.weekNumber, (Object)other.weekNumber);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.weekNumber});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("weekNumber", this.weekNumber).toString();
    }
}

