/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.backends.rabbitmq;

import com.github.fge.lambdas.Throwing;
import com.google.common.base.Preconditions;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.BuiltinExchangeType;
import com.rabbitmq.client.CancelCallback;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Command;
import com.rabbitmq.client.ConfirmCallback;
import com.rabbitmq.client.ConfirmListener;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.ConsumerShutdownSignalCallback;
import com.rabbitmq.client.DeliverCallback;
import com.rabbitmq.client.GetResponse;
import com.rabbitmq.client.Method;
import com.rabbitmq.client.ReturnCallback;
import com.rabbitmq.client.ReturnListener;
import com.rabbitmq.client.ShutdownListener;
import com.rabbitmq.client.ShutdownSignalException;
import java.io.IOException;
import java.time.Duration;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.annotation.PreDestroy;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.apache.james.lifecycle.api.Startable;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.SignalType;
import reactor.core.scheduler.Schedulers;
import reactor.rabbitmq.BindingSpecification;
import reactor.rabbitmq.ChannelPool;
import reactor.rabbitmq.QueueSpecification;
import reactor.rabbitmq.RabbitFlux;
import reactor.rabbitmq.Receiver;
import reactor.rabbitmq.ReceiverOptions;
import reactor.rabbitmq.Sender;
import reactor.rabbitmq.SenderOptions;
import reactor.util.retry.Retry;
import reactor.util.retry.RetryBackoffSpec;

public class ReactorRabbitMQChannelPool
implements ChannelPool,
Startable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReactorRabbitMQChannelPool.class);
    private static final long MAXIMUM_BORROW_TIMEOUT_IN_MS = Duration.ofSeconds(5L).toMillis();
    private static final int MAX_CHANNELS_NUMBER = 3;
    private static final int MAX_BORROW_RETRIES = 3;
    private static final Duration MIN_BORROW_DELAY = Duration.ofMillis(50L);
    private final Mono<Connection> connectionMono;
    private final GenericObjectPool<Channel> pool;
    private final ConcurrentSkipListSet<Channel> borrowedChannels;
    private final Configuration configuration;
    private Sender sender;

    public ReactorRabbitMQChannelPool(Mono<Connection> connectionMono, Configuration configuration) {
        this.connectionMono = connectionMono;
        this.configuration = configuration;
        ChannelFactory channelFactory = new ChannelFactory(connectionMono, configuration);
        GenericObjectPoolConfig config = new GenericObjectPoolConfig();
        config.setMaxTotal(configuration.getMaxChannel());
        this.pool = new GenericObjectPool((PooledObjectFactory)channelFactory, config);
        this.borrowedChannels = new ConcurrentSkipListSet<Channel>(Comparator.comparingInt(System::identityHashCode));
    }

    public void start() {
        this.sender = this.createSender();
    }

    public Sender getSender() {
        return this.sender;
    }

    public Receiver createReceiver() {
        return RabbitFlux.createReceiver((ReceiverOptions)new ReceiverOptions().connectionMono(this.connectionMono));
    }

    public Mono<? extends Channel> getChannelMono() {
        return this.borrow();
    }

    private Mono<Channel> borrow() {
        return this.tryBorrowFromPool().doOnError(throwable -> LOGGER.warn("Cannot borrow channel", throwable)).retryWhen((Retry)this.configuration.backoffSpec().scheduler(Schedulers.elastic())).onErrorMap(this::propagateException).subscribeOn(Schedulers.elastic()).doOnNext(this.borrowedChannels::add);
    }

    private Mono<Channel> tryBorrowFromPool() {
        return Mono.fromCallable(this::borrowFromPool);
    }

    private Throwable propagateException(Throwable throwable) {
        if (throwable instanceof IllegalStateException && throwable.getMessage().contains("Retries exhausted")) {
            return throwable.getCause();
        }
        return throwable;
    }

    private Channel borrowFromPool() throws Exception {
        Channel channel = (Channel)this.pool.borrowObject(MAXIMUM_BORROW_TIMEOUT_IN_MS);
        if (!channel.isOpen()) {
            this.invalidateObject(channel);
            throw new ChannelClosedException("borrowed channel is already closed");
        }
        return channel;
    }

    public BiConsumer<SignalType, Channel> getChannelCloseHandler() {
        return (signalType, channel) -> {
            this.borrowedChannels.remove(channel);
            if (!channel.isOpen() || !this.executeWithoutError((SignalType)signalType)) {
                this.invalidateObject((Channel)channel);
                return;
            }
            this.pool.returnObject(channel);
        };
    }

    private boolean executeWithoutError(SignalType signalType) {
        return signalType == SignalType.ON_COMPLETE || signalType == SignalType.CANCEL;
    }

    private Sender createSender() {
        return RabbitFlux.createSender((SenderOptions)new SenderOptions().connectionMono(this.connectionMono).channelPool((ChannelPool)this).resourceManagementChannelMono(this.connectionMono.map((Function)Throwing.function(Connection::createChannel)).cache()));
    }

    public Mono<Void> createWorkQueue(QueueSpecification queueSpecification, BindingSpecification bindingSpecification) {
        Preconditions.checkArgument((queueSpecification.getName() != null ? 1 : 0) != 0, (Object)"WorkQueue pattern do not make sense for unnamed queues");
        Preconditions.checkArgument((boolean)queueSpecification.getName().equals(bindingSpecification.getQueue()), (String)"Binding needs to be targetting the created queue %s instead of %s", (Object)queueSpecification.getName(), (Object)bindingSpecification.getQueue());
        return Flux.concat((Publisher[])new Publisher[]{Mono.using(this::createSender, managementSender -> managementSender.declareQueue(queueSpecification), Sender::close).onErrorResume(e -> e instanceof ShutdownSignalException && e.getMessage().contains("reply-code=406, reply-text=PRECONDITION_FAILED - inequivalent arg 'x-dead-letter-exchange' for queue"), e -> {
            LOGGER.warn("{} already exists without dead-letter setup. Dead lettered messages to it will be lost. To solve this, re-create the queue with the x-dead-letter-exchange argument set up.", (Object)queueSpecification.getName());
            return Mono.empty();
        }), this.sender.bind(bindingSpecification)}).then();
    }

    public Mono<Void> createWorkQueue(QueueSpecification queueSpecification) {
        Preconditions.checkArgument((queueSpecification.getName() != null ? 1 : 0) != 0, (Object)"WorkQueue pattern do not make sense for unnamed queues");
        return Mono.using(this::createSender, managementSender -> managementSender.declareQueue(queueSpecification), Sender::close).onErrorResume(e -> e instanceof ShutdownSignalException && e.getMessage().contains("reply-code=406, reply-text=PRECONDITION_FAILED - inequivalent arg 'x-dead-letter-exchange' for queue"), e -> {
            LOGGER.warn("{} already exists without dead-letter setup. Dead lettered messages to it will be lost. To solve this, re-create the queue with the x-dead-letter-exchange argument set up.", (Object)queueSpecification.getName());
            return Mono.empty();
        }).then();
    }

    private void invalidateObject(Channel channel) {
        try {
            this.pool.invalidateObject((Object)channel);
            if (channel.isOpen()) {
                channel.close();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @PreDestroy
    public void close() {
        this.sender.close();
        this.borrowedChannels.forEach(channel -> this.getChannelCloseHandler().accept(SignalType.ON_NEXT, (Channel)channel));
        this.borrowedChannels.clear();
        this.pool.close();
    }

    public Mono<Boolean> tryChannel() {
        return Mono.usingWhen(this.borrow(), channel -> Mono.just((Object)channel.isOpen()), channel -> {
            if (channel != null) {
                this.borrowedChannels.remove(channel);
                this.pool.returnObject(channel);
            }
            return Mono.empty();
        }).onErrorResume(any -> Mono.just((Object)false));
    }

    public static class Configuration {
        public static final Configuration DEFAULT = Configuration.builder().retries(3).minBorrowDelay(MIN_BORROW_DELAY).maxChannel(3);
        private final Duration minBorrowDelay;
        private final int retries;
        private final int maxChannel;

        public static RequiresRetries builder() {
            return retries -> minBorrowDelay -> maxChannel -> new Configuration(minBorrowDelay, retries, maxChannel);
        }

        public static Configuration from(org.apache.commons.configuration2.Configuration configuration) {
            Duration minBorrowDelay = Optional.ofNullable(configuration.getLong("channel.pool.min.delay.ms", null)).map(Duration::ofMillis).orElse(MIN_BORROW_DELAY);
            return Configuration.builder().retries(configuration.getInt("channel.pool.retries", 3)).minBorrowDelay(minBorrowDelay).maxChannel(configuration.getInt("channel.pool.size", 3));
        }

        public Configuration(Duration minBorrowDelay, int retries, int maxChannel) {
            this.minBorrowDelay = minBorrowDelay;
            this.retries = retries;
            this.maxChannel = maxChannel;
        }

        private RetryBackoffSpec backoffSpec() {
            return Retry.backoff((long)this.retries, (Duration)this.minBorrowDelay);
        }

        public int getMaxChannel() {
            return this.maxChannel;
        }

        @FunctionalInterface
        public static interface RequiresRetries {
            public RequiredMinBorrowDelay retries(int var1);
        }

        @FunctionalInterface
        public static interface RequiredMinBorrowDelay {
            public RequiredMaxChannel minBorrowDelay(Duration var1);
        }

        @FunctionalInterface
        public static interface RequiredMaxChannel {
            public Configuration maxChannel(int var1);
        }
    }

    static class ChannelFactory
    extends BasePooledObjectFactory<Channel> {
        private static final Logger LOGGER = LoggerFactory.getLogger(ChannelFactory.class);
        private final Mono<Connection> connectionMono;
        private final Configuration configuration;

        ChannelFactory(Mono<Connection> connectionMono, Configuration configuration) {
            this.connectionMono = connectionMono;
            this.configuration = configuration;
        }

        public Channel create() {
            return (Channel)this.connectionMono.flatMap(this::openChannel).block();
        }

        private Mono<? extends Channel> openChannel(Connection connection) {
            return Mono.fromCallable(() -> ((Connection)connection).openChannel()).map(maybeChannel -> (Channel)maybeChannel.orElseThrow(() -> new RuntimeException("RabbitMQ reached to maximum opened channels, cannot get more channels"))).map(x$0 -> new SelectOnceChannel((Channel)x$0)).retryWhen((Retry)this.configuration.backoffSpec().scheduler(Schedulers.elastic())).doOnError(throwable -> LOGGER.error("error when creating new channel", throwable));
        }

        public PooledObject<Channel> wrap(Channel obj) {
            return new DefaultPooledObject((Object)obj);
        }

        public void destroyObject(PooledObject<Channel> pooledObject) throws Exception {
            Channel channel = (Channel)pooledObject.getObject();
            if (channel.isOpen()) {
                channel.close();
            }
        }
    }

    private static class ChannelClosedException
    extends IOException {
        ChannelClosedException(String message) {
            super(message);
        }
    }

    private static class SelectOnceChannel
    implements Channel {
        private final Channel delegate;
        private final AtomicBoolean confirmSelected = new AtomicBoolean(false);

        private SelectOnceChannel(Channel delegate) {
            this.delegate = delegate;
        }

        public AMQP.Confirm.SelectOk confirmSelect() throws IOException {
            if (!this.confirmSelected.getAndSet(true)) {
                return this.delegate.confirmSelect();
            }
            return new AMQP.Confirm.SelectOk.Builder().build();
        }

        public int getChannelNumber() {
            return this.delegate.getChannelNumber();
        }

        public Connection getConnection() {
            return this.delegate.getConnection();
        }

        public void close() throws IOException, TimeoutException {
            this.delegate.close();
        }

        public void close(int closeCode, String closeMessage) throws IOException, TimeoutException {
            this.delegate.close(closeCode, closeMessage);
        }

        public void abort() throws IOException {
            this.delegate.abort();
        }

        public void abort(int closeCode, String closeMessage) throws IOException {
            this.delegate.abort(closeCode, closeMessage);
        }

        public void addReturnListener(ReturnListener listener) {
            this.delegate.removeReturnListener(listener);
        }

        public ReturnListener addReturnListener(ReturnCallback returnCallback) {
            return this.delegate.addReturnListener(returnCallback);
        }

        public boolean removeReturnListener(ReturnListener listener) {
            return this.delegate.removeReturnListener(listener);
        }

        public void clearReturnListeners() {
            this.delegate.clearReturnListeners();
        }

        public void addConfirmListener(ConfirmListener listener) {
            this.delegate.addConfirmListener(listener);
        }

        public ConfirmListener addConfirmListener(ConfirmCallback ackCallback, ConfirmCallback nackCallback) {
            return this.delegate.addConfirmListener(ackCallback, nackCallback);
        }

        public boolean removeConfirmListener(ConfirmListener listener) {
            return this.delegate.removeConfirmListener(listener);
        }

        public void clearConfirmListeners() {
            this.delegate.clearConfirmListeners();
        }

        public Consumer getDefaultConsumer() {
            return this.delegate.getDefaultConsumer();
        }

        public void setDefaultConsumer(Consumer consumer) {
            this.delegate.setDefaultConsumer(consumer);
        }

        public void basicQos(int prefetchSize, int prefetchCount, boolean global) throws IOException {
            this.delegate.basicQos(prefetchSize, prefetchCount, global);
        }

        public void basicQos(int prefetchCount, boolean global) throws IOException {
            this.delegate.basicQos(prefetchCount, global);
        }

        public void basicQos(int prefetchCount) throws IOException {
            this.delegate.basicQos(prefetchCount);
        }

        public void basicPublish(String exchange, String routingKey, AMQP.BasicProperties props, byte[] body) throws IOException {
            this.delegate.basicPublish(exchange, routingKey, props, body);
        }

        public void basicPublish(String exchange, String routingKey, boolean mandatory, AMQP.BasicProperties props, byte[] body) throws IOException {
            this.delegate.basicPublish(exchange, routingKey, mandatory, props, body);
        }

        public void basicPublish(String exchange, String routingKey, boolean mandatory, boolean immediate, AMQP.BasicProperties props, byte[] body) throws IOException {
            this.delegate.basicPublish(exchange, routingKey, mandatory, immediate, props, body);
        }

        public AMQP.Exchange.DeclareOk exchangeDeclare(String exchange, String type) throws IOException {
            return this.delegate.exchangeDeclare(exchange, type);
        }

        public AMQP.Exchange.DeclareOk exchangeDeclare(String exchange, BuiltinExchangeType type) throws IOException {
            return this.delegate.exchangeDeclare(exchange, type);
        }

        public AMQP.Exchange.DeclareOk exchangeDeclare(String exchange, String type, boolean durable) throws IOException {
            return this.delegate.exchangeDeclare(exchange, type, durable);
        }

        public AMQP.Exchange.DeclareOk exchangeDeclare(String exchange, BuiltinExchangeType type, boolean durable) throws IOException {
            return this.delegate.exchangeDeclare(exchange, type, durable);
        }

        public AMQP.Exchange.DeclareOk exchangeDeclare(String exchange, String type, boolean durable, boolean autoDelete, Map<String, Object> arguments) throws IOException {
            return this.delegate.exchangeDeclare(exchange, type, durable, autoDelete, arguments);
        }

        public AMQP.Exchange.DeclareOk exchangeDeclare(String exchange, BuiltinExchangeType type, boolean durable, boolean autoDelete, Map<String, Object> arguments) throws IOException {
            return this.delegate.exchangeDeclare(exchange, type, durable, autoDelete, arguments);
        }

        public AMQP.Exchange.DeclareOk exchangeDeclare(String exchange, String type, boolean durable, boolean autoDelete, boolean internal, Map<String, Object> arguments) throws IOException {
            return this.delegate.exchangeDeclare(exchange, type, durable, autoDelete, internal, arguments);
        }

        public AMQP.Exchange.DeclareOk exchangeDeclare(String exchange, BuiltinExchangeType type, boolean durable, boolean autoDelete, boolean internal, Map<String, Object> arguments) throws IOException {
            return this.delegate.exchangeDeclare(exchange, type, durable, autoDelete, internal, arguments);
        }

        public void exchangeDeclareNoWait(String exchange, String type, boolean durable, boolean autoDelete, boolean internal, Map<String, Object> arguments) throws IOException {
            this.delegate.exchangeDeclareNoWait(exchange, type, durable, autoDelete, internal, arguments);
        }

        public void exchangeDeclareNoWait(String exchange, BuiltinExchangeType type, boolean durable, boolean autoDelete, boolean internal, Map<String, Object> arguments) throws IOException {
            this.delegate.exchangeDeclare(exchange, type, durable, autoDelete, internal, arguments);
        }

        public AMQP.Exchange.DeclareOk exchangeDeclarePassive(String name) throws IOException {
            return this.delegate.exchangeDeclarePassive(name);
        }

        public AMQP.Exchange.DeleteOk exchangeDelete(String exchange, boolean ifUnused) throws IOException {
            return this.delegate.exchangeDelete(exchange, ifUnused);
        }

        public void exchangeDeleteNoWait(String exchange, boolean ifUnused) throws IOException {
            this.delegate.exchangeDeleteNoWait(exchange, ifUnused);
        }

        public AMQP.Exchange.DeleteOk exchangeDelete(String exchange) throws IOException {
            return this.delegate.exchangeDelete(exchange);
        }

        public AMQP.Exchange.BindOk exchangeBind(String destination, String source, String routingKey) throws IOException {
            return this.delegate.exchangeBind(destination, source, routingKey);
        }

        public AMQP.Exchange.BindOk exchangeBind(String destination, String source, String routingKey, Map<String, Object> arguments) throws IOException {
            return this.delegate.exchangeBind(destination, source, routingKey, arguments);
        }

        public void exchangeBindNoWait(String destination, String source, String routingKey, Map<String, Object> arguments) throws IOException {
            this.delegate.exchangeBindNoWait(destination, source, routingKey, arguments);
        }

        public AMQP.Exchange.UnbindOk exchangeUnbind(String destination, String source, String routingKey) throws IOException {
            return this.delegate.exchangeUnbind(destination, source, routingKey);
        }

        public AMQP.Exchange.UnbindOk exchangeUnbind(String destination, String source, String routingKey, Map<String, Object> arguments) throws IOException {
            return this.delegate.exchangeUnbind(destination, source, routingKey, arguments);
        }

        public void exchangeUnbindNoWait(String destination, String source, String routingKey, Map<String, Object> arguments) throws IOException {
            this.delegate.exchangeBindNoWait(destination, source, routingKey, arguments);
        }

        public AMQP.Queue.DeclareOk queueDeclare() throws IOException {
            return this.delegate.queueDeclare();
        }

        public AMQP.Queue.DeclareOk queueDeclare(String queue, boolean durable, boolean exclusive, boolean autoDelete, Map<String, Object> arguments) throws IOException {
            return this.delegate.queueDeclare(queue, durable, exclusive, autoDelete, arguments);
        }

        public void queueDeclareNoWait(String queue, boolean durable, boolean exclusive, boolean autoDelete, Map<String, Object> arguments) throws IOException {
            this.delegate.queueDeclareNoWait(queue, durable, exclusive, autoDelete, arguments);
        }

        public AMQP.Queue.DeclareOk queueDeclarePassive(String queue) throws IOException {
            return this.delegate.queueDeclarePassive(queue);
        }

        public AMQP.Queue.DeleteOk queueDelete(String queue) throws IOException {
            return this.delegate.queueDelete(queue);
        }

        public AMQP.Queue.DeleteOk queueDelete(String queue, boolean ifUnused, boolean ifEmpty) throws IOException {
            return this.delegate.queueDelete(queue, ifUnused, ifEmpty);
        }

        public void queueDeleteNoWait(String queue, boolean ifUnused, boolean ifEmpty) throws IOException {
            this.delegate.queueDeleteNoWait(queue, ifUnused, ifEmpty);
        }

        public AMQP.Queue.BindOk queueBind(String queue, String exchange, String routingKey) throws IOException {
            return this.delegate.queueBind(queue, exchange, routingKey);
        }

        public AMQP.Queue.BindOk queueBind(String queue, String exchange, String routingKey, Map<String, Object> arguments) throws IOException {
            return this.delegate.queueBind(queue, exchange, routingKey, arguments);
        }

        public void queueBindNoWait(String queue, String exchange, String routingKey, Map<String, Object> arguments) throws IOException {
            this.delegate.queueBindNoWait(queue, exchange, routingKey, arguments);
        }

        public AMQP.Queue.UnbindOk queueUnbind(String queue, String exchange, String routingKey) throws IOException {
            return this.delegate.queueUnbind(queue, exchange, routingKey);
        }

        public AMQP.Queue.UnbindOk queueUnbind(String queue, String exchange, String routingKey, Map<String, Object> arguments) throws IOException {
            return this.delegate.queueUnbind(queue, exchange, routingKey, arguments);
        }

        public AMQP.Queue.PurgeOk queuePurge(String queue) throws IOException {
            return this.delegate.queuePurge(queue);
        }

        public GetResponse basicGet(String queue, boolean autoAck) throws IOException {
            return this.delegate.basicGet(queue, autoAck);
        }

        public void basicAck(long deliveryTag, boolean multiple) throws IOException {
            this.delegate.basicAck(deliveryTag, multiple);
        }

        public void basicNack(long deliveryTag, boolean multiple, boolean requeue) throws IOException {
            this.delegate.basicNack(deliveryTag, multiple, requeue);
        }

        public void basicReject(long deliveryTag, boolean requeue) throws IOException {
            this.delegate.basicReject(deliveryTag, requeue);
        }

        public String basicConsume(String queue, Consumer callback) throws IOException {
            return this.delegate.basicConsume(queue, callback);
        }

        public String basicConsume(String queue, DeliverCallback deliverCallback, CancelCallback cancelCallback) throws IOException {
            return this.delegate.basicConsume(queue, deliverCallback, cancelCallback);
        }

        public String basicConsume(String queue, DeliverCallback deliverCallback, ConsumerShutdownSignalCallback shutdownSignalCallback) throws IOException {
            return this.delegate.basicConsume(queue, deliverCallback, shutdownSignalCallback);
        }

        public String basicConsume(String queue, DeliverCallback deliverCallback, CancelCallback cancelCallback, ConsumerShutdownSignalCallback shutdownSignalCallback) throws IOException {
            return this.delegate.basicConsume(queue, deliverCallback, cancelCallback, shutdownSignalCallback);
        }

        public String basicConsume(String queue, boolean autoAck, Consumer callback) throws IOException {
            return this.delegate.basicConsume(queue, autoAck, callback);
        }

        public String basicConsume(String queue, boolean autoAck, DeliverCallback deliverCallback, CancelCallback cancelCallback) throws IOException {
            return this.delegate.basicConsume(queue, autoAck, deliverCallback, cancelCallback);
        }

        public String basicConsume(String queue, boolean autoAck, DeliverCallback deliverCallback, ConsumerShutdownSignalCallback shutdownSignalCallback) throws IOException {
            return this.delegate.basicConsume(queue, autoAck, deliverCallback, shutdownSignalCallback);
        }

        public String basicConsume(String queue, boolean autoAck, DeliverCallback deliverCallback, CancelCallback cancelCallback, ConsumerShutdownSignalCallback shutdownSignalCallback) throws IOException {
            return this.delegate.basicConsume(queue, autoAck, deliverCallback, cancelCallback, shutdownSignalCallback);
        }

        public String basicConsume(String queue, boolean autoAck, Map<String, Object> arguments, Consumer callback) throws IOException {
            return this.delegate.basicConsume(queue, autoAck, arguments, callback);
        }

        public String basicConsume(String queue, boolean autoAck, Map<String, Object> arguments, DeliverCallback deliverCallback, CancelCallback cancelCallback) throws IOException {
            return this.delegate.basicConsume(queue, autoAck, arguments, deliverCallback, cancelCallback);
        }

        public String basicConsume(String queue, boolean autoAck, Map<String, Object> arguments, DeliverCallback deliverCallback, ConsumerShutdownSignalCallback shutdownSignalCallback) throws IOException {
            return this.delegate.basicConsume(queue, autoAck, arguments, deliverCallback, shutdownSignalCallback);
        }

        public String basicConsume(String queue, boolean autoAck, Map<String, Object> arguments, DeliverCallback deliverCallback, CancelCallback cancelCallback, ConsumerShutdownSignalCallback shutdownSignalCallback) throws IOException {
            return this.delegate.basicConsume(queue, autoAck, arguments, deliverCallback, cancelCallback, shutdownSignalCallback);
        }

        public String basicConsume(String queue, boolean autoAck, String consumerTag, Consumer callback) throws IOException {
            return this.delegate.basicConsume(queue, autoAck, consumerTag, callback);
        }

        public String basicConsume(String queue, boolean autoAck, String consumerTag, DeliverCallback deliverCallback, CancelCallback cancelCallback) throws IOException {
            return this.delegate.basicConsume(queue, autoAck, consumerTag, deliverCallback, cancelCallback);
        }

        public String basicConsume(String queue, boolean autoAck, String consumerTag, DeliverCallback deliverCallback, ConsumerShutdownSignalCallback shutdownSignalCallback) throws IOException {
            return this.delegate.basicConsume(queue, autoAck, consumerTag, deliverCallback, shutdownSignalCallback);
        }

        public String basicConsume(String queue, boolean autoAck, String consumerTag, DeliverCallback deliverCallback, CancelCallback cancelCallback, ConsumerShutdownSignalCallback shutdownSignalCallback) throws IOException {
            return this.delegate.basicConsume(queue, autoAck, consumerTag, deliverCallback, cancelCallback, shutdownSignalCallback);
        }

        public String basicConsume(String queue, boolean autoAck, String consumerTag, boolean noLocal, boolean exclusive, Map<String, Object> arguments, Consumer callback) throws IOException {
            return this.delegate.basicConsume(queue, autoAck, consumerTag, noLocal, exclusive, arguments, callback);
        }

        public String basicConsume(String queue, boolean autoAck, String consumerTag, boolean noLocal, boolean exclusive, Map<String, Object> arguments, DeliverCallback deliverCallback, CancelCallback cancelCallback) throws IOException {
            return this.delegate.basicConsume(queue, autoAck, consumerTag, noLocal, exclusive, arguments, deliverCallback, cancelCallback);
        }

        public String basicConsume(String queue, boolean autoAck, String consumerTag, boolean noLocal, boolean exclusive, Map<String, Object> arguments, DeliverCallback deliverCallback, ConsumerShutdownSignalCallback shutdownSignalCallback) throws IOException {
            return this.delegate.basicConsume(queue, autoAck, consumerTag, noLocal, exclusive, arguments, deliverCallback, shutdownSignalCallback);
        }

        public String basicConsume(String queue, boolean autoAck, String consumerTag, boolean noLocal, boolean exclusive, Map<String, Object> arguments, DeliverCallback deliverCallback, CancelCallback cancelCallback, ConsumerShutdownSignalCallback shutdownSignalCallback) throws IOException {
            return this.delegate.basicConsume(queue, autoAck, consumerTag, noLocal, exclusive, arguments, deliverCallback, cancelCallback, shutdownSignalCallback);
        }

        public void basicCancel(String consumerTag) throws IOException {
            this.delegate.basicCancel(consumerTag);
        }

        public AMQP.Basic.RecoverOk basicRecover() throws IOException {
            return this.delegate.basicRecover();
        }

        public AMQP.Basic.RecoverOk basicRecover(boolean requeue) throws IOException {
            return this.delegate.basicRecover(requeue);
        }

        public AMQP.Tx.SelectOk txSelect() throws IOException {
            return this.delegate.txSelect();
        }

        public AMQP.Tx.CommitOk txCommit() throws IOException {
            return this.delegate.txCommit();
        }

        public AMQP.Tx.RollbackOk txRollback() throws IOException {
            return this.delegate.txRollback();
        }

        public long getNextPublishSeqNo() {
            return this.delegate.getNextPublishSeqNo();
        }

        public boolean waitForConfirms() throws InterruptedException {
            return this.delegate.waitForConfirms();
        }

        public boolean waitForConfirms(long timeout) throws InterruptedException, TimeoutException {
            return this.delegate.waitForConfirms(timeout);
        }

        public void waitForConfirmsOrDie() throws IOException, InterruptedException {
            this.delegate.waitForConfirmsOrDie();
        }

        public void waitForConfirmsOrDie(long timeout) throws IOException, InterruptedException, TimeoutException {
            this.delegate.waitForConfirms(timeout);
        }

        public void asyncRpc(Method method) throws IOException {
            this.delegate.asyncRpc(method);
        }

        public Command rpc(Method method) throws IOException {
            return this.delegate.rpc(method);
        }

        public long messageCount(String queue) throws IOException {
            return this.delegate.messageCount(queue);
        }

        public long consumerCount(String queue) throws IOException {
            return this.delegate.consumerCount(queue);
        }

        public CompletableFuture<Command> asyncCompletableRpc(Method method) throws IOException {
            return this.delegate.asyncCompletableRpc(method);
        }

        public void addShutdownListener(ShutdownListener listener) {
            this.delegate.addShutdownListener(listener);
        }

        public void removeShutdownListener(ShutdownListener listener) {
            this.delegate.removeShutdownListener(listener);
        }

        public ShutdownSignalException getCloseReason() {
            return this.delegate.getCloseReason();
        }

        public void notifyListeners() {
            this.delegate.notifyListeners();
        }

        public boolean isOpen() {
            return this.delegate.isOpen();
        }
    }
}

