/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.search.Explanation;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.Version;
import org.elasticsearch.action.OriginalIndices;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.compress.CompressorFactory;
import org.elasticsearch.common.document.DocumentField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentFragment;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.SearchShardTarget;
import org.elasticsearch.search.SearchSortValues;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightField;
import org.elasticsearch.search.lookup.SourceLookup;
import org.elasticsearch.transport.RemoteClusterAware;

public final class SearchHit
implements Writeable,
ToXContentObject,
Iterable<DocumentField> {
    private final transient int docId;
    private static final float DEFAULT_SCORE = Float.NaN;
    private float score = Float.NaN;
    private final Text id;
    private final Text type;
    private final NestedIdentity nestedIdentity;
    private long version = -1L;
    private long seqNo = -2L;
    private long primaryTerm = 0L;
    private BytesReference source;
    private Map<String, DocumentField> documentFields;
    private final Map<String, DocumentField> metaFields;
    private Map<String, HighlightField> highlightFields = null;
    private SearchSortValues sortValues = SearchSortValues.EMPTY;
    private String[] matchedQueries = Strings.EMPTY_ARRAY;
    private Explanation explanation;
    @Nullable
    private SearchShardTarget shard;
    private transient String index;
    private transient String clusterAlias;
    private Map<String, Object> sourceAsMap;
    private Map<String, SearchHits> innerHits;
    static final String DOCUMENT_FIELDS = "document_fields";
    static final String METADATA_FIELDS = "metadata_fields";
    public static final ObjectParser.UnknownFieldConsumer<Map<String, Object>> unknownMetaFieldConsumer = (map, fieldName, fieldValue) -> {
        Map fieldMap = (Map)map.computeIfAbsent(METADATA_FIELDS, v -> new HashMap());
        if (fieldName.equals("_ignored")) {
            fieldMap.put(fieldName, new DocumentField(fieldName, (List)fieldValue));
        } else {
            fieldMap.put(fieldName, new DocumentField(fieldName, Collections.singletonList(fieldValue)));
        }
    };
    private static final ObjectParser<Map<String, Object>, Void> MAP_PARSER = new ObjectParser("innerHitParser", unknownMetaFieldConsumer, HashMap::new);

    public SearchHit(int docId) {
        this(docId, null, null, null, null);
    }

    public SearchHit(int docId, String id, Text type, Map<String, DocumentField> documentFields, Map<String, DocumentField> metaFields) {
        this(docId, id, type, null, documentFields, metaFields);
    }

    public SearchHit(int nestedTopDocId, String id, Text type, NestedIdentity nestedIdentity, Map<String, DocumentField> documentFields, Map<String, DocumentField> metaFields) {
        this.docId = nestedTopDocId;
        this.id = id != null ? new Text(id) : null;
        this.type = type;
        this.nestedIdentity = nestedIdentity;
        this.documentFields = documentFields == null ? Collections.emptyMap() : documentFields;
        this.metaFields = metaFields == null ? Collections.emptyMap() : metaFields;
    }

    public SearchHit(StreamInput in) throws IOException {
        this.docId = -1;
        this.score = in.readFloat();
        this.id = in.readOptionalText();
        this.type = in.readOptionalText();
        this.nestedIdentity = in.readOptionalWriteable(NestedIdentity::new);
        this.version = in.readLong();
        if (in.getVersion().onOrAfter(Version.V_6_7_0)) {
            this.seqNo = in.readZLong();
            this.primaryTerm = in.readVLong();
        }
        this.source = in.readBytesReference();
        if (this.source.length() == 0) {
            this.source = null;
        }
        if (in.readBoolean()) {
            this.explanation = Lucene.readExplanation(in);
        }
        if (in.getVersion().onOrAfter(Version.V_7_8_0)) {
            this.documentFields = in.readMap(StreamInput::readString, DocumentField::new);
            this.metaFields = in.readMap(StreamInput::readString, DocumentField::new);
        } else {
            Map<String, DocumentField> fields = this.readFields(in);
            this.documentFields = new HashMap<String, DocumentField>();
            this.metaFields = new HashMap<String, DocumentField>();
            fields.forEach((? super K fieldName, ? super V docField) -> (MapperService.META_FIELDS_BEFORE_7DOT8.contains(fieldName) ? this.metaFields : this.documentFields).put((String)fieldName, (DocumentField)docField));
        }
        int size = in.readVInt();
        if (size == 0) {
            this.highlightFields = Collections.emptyMap();
        } else if (size == 1) {
            HighlightField field = new HighlightField(in);
            this.highlightFields = Collections.singletonMap(field.name(), field);
        } else {
            HashMap<String, HighlightField> highlightFields = new HashMap<String, HighlightField>();
            for (int i = 0; i < size; ++i) {
                HighlightField field = new HighlightField(in);
                highlightFields.put(field.name(), field);
            }
            this.highlightFields = Collections.unmodifiableMap(highlightFields);
        }
        this.sortValues = new SearchSortValues(in);
        size = in.readVInt();
        if (size > 0) {
            this.matchedQueries = new String[size];
            for (int i = 0; i < size; ++i) {
                this.matchedQueries[i] = in.readString();
            }
        }
        this.shard(in.readOptionalWriteable(SearchShardTarget::new));
        size = in.readVInt();
        if (size > 0) {
            this.innerHits = new HashMap<String, SearchHits>(size);
            for (int i = 0; i < size; ++i) {
                String key = in.readString();
                SearchHits value = new SearchHits(in);
                this.innerHits.put(key, value);
            }
        } else {
            this.innerHits = null;
        }
    }

    private Map<String, DocumentField> readFields(StreamInput in) throws IOException {
        Map<String, DocumentField> fields;
        int size = in.readVInt();
        if (size == 0) {
            fields = Collections.emptyMap();
        } else if (size == 1) {
            DocumentField hitField = new DocumentField(in);
            fields = Collections.singletonMap(hitField.getName(), hitField);
        } else {
            fields = new HashMap<String, DocumentField>(size);
            for (int i = 0; i < size; ++i) {
                DocumentField field = new DocumentField(in);
                fields.put(field.getName(), field);
            }
            fields = Collections.unmodifiableMap(fields);
        }
        return fields;
    }

    private void writeFields(StreamOutput out, Map<String, DocumentField> fields) throws IOException {
        if (fields == null) {
            out.writeVInt(0);
        } else {
            out.writeVInt(fields.size());
            for (DocumentField field : fields.values()) {
                field.writeTo(out);
            }
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeFloat(this.score);
        out.writeOptionalText(this.id);
        out.writeOptionalText(this.type);
        out.writeOptionalWriteable(this.nestedIdentity);
        out.writeLong(this.version);
        if (out.getVersion().onOrAfter(Version.V_6_7_0)) {
            out.writeZLong(this.seqNo);
            out.writeVLong(this.primaryTerm);
        }
        out.writeBytesReference(this.source);
        if (this.explanation == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            Lucene.writeExplanation(out, this.explanation);
        }
        if (out.getVersion().onOrAfter(Version.V_7_8_0)) {
            out.writeMap(this.documentFields, StreamOutput::writeString, (stream, documentField) -> documentField.writeTo(stream));
            out.writeMap(this.metaFields, StreamOutput::writeString, (stream, documentField) -> documentField.writeTo(stream));
        } else {
            this.writeFields(out, this.getFields());
        }
        if (this.highlightFields == null) {
            out.writeVInt(0);
        } else {
            out.writeVInt(this.highlightFields.size());
            for (HighlightField highlightField : this.highlightFields.values()) {
                highlightField.writeTo(out);
            }
        }
        this.sortValues.writeTo(out);
        if (this.matchedQueries.length == 0) {
            out.writeVInt(0);
        } else {
            out.writeVInt(this.matchedQueries.length);
            for (String matchedFilter : this.matchedQueries) {
                out.writeString(matchedFilter);
            }
        }
        out.writeOptionalWriteable(this.shard);
        if (this.innerHits == null) {
            out.writeVInt(0);
        } else {
            out.writeVInt(this.innerHits.size());
            for (Map.Entry entry : this.innerHits.entrySet()) {
                out.writeString((String)entry.getKey());
                ((SearchHits)entry.getValue()).writeTo(out);
            }
        }
    }

    public int docId() {
        return this.docId;
    }

    public void score(float score) {
        this.score = score;
    }

    public float getScore() {
        return this.score;
    }

    public void version(long version) {
        this.version = version;
    }

    public long getVersion() {
        return this.version;
    }

    public void setSeqNo(long seqNo) {
        this.seqNo = seqNo;
    }

    public void setPrimaryTerm(long primaryTerm) {
        this.primaryTerm = primaryTerm;
    }

    public long getSeqNo() {
        return this.seqNo;
    }

    public long getPrimaryTerm() {
        return this.primaryTerm;
    }

    public String getIndex() {
        return this.index;
    }

    public String getId() {
        return this.id != null ? this.id.string() : null;
    }

    @Deprecated
    public String getType() {
        return this.type != null ? this.type.string() : null;
    }

    public NestedIdentity getNestedIdentity() {
        return this.nestedIdentity;
    }

    public BytesReference getSourceRef() {
        if (this.source == null) {
            return null;
        }
        try {
            this.source = CompressorFactory.uncompressIfNeeded(this.source);
            return this.source;
        }
        catch (IOException e) {
            throw new ElasticsearchParseException("failed to decompress source", (Throwable)e, new Object[0]);
        }
    }

    public SearchHit sourceRef(BytesReference source) {
        this.source = source;
        this.sourceAsMap = null;
        return this;
    }

    public boolean hasSource() {
        return this.source != null;
    }

    public String getSourceAsString() {
        if (this.source == null) {
            return null;
        }
        try {
            return XContentHelper.convertToJson(this.getSourceRef(), false);
        }
        catch (IOException e) {
            throw new ElasticsearchParseException("failed to convert source to a json string", new Object[0]);
        }
    }

    public Map<String, Object> getSourceAsMap() {
        if (this.source == null) {
            return null;
        }
        if (this.sourceAsMap != null) {
            return this.sourceAsMap;
        }
        this.sourceAsMap = SourceLookup.sourceAsMap(this.source);
        return this.sourceAsMap;
    }

    @Override
    public Iterator<DocumentField> iterator() {
        Map<String, DocumentField> allFields = this.getFields();
        return allFields.values().iterator();
    }

    public DocumentField field(String fieldName) {
        DocumentField result = this.documentFields.get(fieldName);
        if (result != null) {
            return result;
        }
        return this.metaFields.get(fieldName);
    }

    public void setDocumentField(String fieldName, DocumentField field) {
        if (fieldName == null || field == null) {
            return;
        }
        if (this.documentFields.size() == 0) {
            this.documentFields = new HashMap<String, DocumentField>();
        }
        this.documentFields.put(fieldName, field);
    }

    public Map<String, DocumentField> getFields() {
        if (this.metaFields.size() > 0 || this.documentFields.size() > 0) {
            HashMap<String, DocumentField> fields = new HashMap<String, DocumentField>();
            fields.putAll(this.metaFields);
            fields.putAll(this.documentFields);
            return fields;
        }
        return Collections.emptyMap();
    }

    public Map<String, HighlightField> getHighlightFields() {
        return this.highlightFields == null ? Collections.emptyMap() : this.highlightFields;
    }

    public void highlightFields(Map<String, HighlightField> highlightFields) {
        this.highlightFields = highlightFields;
    }

    public void sortValues(Object[] sortValues, DocValueFormat[] sortValueFormats) {
        this.sortValues(new SearchSortValues(sortValues, sortValueFormats));
    }

    public void sortValues(SearchSortValues sortValues) {
        this.sortValues = sortValues;
    }

    public Object[] getSortValues() {
        return this.sortValues.getFormattedSortValues();
    }

    public Object[] getRawSortValues() {
        return this.sortValues.getRawSortValues();
    }

    public Explanation getExplanation() {
        return this.explanation;
    }

    public void explanation(Explanation explanation) {
        this.explanation = explanation;
    }

    public SearchShardTarget getShard() {
        return this.shard;
    }

    public void shard(SearchShardTarget target) {
        if (this.innerHits != null) {
            for (SearchHits innerHits : this.innerHits.values()) {
                for (SearchHit innerHit : innerHits) {
                    innerHit.shard(target);
                }
            }
        }
        this.shard = target;
        if (target != null) {
            this.index = target.getIndex();
            this.clusterAlias = target.getClusterAlias();
        }
    }

    public String getClusterAlias() {
        return this.clusterAlias;
    }

    public void matchedQueries(String[] matchedQueries) {
        this.matchedQueries = matchedQueries;
    }

    public String[] getMatchedQueries() {
        return this.matchedQueries;
    }

    public Map<String, SearchHits> getInnerHits() {
        return this.innerHits;
    }

    public void setInnerHits(Map<String, SearchHits> innerHits) {
        this.innerHits = innerHits;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.toInnerXContent(builder, params);
        builder.endObject();
        return builder;
    }

    public XContentBuilder toInnerXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.getExplanation() != null && this.shard != null) {
            builder.field("_shard", (ToXContent)this.shard.getShardId());
            builder.field("_node", (ToXContent)this.shard.getNodeIdText());
        }
        if (this.index != null) {
            builder.field("_index", RemoteClusterAware.buildRemoteIndexName(this.clusterAlias, this.index));
        }
        if (this.type != null) {
            builder.field("_type", (ToXContent)this.type);
        }
        if (this.id != null) {
            builder.field("_id", (ToXContent)this.id);
        }
        if (this.nestedIdentity != null) {
            this.nestedIdentity.toXContent(builder, params);
        }
        if (this.version != -1L) {
            builder.field("_version", this.version);
        }
        if (this.seqNo != -2L) {
            builder.field("_seq_no", this.seqNo);
            builder.field("_primary_term", this.primaryTerm);
        }
        if (Float.isNaN(this.score)) {
            builder.nullField("_score");
        } else {
            builder.field("_score", this.score);
        }
        for (DocumentField documentField : this.metaFields.values()) {
            if (documentField.getValues().size() == 0) continue;
            if (documentField.getName().equals("_ignored")) {
                builder.field(documentField.getName(), documentField.getValues());
                continue;
            }
            builder.field(documentField.getName(), documentField.getValue());
        }
        if (this.source != null) {
            XContentHelper.writeRawField("_source", this.source, builder, params);
        }
        if (!this.documentFields.isEmpty() && this.documentFields.values().stream().anyMatch(df -> df.getValues().size() > 0)) {
            builder.startObject("fields");
            for (DocumentField documentField : this.documentFields.values()) {
                if (documentField.getValues().size() <= 0) continue;
                documentField.toXContent(builder, params);
            }
            builder.endObject();
        }
        if (this.highlightFields != null && !this.highlightFields.isEmpty()) {
            builder.startObject("highlight");
            for (HighlightField highlightField : this.highlightFields.values()) {
                highlightField.toXContent(builder, params);
            }
            builder.endObject();
        }
        this.sortValues.toXContent(builder, params);
        if (this.matchedQueries.length > 0) {
            builder.startArray("matched_queries");
            for (Iterator<Object> iterator : this.matchedQueries) {
                builder.value(iterator);
            }
            builder.endArray();
        }
        if (this.getExplanation() != null) {
            builder.field("_explanation");
            this.buildExplanation(builder, this.getExplanation());
        }
        if (this.innerHits != null) {
            builder.startObject("inner_hits");
            for (Map.Entry entry : this.innerHits.entrySet()) {
                builder.startObject((String)entry.getKey());
                ((SearchHits)entry.getValue()).toXContent(builder, params);
                builder.endObject();
            }
            builder.endObject();
        }
        return builder;
    }

    public static SearchHit fromXContent(XContentParser parser) {
        return SearchHit.createFromMap((Map)MAP_PARSER.apply(parser, null));
    }

    public static void declareInnerHitsParseFields(ObjectParser<Map<String, Object>, Void> parser) {
        parser.declareString((map, value) -> map.put("_type", new Text((String)value)), new ParseField("_type", new String[0]));
        parser.declareString((map, value) -> map.put("_index", value), new ParseField("_index", new String[0]));
        parser.declareString((map, value) -> map.put("_id", value), new ParseField("_id", new String[0]));
        parser.declareString((map, value) -> map.put("_node", value), new ParseField("_node", new String[0]));
        parser.declareField((map, value) -> map.put("_score", value), SearchHit::parseScore, new ParseField("_score", new String[0]), ObjectParser.ValueType.FLOAT_OR_NULL);
        parser.declareLong((map, value) -> map.put("_version", value), new ParseField("_version", new String[0]));
        parser.declareLong((map, value) -> map.put("_seq_no", value), new ParseField("_seq_no", new String[0]));
        parser.declareLong((map, value) -> map.put("_primary_term", value), new ParseField("_primary_term", new String[0]));
        parser.declareField((map, value) -> map.put("_shard", value), (p, c) -> ShardId.fromString(p.text()), new ParseField("_shard", new String[0]), ObjectParser.ValueType.STRING);
        parser.declareObject((map, value) -> map.put("_source", value), (p, c) -> SearchHit.parseSourceBytes(p), new ParseField("_source", new String[0]));
        parser.declareObject((map, value) -> map.put("highlight", value), (p, c) -> SearchHit.parseHighlightFields(p), new ParseField("highlight", new String[0]));
        parser.declareObject((map, value) -> {
            Map fieldMap = SearchHit.get("fields", map, new HashMap());
            fieldMap.putAll(value);
            map.put(DOCUMENT_FIELDS, fieldMap);
        }, (p, c) -> SearchHit.parseFields(p), new ParseField("fields", new String[0]));
        parser.declareObject((map, value) -> map.put("_explanation", value), (p, c) -> SearchHit.parseExplanation(p), new ParseField("_explanation", new String[0]));
        parser.declareObject((map, value) -> map.put("_nested", value), NestedIdentity::fromXContent, new ParseField("_nested", new String[0]));
        parser.declareObject((map, value) -> map.put("inner_hits", value), (p, c) -> SearchHit.parseInnerHits(p), new ParseField("inner_hits", new String[0]));
        parser.declareStringArray((map, list) -> map.put("matched_queries", list), new ParseField("matched_queries", new String[0]));
        parser.declareField((map, list) -> map.put("sort", list), SearchSortValues::fromXContent, new ParseField("sort", new String[0]), ObjectParser.ValueType.OBJECT_ARRAY);
    }

    public static SearchHit createFromMap(Map<String, Object> values) {
        int indexOf;
        String id = SearchHit.get("_id", values, null);
        Text type = SearchHit.get("_type", values, null);
        NestedIdentity nestedIdentity = SearchHit.get("_nested", values, null);
        Map<String, DocumentField> metaFields = SearchHit.get(METADATA_FIELDS, values, Collections.emptyMap());
        Map<String, DocumentField> documentFields = SearchHit.get(DOCUMENT_FIELDS, values, Collections.emptyMap());
        SearchHit searchHit = new SearchHit(-1, id, type, nestedIdentity, documentFields, metaFields);
        String index = SearchHit.get("_index", values, null);
        String clusterAlias = null;
        if (index != null && (indexOf = index.indexOf(58)) > 0) {
            clusterAlias = index.substring(0, indexOf);
            index = index.substring(indexOf + 1);
        }
        ShardId shardId = SearchHit.get("_shard", values, null);
        String nodeId = SearchHit.get("_node", values, null);
        if (shardId != null && nodeId != null) {
            assert (shardId.getIndexName().equals(index));
            searchHit.shard(new SearchShardTarget(nodeId, shardId, clusterAlias, OriginalIndices.NONE));
        } else {
            searchHit.index = index;
            searchHit.clusterAlias = clusterAlias;
        }
        searchHit.score(SearchHit.get("_score", values, Float.valueOf(Float.NaN)).floatValue());
        searchHit.version(SearchHit.get("_version", values, -1L));
        searchHit.setSeqNo(SearchHit.get("_seq_no", values, -2L));
        searchHit.setPrimaryTerm(SearchHit.get("_primary_term", values, 0L));
        searchHit.sortValues(SearchHit.get("sort", values, SearchSortValues.EMPTY));
        searchHit.highlightFields(SearchHit.get("highlight", values, null));
        searchHit.sourceRef(SearchHit.get("_source", values, null));
        searchHit.explanation(SearchHit.get("_explanation", values, null));
        searchHit.setInnerHits(SearchHit.get("inner_hits", values, null));
        List matchedQueries = SearchHit.get("matched_queries", values, null);
        if (matchedQueries != null) {
            searchHit.matchedQueries(matchedQueries.toArray(new String[0]));
        }
        return searchHit;
    }

    private static <T> T get(String key, Map<String, Object> map, T defaultValue) {
        return (T)map.getOrDefault(key, defaultValue);
    }

    private static float parseScore(XContentParser parser) throws IOException {
        if (parser.currentToken() == XContentParser.Token.VALUE_NUMBER || parser.currentToken() == XContentParser.Token.VALUE_STRING) {
            return parser.floatValue();
        }
        return Float.NaN;
    }

    private static BytesReference parseSourceBytes(XContentParser parser) throws IOException {
        try (XContentBuilder builder = XContentBuilder.builder((XContent)parser.contentType().xContent());){
            builder.copyCurrentStructure(parser);
            BytesReference bytesReference = BytesReference.bytes(builder);
            return bytesReference;
        }
    }

    private static Map<String, DocumentField> parseFields(XContentParser parser) throws IOException {
        HashMap<String, DocumentField> fields = new HashMap<String, DocumentField>();
        while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            DocumentField field = DocumentField.fromXContent(parser);
            fields.put(field.getName(), field);
        }
        return fields;
    }

    private static Map<String, SearchHits> parseInnerHits(XContentParser parser) throws IOException {
        HashMap<String, SearchHits> innerHits = new HashMap<String, SearchHits>();
        while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            XContentParserUtils.ensureExpectedToken(XContentParser.Token.FIELD_NAME, parser.currentToken(), parser);
            String name = parser.currentName();
            XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.nextToken(), parser);
            XContentParserUtils.ensureFieldName(parser, parser.nextToken(), "hits");
            innerHits.put(name, SearchHits.fromXContent(parser));
            XContentParserUtils.ensureExpectedToken(XContentParser.Token.END_OBJECT, parser.nextToken(), parser);
        }
        return innerHits;
    }

    private static Map<String, HighlightField> parseHighlightFields(XContentParser parser) throws IOException {
        HashMap<String, HighlightField> highlightFields = new HashMap<String, HighlightField>();
        while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            HighlightField highlightField = HighlightField.fromXContent(parser);
            highlightFields.put(highlightField.getName(), highlightField);
        }
        return highlightFields;
    }

    private static Explanation parseExplanation(XContentParser parser) throws IOException {
        XContentParser.Token token;
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.currentToken(), parser);
        Float value = null;
        String description = null;
        ArrayList<Explanation> details = new ArrayList<Explanation>();
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            XContentParserUtils.ensureExpectedToken(XContentParser.Token.FIELD_NAME, token, parser);
            String currentFieldName = parser.currentName();
            token = parser.nextToken();
            if ("value".equals(currentFieldName)) {
                value = Float.valueOf(parser.floatValue());
                continue;
            }
            if ("description".equals(currentFieldName)) {
                description = parser.textOrNull();
                continue;
            }
            if ("details".equals(currentFieldName)) {
                XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_ARRAY, token, parser);
                while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                    details.add(SearchHit.parseExplanation(parser));
                }
                continue;
            }
            parser.skipChildren();
        }
        if (value == null) {
            throw new ParsingException(parser.getTokenLocation(), "missing explanation value", new Object[0]);
        }
        if (description == null) {
            throw new ParsingException(parser.getTokenLocation(), "missing explanation description", new Object[0]);
        }
        return Explanation.match(value, description, details);
    }

    private void buildExplanation(XContentBuilder builder, Explanation explanation) throws IOException {
        builder.startObject();
        builder.field("value", (Object)explanation.getValue());
        builder.field("description", explanation.getDescription());
        Explanation[] innerExps = explanation.getDetails();
        if (innerExps != null) {
            builder.startArray("details");
            for (Explanation exp : innerExps) {
                this.buildExplanation(builder, exp);
            }
            builder.endArray();
        }
        builder.endObject();
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SearchHit other = (SearchHit)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.type, other.type) && Objects.equals(this.nestedIdentity, other.nestedIdentity) && Objects.equals(this.version, other.version) && Objects.equals(this.seqNo, other.seqNo) && Objects.equals(this.primaryTerm, other.primaryTerm) && Objects.equals(this.source, other.source) && Objects.equals(this.documentFields, other.documentFields) && Objects.equals(this.metaFields, other.metaFields) && Objects.equals(this.getHighlightFields(), other.getHighlightFields()) && Arrays.equals(this.matchedQueries, other.matchedQueries) && Objects.equals(this.explanation, other.explanation) && Objects.equals(this.shard, other.shard) && Objects.equals(this.innerHits, other.innerHits) && Objects.equals(this.index, other.index) && Objects.equals(this.clusterAlias, other.clusterAlias);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.nestedIdentity, this.version, this.seqNo, this.primaryTerm, this.source, this.documentFields, this.metaFields, this.getHighlightFields(), Arrays.hashCode(this.matchedQueries), this.explanation, this.shard, this.innerHits, this.index, this.clusterAlias);
    }

    public String toString() {
        return Strings.toString((ToXContent)this, true, true);
    }

    static {
        SearchHit.declareInnerHitsParseFields(MAP_PARSER);
    }

    public static final class NestedIdentity
    implements Writeable,
    ToXContentFragment {
        private static final String _NESTED = "_nested";
        private static final String FIELD = "field";
        private static final String OFFSET = "offset";
        private final Text field;
        private final int offset;
        private final NestedIdentity child;
        private static final ConstructingObjectParser<NestedIdentity, Void> PARSER = new ConstructingObjectParser("nested_identity", true, ctorArgs -> new NestedIdentity((String)ctorArgs[0], (Integer)ctorArgs[1], (NestedIdentity)ctorArgs[2]));

        public NestedIdentity(String field, int offset, NestedIdentity child) {
            this.field = new Text(field);
            this.offset = offset;
            this.child = child;
        }

        NestedIdentity(StreamInput in) throws IOException {
            this.field = in.readOptionalText();
            this.offset = in.readInt();
            this.child = in.readOptionalWriteable(NestedIdentity::new);
        }

        public Text getField() {
            return this.field;
        }

        public int getOffset() {
            return this.offset;
        }

        public NestedIdentity getChild() {
            return this.child;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeOptionalText(this.field);
            out.writeInt(this.offset);
            out.writeOptionalWriteable(this.child);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field(_NESTED);
            return this.innerToXContent(builder, params);
        }

        XContentBuilder innerToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            if (this.field != null) {
                builder.field(FIELD, (ToXContent)this.field);
            }
            if (this.offset != -1) {
                builder.field(OFFSET, this.offset);
            }
            if (this.child != null) {
                builder = this.child.toXContent(builder, params);
            }
            builder.endObject();
            return builder;
        }

        static NestedIdentity fromXContent(XContentParser parser, Void context) {
            return NestedIdentity.fromXContent(parser);
        }

        public static NestedIdentity fromXContent(XContentParser parser) {
            return (NestedIdentity)PARSER.apply(parser, null);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            NestedIdentity other = (NestedIdentity)obj;
            return Objects.equals(this.field, other.field) && Objects.equals(this.offset, other.offset) && Objects.equals(this.child, other.child);
        }

        public int hashCode() {
            return Objects.hash(this.field, this.offset, this.child);
        }

        static {
            PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField(FIELD, new String[0]));
            PARSER.declareInt(ConstructingObjectParser.constructorArg(), new ParseField(OFFSET, new String[0]));
            PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), PARSER, new ParseField(_NESTED, new String[0]));
        }
    }

    public static class Fields {
        static final String _INDEX = "_index";
        static final String _TYPE = "_type";
        static final String _ID = "_id";
        static final String _VERSION = "_version";
        static final String _SEQ_NO = "_seq_no";
        static final String _PRIMARY_TERM = "_primary_term";
        static final String _SCORE = "_score";
        static final String FIELDS = "fields";
        static final String HIGHLIGHT = "highlight";
        static final String SORT = "sort";
        static final String MATCHED_QUERIES = "matched_queries";
        static final String _EXPLANATION = "_explanation";
        static final String VALUE = "value";
        static final String DESCRIPTION = "description";
        static final String DETAILS = "details";
        static final String INNER_HITS = "inner_hits";
        static final String _SHARD = "_shard";
        static final String _NODE = "_node";
    }
}

