/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.server.core.filesystem;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.james.filesystem.api.JamesDirectoriesProvider;
import org.apache.james.server.core.filesystem.ClassPathResource;
import org.apache.james.server.core.filesystem.FileSystemResource;
import org.apache.james.server.core.filesystem.Resource;
import org.apache.james.server.core.filesystem.UrlResource;

public class ResourceFactory {
    private final JamesDirectoriesProvider directoryProvider;

    public ResourceFactory(JamesDirectoriesProvider directoryProvider) {
        this.directoryProvider = directoryProvider;
    }

    public void validate(File file) throws IOException {
        Path resourcePath = file.toPath().normalize();
        if (!(resourcePath.startsWith(Paths.get(this.directoryProvider.getConfDirectory(), new String[0]).normalize()) || resourcePath.startsWith(Paths.get(this.directoryProvider.getRootDirectory(), new String[0]).normalize()) || resourcePath.startsWith(Paths.get(this.directoryProvider.getVarDirectory(), new String[0]).normalize()))) {
            throw new IOException(String.format("%s path is not part of allowed resource locations: %s, %s, %s", resourcePath.toFile().getCanonicalPath(), this.directoryProvider.getConfDirectory(), this.directoryProvider.getRootDirectory(), this.directoryProvider.getVarDirectory()));
        }
    }

    public Resource getResource(String fileURL) {
        if (fileURL.startsWith("classpath:")) {
            return this.handleClasspathProtocol(fileURL);
        }
        if (fileURL.startsWith("file://")) {
            return this.handleFileProtocol(fileURL);
        }
        try {
            return this.handleUrlResource(fileURL);
        }
        catch (MalformedURLException ex) {
            return new ClassPathResource(fileURL);
        }
    }

    private Resource handleUrlResource(String fileURL) throws MalformedURLException {
        URL url = new URL(fileURL);
        return new UrlResource(url);
    }

    private Resource handleClasspathProtocol(String fileURL) {
        String resourceName = fileURL.substring("classpath:".length());
        return new ClassPathResource(resourceName);
    }

    private Resource handleFileProtocol(String fileURL) {
        File file = this.interpretPath(fileURL);
        return new FileSystemResource(file);
    }

    private File interpretPath(String fileURL) {
        if (FileProtocol.CONF.match(fileURL)) {
            return new File(this.directoryProvider.getConfDirectory() + "/" + FileProtocol.CONF.removeProtocolFromPath(fileURL));
        }
        if (FileProtocol.VAR.match(fileURL)) {
            return new File(this.directoryProvider.getVarDirectory() + "/" + FileProtocol.VAR.removeProtocolFromPath(fileURL));
        }
        if (FileProtocol.ABSOLUTE.match(fileURL)) {
            return new File(this.directoryProvider.getAbsoluteDirectory() + FileProtocol.ABSOLUTE.removeProtocolFromPath(fileURL));
        }
        return new File(this.directoryProvider.getRootDirectory() + "/" + FileProtocol.OTHER.removeProtocolFromPath(fileURL));
    }

    private static enum FileProtocol {
        CONF("file://conf/"),
        VAR("file://var/"),
        ABSOLUTE("file:///"),
        OTHER("file://");

        private final String protocolPrefix;

        private FileProtocol(String protocolPrefix) {
            this.protocolPrefix = protocolPrefix;
        }

        private boolean match(String path) {
            return path.startsWith(this.protocolPrefix);
        }

        private String removeProtocolFromPath(String path) {
            return path.substring(this.protocolPrefix.length());
        }
    }
}

