/****************************************************************
 * Licensed to the Apache Software Foundation (ASF) under one   *
 * or more contributor license agreements.  See the NOTICE file *
 * distributed with this work for additional information        *
 * regarding copyright ownership.  The ASF licenses this file   *
 * to you under the Apache License, Version 2.0 (the            *
 * "License"); you may not use this file except in compliance   *
 * with the License.  You may obtain a copy of the License at   *
 *                                                              *
 *   http://www.apache.org/licenses/LICENSE-2.0                 *
 *                                                              *
 * Unless required by applicable law or agreed to in writing,   *
 * software distributed under the License is distributed on an  *
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY       *
 * KIND, either express or implied.  See the License for the    *
 * specific language governing permissions and limitations      *
 * under the License.                                           *
 ****************************************************************/

package org.apache.james.jmap.cassandra.projections.table;

import java.util.Locale;

public interface CassandraEmailQueryViewTable {
    String TABLE_NAME_SENT_AT = "email_query_view_sent_at";
    String TABLE_NAME_RECEIVED_AT = "email_query_view_received_at";
    String DATE_LOOKUP_TABLE = "email_query_view_date_lookup";

    String MAILBOX_ID = "mailboxId";
    String MESSAGE_ID = "messageId";
    String MESSAGE_ID_LOWERCASE = MESSAGE_ID.toLowerCase(Locale.US);
    String RECEIVED_AT = "receivedAt";
    String SENT_AT = "sentAt";
}
