/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.jpa.mail;

import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceException;
import org.apache.james.backends.jpa.EntityManagerUtils;
import org.apache.james.mailbox.ModSeq;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.jpa.JPAId;
import org.apache.james.mailbox.jpa.mail.model.JPAMailbox;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.store.mail.ModSeqProvider;

public class JPAModSeqProvider
implements ModSeqProvider {
    private final EntityManagerFactory factory;

    @Inject
    public JPAModSeqProvider(EntityManagerFactory factory) {
        this.factory = factory;
    }

    public ModSeq highestModSeq(Mailbox mailbox) throws MailboxException {
        JPAId mailboxId = (JPAId)mailbox.getMailboxId();
        return this.highestModSeq(mailboxId);
    }

    public ModSeq nextModSeq(Mailbox mailbox) throws MailboxException {
        return this.nextModSeq((JPAId)mailbox.getMailboxId());
    }

    public ModSeq nextModSeq(MailboxId mailboxId) throws MailboxException {
        return this.nextModSeq((JPAId)mailboxId);
    }

    public ModSeq highestModSeq(MailboxId mailboxId) throws MailboxException {
        return this.highestModSeq((JPAId)mailboxId);
    }

    private ModSeq nextModSeq(JPAId mailboxId) throws MailboxException {
        EntityManager manager = null;
        try {
            manager = this.factory.createEntityManager();
            manager.getTransaction().begin();
            JPAMailbox m = (JPAMailbox)manager.find(JPAMailbox.class, (Object)mailboxId.getRawId());
            long modSeq = m.consumeModSeq();
            manager.persist((Object)m);
            manager.getTransaction().commit();
            ModSeq modSeq2 = ModSeq.of((long)modSeq);
            return modSeq2;
        }
        catch (PersistenceException e) {
            if (manager != null && manager.getTransaction().isActive()) {
                manager.getTransaction().rollback();
            }
            throw new MailboxException("Unable to save highest mod-sequence for mailbox " + mailboxId.serialize(), (Throwable)e);
        }
        finally {
            EntityManagerUtils.safelyClose((EntityManager)manager);
        }
    }

    private ModSeq highestModSeq(JPAId mailboxId) throws MailboxException {
        EntityManager manager = null;
        try {
            manager = this.factory.createEntityManager();
            long highest = (Long)manager.createNamedQuery("findHighestModSeq").setParameter("idParam", (Object)mailboxId.getRawId()).getSingleResult();
            ModSeq modSeq = ModSeq.of((long)highest);
            return modSeq;
        }
        catch (PersistenceException e) {
            throw new MailboxException("Unable to get highest mod-sequence for mailbox " + mailboxId.serialize(), (Throwable)e);
        }
        finally {
            EntityManagerUtils.safelyClose((EntityManager)manager);
        }
    }
}

