/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules.server;

import com.github.fge.lambdas.Throwing;
import com.google.common.collect.ImmutableMap;
import java.lang.management.ManagementFactory;
import java.net.ServerSocket;
import java.rmi.registry.LocateRegistry;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.james.lifecycle.api.Startable;
import org.apache.james.modules.server.JmxConfiguration;
import org.apache.james.util.RestrictingRMISocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMXServer
implements Startable {
    private static final Logger LOGGER = LoggerFactory.getLogger(JMXServer.class);
    private final JmxConfiguration jmxConfiguration;
    private final Set<String> registeredKeys;
    private final Object lock;
    private JMXConnectorServer jmxConnectorServer;
    private boolean isStarted;
    private RestrictingRMISocketFactory restrictingRMISocketFactory;

    @Inject
    public JMXServer(JmxConfiguration jmxConfiguration) {
        this.jmxConfiguration = jmxConfiguration;
        this.isStarted = false;
        this.registeredKeys = new HashSet<String>();
        this.lock = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.jmxConfiguration.isEnabled()) {
                return;
            }
            if (this.isStarted) {
                return;
            }
            this.isStarted = true;
            this.doStart();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PreDestroy
    public void stop() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isStarted) {
                return;
            }
            this.isStarted = false;
            this.doStop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(String key, Object remote) throws Exception {
        ManagementFactory.getPlatformMBeanServer().registerMBean(remote, new ObjectName(key));
        Object object = this.lock;
        synchronized (object) {
            this.registeredKeys.add(key);
        }
    }

    private void doStart() {
        try {
            String serviceURL = "service:jmx:rmi://" + this.jmxConfiguration.getHost().getHostName() + "/jndi/rmi://" + this.jmxConfiguration.getHost().getHostName() + ":" + this.jmxConfiguration.getHost().getPort() + "/jmxrmi";
            this.restrictingRMISocketFactory = new RestrictingRMISocketFactory(this.jmxConfiguration.getHost().getHostName());
            LocateRegistry.createRegistry(this.jmxConfiguration.getHost().getPort(), (RMIClientSocketFactory)this.restrictingRMISocketFactory, (RMIServerSocketFactory)this.restrictingRMISocketFactory);
            ImmutableMap environment = ImmutableMap.of();
            this.jmxConnectorServer = JMXConnectorServerFactory.newJMXConnectorServer(new JMXServiceURL(serviceURL), environment, ManagementFactory.getPlatformMBeanServer());
            this.jmxConnectorServer.start();
            LOGGER.info("JMX server started");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void doStop() {
        try {
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            this.registeredKeys.forEach(Throwing.consumer(key -> mBeanServer.unregisterMBean(new ObjectName((String)key))));
            this.registeredKeys.clear();
            this.jmxConnectorServer.stop();
            this.restrictingRMISocketFactory.getSockets().forEach(Throwing.consumer(ServerSocket::close).sneakyThrow());
            LOGGER.info("JMX server stopped");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

