/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveash.guavate;

import com.github.steveash.guavate.ObjIntPair;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Multimap;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.tuple.Pair;

public final class Guavate {
    private Guavate() {
    }

    public static <T> Stream<T> stream(Iterable<T> iterable) {
        return StreamSupport.stream(iterable.spliterator(), false);
    }

    public static <T> Stream<T> stream(Optional<T> optional) {
        return optional.isPresent() ? Stream.of(optional.get()) : Stream.empty();
    }

    public static <T> Stream<ObjIntPair<T>> zipWithIndex(Stream<T> stream) {
        Spliterator split1 = stream.spliterator();
        final Iterator it1 = Spliterators.iterator(split1);
        Iterator it = new Iterator<ObjIntPair<T>>(){
            int index = 0;

            @Override
            public boolean hasNext() {
                return it1.hasNext();
            }

            @Override
            public ObjIntPair<T> next() {
                return ObjIntPair.of(it1.next(), this.index++);
            }
        };
        Spliterator split2 = Spliterators.spliterator(it, split1.getExactSizeIfKnown(), split1.characteristics());
        return StreamSupport.stream(split2, false);
    }

    public static <A, B> Stream<Pair<A, B>> zip(Stream<A> stream1, Stream<B> stream2) {
        return Guavate.zip(stream1, stream2, (a, b) -> Pair.of(a, b));
    }

    private static <A, B, R> Stream<R> zip(Stream<A> stream1, Stream<B> stream2, final BiFunction<A, B, R> zipper) {
        Spliterator split1 = stream1.spliterator();
        Spliterator split2 = stream2.spliterator();
        int characteristics = split1.characteristics() & split2.characteristics() & 0xFFFFFFFA;
        long size = Math.min(split1.getExactSizeIfKnown(), split2.getExactSizeIfKnown());
        final Iterator it1 = Spliterators.iterator(split1);
        final Iterator it2 = Spliterators.iterator(split2);
        Iterator it = new Iterator<R>(){

            @Override
            public boolean hasNext() {
                return it1.hasNext() && it2.hasNext();
            }

            @Override
            public R next() {
                return zipper.apply(it1.next(), it2.next());
            }
        };
        Spliterator split3 = Spliterators.spliterator(it, size, characteristics);
        return StreamSupport.stream(split3, false);
    }

    public static <R> Predicate<R> not(Predicate<R> predicate) {
        return predicate.negate();
    }

    public static <T> BinaryOperator<T> ensureOnlyOne() {
        return (a, b) -> {
            throw new IllegalArgumentException("Multiple values found where only one was expected: " + a + " and " + b);
        };
    }

    public static <T> Collector<T, ImmutableList.Builder<T>, ImmutableList<T>> toImmutableList() {
        return Collector.of(ImmutableList.Builder::new, ImmutableList.Builder::add, (l, r) -> l.addAll((Iterable)r.build()), ImmutableList.Builder::build, new Collector.Characteristics[0]);
    }

    public static <T> Collector<T, ImmutableSet.Builder<T>, ImmutableSet<T>> toImmutableSet() {
        return Collector.of(ImmutableSet.Builder::new, ImmutableSet.Builder::add, (l, r) -> l.addAll((Iterable)r.build()), ImmutableSet.Builder::build, Collector.Characteristics.UNORDERED);
    }

    public static <T extends Comparable<?>> Collector<T, ImmutableSortedSet.Builder<T>, ImmutableSortedSet<T>> toImmutableSortedSet() {
        return Collector.of(ImmutableSortedSet::naturalOrder, ImmutableSortedSet.Builder::add, (l, r) -> l.addAll((Iterable)r.build()), ImmutableSortedSet.Builder::build, Collector.Characteristics.UNORDERED);
    }

    public static <T> Collector<T, ImmutableSortedSet.Builder<T>, ImmutableSortedSet<T>> toImmutableSortedSet(Comparator<? super T> comparator) {
        return Collector.of(() -> new ImmutableSortedSet.Builder(comparator), ImmutableSortedSet.Builder::add, (l, r) -> l.addAll((Iterable)r.build()), ImmutableSortedSet.Builder::build, Collector.Characteristics.UNORDERED);
    }

    public static <T> Collector<T, ImmutableMultiset.Builder<T>, ImmutableMultiset<T>> toImmutableMultiset() {
        return Collector.of(ImmutableMultiset.Builder::new, ImmutableMultiset.Builder::add, (l, r) -> l.addAll((Iterable)r.build()), ImmutableMultiset.Builder::build, Collector.Characteristics.UNORDERED);
    }

    public static <T, K> Collector<T, ?, ImmutableMap<K, T>> toImmutableMap(Function<? super T, ? extends K> keyExtractor) {
        return Guavate.toImmutableMap(keyExtractor, Function.identity());
    }

    public static <T, K, V> Collector<T, ?, ImmutableMap<K, V>> toImmutableMap(Function<? super T, ? extends K> keyExtractor, Function<? super T, ? extends V> valueExtractor) {
        return Collector.of(ImmutableMap.Builder::new, (builder, val) -> builder.put(keyExtractor.apply(val), valueExtractor.apply(val)), (l, r) -> l.putAll(r.build()), ImmutableMap.Builder::build, Collector.Characteristics.UNORDERED);
    }

    public static <T, K, V> Collector<T, Map<K, V>, ImmutableMap<K, V>> toImmutableMap(Function<? super T, ? extends K> keyExtractor, Function<? super T, ? extends V> valueExtractor, BiFunction<? super V, ? super V, ? extends V> mergeFn) {
        return Collector.of(HashMap::new, (map, val) -> map.merge(keyExtractor.apply(val), valueExtractor.apply(val), mergeFn), (m1, m22) -> Guavate.mergeMaps(m1, m22, mergeFn), map -> ImmutableMap.copyOf(map), Collector.Characteristics.UNORDERED);
    }

    public static <T, K extends Comparable<?>> Collector<T, ?, ImmutableSortedMap<K, T>> toImmutableSortedMap(Function<? super T, ? extends K> keyExtractor) {
        return Guavate.toImmutableSortedMap(keyExtractor, Function.identity());
    }

    public static <T, K extends Comparable<?>, V> Collector<T, ?, ImmutableSortedMap<K, V>> toImmutableSortedMap(Function<? super T, ? extends K> keyExtractor, Function<? super T, ? extends V> valueExtractor) {
        return Collector.of(ImmutableSortedMap::naturalOrder, (builder, val) -> builder.put(keyExtractor.apply(val), valueExtractor.apply(val)), (l, r) -> l.putAll((Map)r.build()), ImmutableSortedMap.Builder::build, Collector.Characteristics.UNORDERED);
    }

    public static <T, K> Collector<T, ?, ImmutableListMultimap<K, T>> toImmutableListMultimap(Function<? super T, ? extends K> keyExtractor) {
        return Guavate.toImmutableListMultimap(keyExtractor, Function.identity());
    }

    public static <T, K, V> Collector<T, ?, ImmutableListMultimap<K, V>> toImmutableListMultimap(Function<? super T, ? extends K> keyExtractor, Function<? super T, ? extends V> valueExtractor) {
        return Collector.of(ImmutableListMultimap.Builder::new, (builder, val) -> builder.put(keyExtractor.apply(val), valueExtractor.apply(val)), (l, r) -> l.putAll((Multimap)r.build()), ImmutableListMultimap.Builder::build, Collector.Characteristics.UNORDERED);
    }

    public static <T, K> Collector<T, ?, ImmutableSetMultimap<K, T>> toImmutableSetMultimap(Function<? super T, ? extends K> keyExtractor) {
        return Guavate.toImmutableSetMultimap(keyExtractor, Function.identity());
    }

    public static <T, K, V> Collector<T, ?, ImmutableSetMultimap<K, V>> toImmutableSetMultimap(Function<? super T, ? extends K> keyExtractor, Function<? super T, ? extends V> valueExtractor) {
        return Collector.of(ImmutableSetMultimap.Builder::new, (builder, val) -> builder.put(keyExtractor.apply(val), valueExtractor.apply(val)), (l, r) -> l.putAll((Multimap)r.build()), ImmutableSetMultimap.Builder::build, Collector.Characteristics.UNORDERED);
    }

    public static <K, V> Collector<Map.Entry<K, V>, ?, ImmutableMap<K, V>> entriesToImmutableMap() {
        return Guavate.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue);
    }

    public static <K, V> Collector<Map.Entry<K, V>, ?, Map<K, V>> entriesToMap() {
        return Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue);
    }

    public static <K, V> Collector<Pair<K, V>, ?, ImmutableMap<K, V>> pairsToImmutableMap() {
        return Guavate.toImmutableMap(Pair::getLeft, Pair::getRight);
    }

    public static <K, V> Collector<Pair<K, V>, ?, Map<K, V>> pairsToMap() {
        return Collectors.toMap(Pair::getLeft, Pair::getRight);
    }

    private static <K, V> Map<K, V> mergeMaps(Map<K, V> map1, Map<K, V> map2, BiFunction<? super V, ? super V, ? extends V> mergeFn) {
        for (Map.Entry<K, V> entry : map2.entrySet()) {
            V existingValue = map1.get(entry.getKey());
            if (existingValue == null) {
                map1.put(entry.getKey(), entry.getValue());
                continue;
            }
            map1.put(entry.getKey(), mergeFn.apply(existingValue, entry.getValue()));
        }
        return map1;
    }
}

