/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.service;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Clock;
import java.util.Optional;
import org.apache.james.json.DTOModule;
import org.apache.james.mailrepository.api.MailKey;
import org.apache.james.mailrepository.api.MailRepositoryPath;
import org.apache.james.queue.api.MailQueueName;
import org.apache.james.server.task.json.dto.TaskDTO;
import org.apache.james.server.task.json.dto.TaskDTOModule;
import org.apache.james.webadmin.service.ReprocessingOneMailTask;
import org.apache.james.webadmin.service.ReprocessingService;

public class ReprocessingOneMailTaskDTO
implements TaskDTO {
    private final String type;
    private final String repositoryPath;
    private final String targetQueue;
    private final String mailKey;
    private final Optional<String> targetProcessor;

    public static TaskDTOModule<ReprocessingOneMailTask, ReprocessingOneMailTaskDTO> module(Clock clock, ReprocessingService reprocessingService) {
        return (TaskDTOModule)DTOModule.forDomainObject(ReprocessingOneMailTask.class).convertToDTO(ReprocessingOneMailTaskDTO.class).toDomainObjectConverter(dto -> dto.fromDTO(reprocessingService, clock)).toDTOConverter(ReprocessingOneMailTaskDTO::toDTO).typeName(ReprocessingOneMailTask.TYPE.asString()).withFactory(TaskDTOModule::new);
    }

    public static ReprocessingOneMailTaskDTO toDTO(ReprocessingOneMailTask domainObject, String typeName) {
        try {
            return new ReprocessingOneMailTaskDTO(typeName, domainObject.getRepositoryPath().urlEncoded(), domainObject.getTargetQueue().asString(), domainObject.getMailKey().asString(), domainObject.getTargetProcessor());
        }
        catch (Exception e) {
            throw new ReprocessingOneMailTask.UrlEncodingFailureSerializationException(domainObject.getRepositoryPath());
        }
    }

    public ReprocessingOneMailTaskDTO(@JsonProperty(value="type") String type, @JsonProperty(value="repositoryPath") String repositoryPath, @JsonProperty(value="targetQueue") String targetQueue, @JsonProperty(value="mailKey") String mailKey, @JsonProperty(value="targetProcessor") Optional<String> targetProcessor) {
        this.type = type;
        this.repositoryPath = repositoryPath;
        this.mailKey = mailKey;
        this.targetQueue = targetQueue;
        this.targetProcessor = targetProcessor;
    }

    public ReprocessingOneMailTask fromDTO(ReprocessingService reprocessingService, Clock clock) {
        return new ReprocessingOneMailTask(reprocessingService, this.getMailRepositoryPath(), MailQueueName.of((String)this.targetQueue), new MailKey(this.mailKey), this.targetProcessor, clock);
    }

    private MailRepositoryPath getMailRepositoryPath() {
        try {
            return MailRepositoryPath.fromEncoded((String)this.repositoryPath);
        }
        catch (Exception e) {
            throw new ReprocessingOneMailTask.InvalidMailRepositoryPathDeserializationException(this.repositoryPath);
        }
    }

    public String getType() {
        return this.type;
    }

    public String getRepositoryPath() {
        return this.repositoryPath;
    }

    public String getMailKey() {
        return this.mailKey;
    }

    public String getTargetQueue() {
        return this.targetQueue;
    }

    public Optional<String> getTargetProcessor() {
        return this.targetProcessor;
    }
}

