/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.routes;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.time.Clock;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import javax.inject.Inject;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.output.CountingOutputStream;
import org.apache.james.mailrepository.api.MailKey;
import org.apache.james.mailrepository.api.MailRepositoryPath;
import org.apache.james.mailrepository.api.MailRepositoryStore;
import org.apache.james.queue.api.MailQueueFactory;
import org.apache.james.queue.api.MailQueueName;
import org.apache.james.task.Task;
import org.apache.james.task.TaskManager;
import org.apache.james.util.streams.Limit;
import org.apache.james.util.streams.Offset;
import org.apache.james.webadmin.Routes;
import org.apache.james.webadmin.dto.ExtendedMailRepositoryResponse;
import org.apache.james.webadmin.dto.InaccessibleFieldException;
import org.apache.james.webadmin.dto.MailDto;
import org.apache.james.webadmin.service.MailRepositoryStoreService;
import org.apache.james.webadmin.service.ReprocessingAllMailsTask;
import org.apache.james.webadmin.service.ReprocessingOneMailTask;
import org.apache.james.webadmin.service.ReprocessingService;
import org.apache.james.webadmin.tasks.TaskFromRequest;
import org.apache.james.webadmin.tasks.TaskFromRequestRegistry;
import org.apache.james.webadmin.tasks.TaskRegistrationKey;
import org.apache.james.webadmin.utils.ErrorResponder;
import org.apache.james.webadmin.utils.JsonTransformer;
import org.apache.james.webadmin.utils.ParametersExtractor;
import org.apache.james.webadmin.utils.Responses;
import spark.HaltException;
import spark.Request;
import spark.Response;
import spark.ResponseTransformer;
import spark.Service;

public class MailRepositoriesRoutes
implements Routes {
    public static final String MAIL_REPOSITORIES = "mailRepositories";
    private static final TaskRegistrationKey REPROCESS_ACTION = TaskRegistrationKey.of((String)"reprocess");
    private final JsonTransformer jsonTransformer;
    private final MailRepositoryStoreService repositoryStoreService;
    private final ReprocessingService reprocessingService;
    private final TaskManager taskManager;
    private Service service;

    @Inject
    public MailRepositoriesRoutes(MailRepositoryStoreService repositoryStoreService, JsonTransformer jsonTransformer, ReprocessingService reprocessingService, TaskManager taskManager) {
        this.repositoryStoreService = repositoryStoreService;
        this.jsonTransformer = jsonTransformer;
        this.reprocessingService = reprocessingService;
        this.taskManager = taskManager;
    }

    public String getBasePath() {
        return MAIL_REPOSITORIES;
    }

    public void define(Service service) {
        this.service = service;
        this.definePutMailRepository();
        this.defineGetMailRepositories();
        this.defineListMails();
        this.defineGetMailRepository();
        this.defineGetMail();
        this.defineDeleteMail();
        this.defineDeleteAll();
        this.defineReprocessAll();
        this.defineReprocessOne();
    }

    public void definePutMailRepository() {
        this.service.put("mailRepositories/:encodedPath", (request, response) -> {
            MailRepositoryPath path = this.decodedRepositoryPath(request);
            String protocol = request.queryParams("protocol");
            try {
                this.repositoryStoreService.createMailRepository(path, protocol);
                return Responses.returnNoContent((Response)response);
            }
            catch (MailRepositoryStore.UnsupportedRepositoryStoreException e) {
                throw ErrorResponder.builder().statusCode(400).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).cause((Exception)((Object)e)).message("'%s' is an unsupported protocol", new Object[]{protocol}).haltError();
            }
            catch (MailRepositoryStore.MailRepositoryStoreException e) {
                throw ErrorResponder.builder().statusCode(500).type(ErrorResponder.ErrorType.SERVER_ERROR).cause((Exception)((Object)e)).message("Error while creating a mail repository with path '%s' and protocol '%s'", new Object[]{path.asString(), protocol}).haltError();
            }
        }, (ResponseTransformer)this.jsonTransformer);
    }

    public void defineListMails() {
        this.service.get("mailRepositories/:encodedPath/mails", (request, response) -> {
            Offset offset = ParametersExtractor.extractOffset((Request)request);
            Limit limit = ParametersExtractor.extractLimit((Request)request);
            MailRepositoryPath path = this.decodedRepositoryPath(request);
            try {
                return this.repositoryStoreService.listMails(path, offset, limit).orElseThrow(() -> this.repositoryNotFound(request.params("encodedPath"), path));
            }
            catch (MessagingException | MailRepositoryStore.MailRepositoryStoreException e) {
                throw ErrorResponder.builder().statusCode(500).type(ErrorResponder.ErrorType.SERVER_ERROR).cause((Exception)e).message("Error while listing keys").haltError();
            }
        }, (ResponseTransformer)this.jsonTransformer);
    }

    public void defineGetMailRepositories() {
        this.service.get(MAIL_REPOSITORIES, (request, response) -> this.repositoryStoreService.listMailRepositories().collect(ImmutableList.toImmutableList()), (ResponseTransformer)this.jsonTransformer);
    }

    public void defineGetMail() {
        this.service.get("mailRepositories/:encodedPath/mails/:mailKey", "application/json", (request, response) -> this.getMailAsJson(this.decodedRepositoryPath(request), new MailKey(request.params("mailKey")), request), (ResponseTransformer)this.jsonTransformer);
        this.service.get("mailRepositories/:encodedPath/mails/:mailKey", "message/rfc822", (request, response) -> this.writeMimeMessage(this.getMailAsMimeMessage(this.decodedRepositoryPath(request), new MailKey(request.params("mailKey"))), response.raw()));
    }

    private Object writeMimeMessage(MimeMessage mimeMessage, HttpServletResponse rawResponse) throws MessagingException, IOException {
        rawResponse.setContentType("message/rfc822");
        rawResponse.setHeader("Content-Length", String.valueOf(this.computeExactSize(mimeMessage)));
        mimeMessage.writeTo((OutputStream)rawResponse.getOutputStream());
        return rawResponse;
    }

    private long computeExactSize(MimeMessage mimeMessage) throws IOException, MessagingException {
        CountingOutputStream countingOutputStream = new CountingOutputStream(OutputStream.nullOutputStream());
        mimeMessage.writeTo((OutputStream)countingOutputStream);
        return countingOutputStream.getByteCount();
    }

    private MimeMessage getMailAsMimeMessage(MailRepositoryPath path, MailKey mailKey) {
        try {
            return this.repositoryStoreService.retrieveMessage(path, mailKey).orElseThrow(this.mailNotFoundError(mailKey));
        }
        catch (MessagingException | MailRepositoryStore.MailRepositoryStoreException e) {
            throw this.internalServerError((Exception)e);
        }
    }

    private MailDto getMailAsJson(MailRepositoryPath path, MailKey mailKey, Request request) {
        try {
            return this.repositoryStoreService.retrieveMail(path, mailKey, this.extractAdditionalFields(request.queryParamOrDefault("additionalFields", ""))).orElseThrow(this.mailNotFoundError(mailKey));
        }
        catch (MessagingException | MailRepositoryStore.MailRepositoryStoreException e) {
            throw this.internalServerError((Exception)e);
        }
        catch (IllegalArgumentException e) {
            throw this.invalidField(e);
        }
        catch (InaccessibleFieldException e) {
            throw this.inaccessibleField(e);
        }
    }

    private HaltException inaccessibleField(InaccessibleFieldException e) {
        return ErrorResponder.builder().statusCode(500).type(ErrorResponder.ErrorType.SERVER_ERROR).cause((Exception)e).message("The field '%s' requested in additionalFields parameter can't be accessed", new Object[]{e.getField().getName()}).haltError();
    }

    private HaltException invalidField(IllegalArgumentException e) {
        return ErrorResponder.builder().statusCode(400).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).cause((Exception)e).message("The field '%s' can't be requested in additionalFields parameter", new Object[]{e.getMessage()}).haltError();
    }

    private Supplier<HaltException> mailNotFoundError(MailKey mailKey) {
        return () -> ErrorResponder.builder().statusCode(404).type(ErrorResponder.ErrorType.NOT_FOUND).message("Could not retrieve %s", new Object[]{mailKey.asString()}).haltError();
    }

    private HaltException repositoryNotFound(String encodedPath, MailRepositoryPath path) {
        return ErrorResponder.builder().statusCode(404).type(ErrorResponder.ErrorType.NOT_FOUND).message("The repository '%s' (decoded value: '%s') does not exist", new Object[]{encodedPath, path.asString()}).haltError();
    }

    private HaltException internalServerError(Exception e) {
        return ErrorResponder.builder().statusCode(500).type(ErrorResponder.ErrorType.SERVER_ERROR).cause(e).message("Error while retrieving mail").haltError();
    }

    public void defineGetMailRepository() {
        this.service.get("mailRepositories/:encodedPath", (request, response) -> {
            MailRepositoryPath path = this.decodedRepositoryPath(request);
            try {
                long size = this.repositoryStoreService.size(path).orElseThrow(() -> this.repositoryNotFound(request.params("encodedPath"), path));
                return new ExtendedMailRepositoryResponse(path, size);
            }
            catch (MailRepositoryStore.MailRepositoryStoreException e) {
                throw ErrorResponder.builder().statusCode(500).type(ErrorResponder.ErrorType.SERVER_ERROR).cause((Exception)((Object)e)).message("Error while retrieving mail repository information").haltError();
            }
        }, (ResponseTransformer)this.jsonTransformer);
    }

    public void defineDeleteMail() {
        this.service.delete("mailRepositories/:encodedPath/mails/:mailKey", (request, response) -> {
            MailRepositoryPath path = this.decodedRepositoryPath(request);
            MailKey mailKey = new MailKey(request.params("mailKey"));
            try {
                this.repositoryStoreService.deleteMail(path, mailKey);
                return Responses.returnNoContent((Response)response);
            }
            catch (MessagingException | MailRepositoryStore.MailRepositoryStoreException e) {
                throw ErrorResponder.builder().statusCode(500).type(ErrorResponder.ErrorType.SERVER_ERROR).cause((Exception)e).message("Error while deleting mail").haltError();
            }
        });
    }

    public void defineDeleteAll() {
        TaskFromRequest taskFromRequest = request -> {
            MailRepositoryPath path = this.decodedRepositoryPath(request);
            try {
                return this.repositoryStoreService.createClearMailRepositoryTask(path);
            }
            catch (MessagingException | MailRepositoryStore.MailRepositoryStoreException e) {
                throw ErrorResponder.builder().statusCode(500).type(ErrorResponder.ErrorType.SERVER_ERROR).cause((Exception)e).message("Error while deleting all mails").haltError();
            }
        };
        this.service.delete("mailRepositories/:encodedPath/mails", taskFromRequest.asRoute(this.taskManager), (ResponseTransformer)this.jsonTransformer);
    }

    public void defineReprocessAll() {
        this.service.patch("mailRepositories/:encodedPath/mails", TaskFromRequestRegistry.of((TaskRegistrationKey)REPROCESS_ACTION, this::reprocessAll).asRoute(this.taskManager), (ResponseTransformer)this.jsonTransformer);
    }

    private Task reprocessAll(Request request) throws UnsupportedEncodingException, MailRepositoryStore.MailRepositoryStoreException {
        MailRepositoryPath path = this.decodedRepositoryPath(request);
        Optional<String> targetProcessor = this.parseTargetProcessor(request);
        MailQueueName targetQueue = this.parseTargetQueue(request);
        Long repositorySize = this.repositoryStoreService.size(path).orElse(0L);
        return new ReprocessingAllMailsTask(this.reprocessingService, repositorySize, path, targetQueue, targetProcessor);
    }

    public void defineReprocessOne() {
        this.service.patch("mailRepositories/:encodedPath/mails/:key", TaskFromRequestRegistry.of((TaskRegistrationKey)REPROCESS_ACTION, this::reprocessOne).asRoute(this.taskManager), (ResponseTransformer)this.jsonTransformer);
    }

    private Task reprocessOne(Request request) throws UnsupportedEncodingException {
        MailRepositoryPath path = this.decodedRepositoryPath(request);
        MailKey key = new MailKey(request.params("key"));
        Optional<String> targetProcessor = this.parseTargetProcessor(request);
        MailQueueName targetQueue = this.parseTargetQueue(request);
        return new ReprocessingOneMailTask(this.reprocessingService, path, targetQueue, key, targetProcessor, Clock.systemUTC());
    }

    private Set<MailDto.AdditionalField> extractAdditionalFields(String additionalFieldsParam) throws IllegalArgumentException {
        return (Set)Splitter.on((char)',').trimResults().omitEmptyStrings().splitToList((CharSequence)additionalFieldsParam).stream().map(field -> MailDto.AdditionalField.find(field).orElseThrow(() -> new IllegalArgumentException((String)field))).collect(ImmutableSet.toImmutableSet());
    }

    private Optional<String> parseTargetProcessor(Request request) {
        return Optional.ofNullable(request.queryParams("processor"));
    }

    private MailQueueName parseTargetQueue(Request request) {
        return Optional.ofNullable(request.queryParams("queue")).map(MailQueueName::of).orElse(MailQueueFactory.SPOOL);
    }

    private MailRepositoryPath decodedRepositoryPath(Request request) throws UnsupportedEncodingException {
        return MailRepositoryPath.fromEncoded((String)request.params("encodedPath"));
    }
}

