/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.guava.GuavaModule;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Arrays;
import java.util.Set;
import javax.inject.Inject;
import org.apache.james.core.Username;
import org.apache.james.jmap.draft.json.RoleMixIn;
import org.apache.james.jmap.draft.model.mailbox.Rights;
import org.apache.james.mailbox.Role;
import org.apache.james.mailbox.model.ContentType;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mdn.action.mode.DispositionActionMode;
import org.apache.james.mdn.sending.mode.DispositionSendingMode;
import org.apache.james.mdn.type.DispositionType;

public class ObjectMapperFactory {
    private static final ImmutableSet.Builder<Module> JACKSON_BASE_MODULES = ImmutableSet.builder().add((Object[])new Module[]{new Jdk8Module(), new JavaTimeModule(), new GuavaModule()});
    private final Set<Module> jacksonModules;

    @Inject
    public ObjectMapperFactory(MailboxId.Factory mailboxIdFactory, MessageId.Factory messageIdFactory) {
        SimpleModule mailboxIdModule = new SimpleModule();
        mailboxIdModule.addDeserializer(MailboxId.class, (JsonDeserializer)new MailboxIdDeserializer(mailboxIdFactory));
        mailboxIdModule.addSerializer(MailboxId.class, (JsonSerializer)new MailboxIdSerializer());
        mailboxIdModule.addKeyDeserializer(MailboxId.class, (KeyDeserializer)new MailboxIdKeyDeserializer(mailboxIdFactory));
        mailboxIdModule.addKeySerializer(MailboxId.class, (JsonSerializer)new MailboxIdKeySerializer());
        mailboxIdModule.addDeserializer(MessageId.class, (JsonDeserializer)new MessageIdDeserializer(messageIdFactory));
        mailboxIdModule.addSerializer(MessageId.class, (JsonSerializer)new MessageIdSerializer());
        mailboxIdModule.addKeyDeserializer(MessageId.class, (KeyDeserializer)new MessageIdKeyDeserializer(messageIdFactory));
        mailboxIdModule.addKeySerializer(MessageId.class, (JsonSerializer)new MessageIdKeySerializer());
        mailboxIdModule.addSerializer(Username.class, (JsonSerializer)new UsernameSerializer());
        mailboxIdModule.addDeserializer(Username.class, (JsonDeserializer)new UsernameDeserializer());
        mailboxIdModule.addKeyDeserializer(Username.class, (KeyDeserializer)new UsernameKeyDeserializer());
        mailboxIdModule.addKeySerializer(Username.class, (JsonSerializer)new UsernameKeySerializer());
        mailboxIdModule.addDeserializer(Rights.Right.class, (JsonDeserializer)new RightDeserializer());
        SimpleModule mdnModule = new SimpleModule();
        mailboxIdModule.addDeserializer(DispositionActionMode.class, (JsonDeserializer)new MDNActionModeDeserializer());
        mailboxIdModule.addDeserializer(DispositionSendingMode.class, (JsonDeserializer)new MDNSendingModeDeserializer());
        mailboxIdModule.addDeserializer(DispositionType.class, (JsonDeserializer)new MDNTypeDeserializer());
        SimpleModule contentTypeModule = new SimpleModule();
        contentTypeModule.addDeserializer(ContentType.class, (JsonDeserializer)new ContentTypeDeserializer());
        contentTypeModule.addSerializer(ContentType.class, (JsonSerializer)new ContentTypeSerializer());
        mailboxIdModule.setMixInAnnotation(Role.class, RoleMixIn.class);
        this.jacksonModules = JACKSON_BASE_MODULES.add((Object)mailboxIdModule).add((Object)mdnModule).add((Object)contentTypeModule).build();
    }

    public ObjectMapper forParsing() {
        return new ObjectMapper().registerModules(this.jacksonModules).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    public ObjectMapper forWriting() {
        return new ObjectMapper().disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS).registerModules(this.jacksonModules);
    }

    public static class MessageIdSerializer
    extends JsonSerializer<MessageId> {
        public void serialize(MessageId value, JsonGenerator gen, SerializerProvider serializers) throws IOException, JsonProcessingException {
            gen.writeString(value.serialize());
        }
    }

    public static class MessageIdKeySerializer
    extends JsonSerializer<MessageId> {
        public void serialize(MessageId value, JsonGenerator gen, SerializerProvider serializers) throws IOException, JsonProcessingException {
            gen.writeFieldName(value.serialize());
        }
    }

    public static class MessageIdKeyDeserializer
    extends KeyDeserializer {
        private MessageId.Factory factory;

        public MessageIdKeyDeserializer(MessageId.Factory factory) {
            this.factory = factory;
        }

        public Object deserializeKey(String key, DeserializationContext ctxt) {
            return this.factory.fromString(key);
        }
    }

    public static class MessageIdDeserializer
    extends JsonDeserializer<MessageId> {
        private MessageId.Factory factory;

        public MessageIdDeserializer(MessageId.Factory factory) {
            this.factory = factory;
        }

        public MessageId deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            return this.factory.fromString(p.getValueAsString());
        }
    }

    public static class MailboxIdKeySerializer
    extends JsonSerializer<MailboxId> {
        public void serialize(MailboxId value, JsonGenerator gen, SerializerProvider serializers) throws IOException, JsonProcessingException {
            gen.writeFieldName(value.serialize());
        }
    }

    public static class MailboxIdKeyDeserializer
    extends KeyDeserializer {
        private MailboxId.Factory factory;

        public MailboxIdKeyDeserializer(MailboxId.Factory factory) {
            this.factory = factory;
        }

        public Object deserializeKey(String key, DeserializationContext ctxt) {
            return this.factory.fromString(key);
        }
    }

    public static class RightDeserializer
    extends JsonDeserializer<Rights.Right> {
        public Rights.Right deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            String nodeValue = p.getValueAsString();
            Preconditions.checkArgument((nodeValue.length() == 1 ? 1 : 0) != 0, (Object)"Rights should be represented as single value characters");
            return Rights.Right.forChar(nodeValue.charAt(0));
        }
    }

    public static class UsernameKeyDeserializer
    extends KeyDeserializer {
        public Object deserializeKey(String key, DeserializationContext ctxt) {
            return Username.of((String)key);
        }
    }

    public static class UsernameDeserializer
    extends JsonDeserializer<Username> {
        public Username deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            return Username.of((String)p.getValueAsString());
        }
    }

    public static class UsernameKeySerializer
    extends JsonSerializer<Username> {
        public void serialize(Username value, JsonGenerator gen, SerializerProvider serializers) throws IOException, JsonProcessingException {
            gen.writeFieldName(value.asString());
        }
    }

    public static class UsernameSerializer
    extends JsonSerializer<Username> {
        public void serialize(Username value, JsonGenerator gen, SerializerProvider serializers) throws IOException, JsonProcessingException {
            gen.writeString(value.asString());
        }
    }

    public static class MailboxIdSerializer
    extends JsonSerializer<MailboxId> {
        public void serialize(MailboxId value, JsonGenerator gen, SerializerProvider serializers) throws IOException, JsonProcessingException {
            gen.writeString(value.serialize());
        }
    }

    public static class MailboxIdDeserializer
    extends JsonDeserializer<MailboxId> {
        private MailboxId.Factory factory;

        public MailboxIdDeserializer(MailboxId.Factory factory) {
            this.factory = factory;
        }

        public MailboxId deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            return this.factory.fromString(p.getValueAsString());
        }
    }

    public static class MDNTypeDeserializer
    extends JsonDeserializer<DispositionType> {
        private static final ImmutableList<String> ALLOWED_VALUES = (ImmutableList)Arrays.stream(DispositionType.values()).map(DispositionType::getValue).collect(ImmutableList.toImmutableList());

        public DispositionType deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            String value = jsonParser.getValueAsString();
            return (DispositionType)DispositionType.fromString((String)value).orElseThrow(() -> new IllegalStateException(String.format("Unrecognized MDN Disposition type %s. Should be one of %s", value, ALLOWED_VALUES)));
        }
    }

    public static class ContentTypeSerializer
    extends JsonSerializer<ContentType> {
        public void serialize(ContentType value, JsonGenerator gen, SerializerProvider serializers) throws IOException, JsonProcessingException {
            gen.writeString(value.asString());
        }
    }

    public static class ContentTypeDeserializer
    extends JsonDeserializer<ContentType> {
        public ContentType deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            String value = jsonParser.getValueAsString();
            return ContentType.of((String)value);
        }
    }

    public static class MDNSendingModeDeserializer
    extends JsonDeserializer<DispositionSendingMode> {
        private static final ImmutableList<String> ALLOWED_VALUES = (ImmutableList)Arrays.stream(DispositionSendingMode.values()).map(DispositionSendingMode::getValue).collect(ImmutableList.toImmutableList());

        public DispositionSendingMode deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            String value = jsonParser.getValueAsString();
            return (DispositionSendingMode)DispositionSendingMode.fromString((String)value).orElseThrow(() -> new IllegalStateException(String.format("Unrecognized MDN Disposition sending mode %s. Should be one of %s", value, ALLOWED_VALUES)));
        }
    }

    public static class MDNActionModeDeserializer
    extends JsonDeserializer<DispositionActionMode> {
        private static final ImmutableList<String> ALLOWED_VALUES = (ImmutableList)Arrays.stream(DispositionActionMode.values()).map(DispositionActionMode::getValue).collect(ImmutableList.toImmutableList());

        public DispositionActionMode deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            String value = jsonParser.getValueAsString();
            return (DispositionActionMode)DispositionActionMode.fromString((String)value).orElseThrow(() -> new IllegalStateException(String.format("Unrecognized MDN Disposition action mode %s. Should be one of %s", value, ALLOWED_VALUES)));
        }
    }
}

