/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.pushsubscription;

import com.google.common.annotations.VisibleForTesting;
import eu.timepit.refined.api.Refined;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import javax.inject.Inject;
import org.apache.james.events.Event;
import org.apache.james.events.EventListener;
import org.apache.james.events.Group;
import org.apache.james.jmap.api.model.PushSubscription;
import org.apache.james.jmap.api.model.TypeName;
import org.apache.james.jmap.api.pushsubscription.PushSubscriptionRepository;
import org.apache.james.jmap.change.EmailDeliveryTypeName$;
import org.apache.james.jmap.change.StateChangeEvent;
import org.apache.james.jmap.core.StateChange;
import org.apache.james.jmap.json.PushSerializer;
import org.apache.james.jmap.pushsubscription.Aes128gcm$;
import org.apache.james.jmap.pushsubscription.High$;
import org.apache.james.jmap.pushsubscription.Low$;
import org.apache.james.jmap.pushsubscription.PushListener$;
import org.apache.james.jmap.pushsubscription.PushListenerGroup;
import org.apache.james.jmap.pushsubscription.PushRequest;
import org.apache.james.jmap.pushsubscription.PushTTL$;
import org.apache.james.jmap.pushsubscription.PushUrgency;
import org.apache.james.jmap.pushsubscription.WebPushClient;
import org.reactivestreams.Publisher;
import play.api.libs.json.Json$;
import reactor.core.scala.publisher.MapablePublisher;
import reactor.core.scala.publisher.SFlux;
import reactor.core.scala.publisher.SFlux$;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import reactor.core.scala.publisher.package$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005\rv!\u0002\t\u0012\u0011\u0003ab!\u0002\u0010\u0012\u0011\u0003y\u0002\"\u0002\u0014\u0002\t\u00039\u0003\"\u0002\u0015\u0002\t\u0003Ic\u0001\u0002\u0010\u0012\u0001MC\u0001b\u001a\u0003\u0003\u0002\u0003\u0006I\u0001\u001b\u0005\t_\u0012\u0011\t\u0011)A\u0005a\"A1\u000f\u0002B\u0001B\u0003%A\u000fC\u0003'\t\u0011\u0005!\u0010C\u0004\u0002\u0012\u0011!\t%a\u0005\t\u000f\u0005uA\u0001\"\u0011\u0002 !9\u0011Q\b\u0003\u0005B\u0005}\u0002bBA%\t\u0011%\u00111\n\u0005\b\u0003k\"A\u0011BA<\u0011\u001d\t\u0019\t\u0002C\u0005\u0003\u000bCq!a&\u0005\t\u0013\tI*\u0001\u0007QkNDG*[:uK:,'O\u0003\u0002\u0013'\u0005\u0001\u0002/^:igV\u00147o\u0019:jaRLwN\u001c\u0006\u0003)U\tAA[7ba*\u0011acF\u0001\u0006U\u0006lWm\u001d\u0006\u00031e\ta!\u00199bG\",'\"\u0001\u000e\u0002\u0007=\u0014xm\u0001\u0001\u0011\u0005u\tQ\"A\t\u0003\u0019A+8\u000f\u001b'jgR,g.\u001a:\u0014\u0005\u0005\u0001\u0003CA\u0011%\u001b\u0005\u0011#\"A\u0012\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0015\u0012#AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u00029\u0005aQ\r\u001f;sC\u000e$Hk\u001c9jGR\u0011!F\u0010\t\u0003Wmr!\u0001L\u001d\u000f\u00055BdB\u0001\u00188\u001d\tycG\u0004\u00021k9\u0011\u0011\u0007N\u0007\u0002e)\u00111gG\u0001\u0007yI|w\u000e\u001e \n\u0003iI!\u0001G\r\n\u0005Y9\u0012B\u0001\u000b\u0016\u0013\t\u00112#\u0003\u0002;#\u0005I\u0001+^:i)>\u0004\u0018nY\u0005\u0003yu\u0012\u0011\u0002U;tQR{\u0007/[2\u000b\u0005i\n\u0002\"B \u0004\u0001\u0004\u0001\u0015aC:uCR,7\t[1oO\u0016\u0004\"!\u0011#\u000e\u0003\tS!aQ\n\u0002\t\r|'/Z\u0005\u0003\u000b\n\u00131b\u0015;bi\u0016\u001c\u0005.\u00198hK\"\u00121a\u0012\t\u0003\u0011Fk\u0011!\u0013\u0006\u0003\u0015.\u000b1\"\u00198o_R\fG/[8og*\u0011A*T\u0001\u0007G>lWn\u001c8\u000b\u00059{\u0015AB4p_\u001edWMC\u0001Q\u0003\r\u0019w.\\\u0005\u0003%&\u0013\u0011CV5tS\ndWMR8s)\u0016\u001cH/\u001b8h'\r!A\u000b\u0018\t\u0003+jk\u0011A\u0016\u0006\u0003/b\u000bA\u0001\\1oO*\t\u0011,\u0001\u0003kCZ\f\u0017BA.W\u0005\u0019y%M[3diB\u0011Q\f\u001a\b\u0003=\u0006t!AL0\n\u0005\u0001,\u0012AB3wK:$8/\u0003\u0002cG\u0006iQI^3oi2K7\u000f^3oKJT!\u0001Y\u000b\n\u0005\u00154'A\u0007*fC\u000e$\u0018N^3He>,\b/\u0012<f]Rd\u0015n\u001d;f]\u0016\u0014(B\u00012d\u00039\u0001Xo\u001d5SKB|7/\u001b;pef\u0004\"![7\u000e\u0003)T!AE6\u000b\u00051\u001c\u0012aA1qS&\u0011aN\u001b\u0002\u001b!V\u001c\bnU;cg\u000e\u0014\u0018\u000e\u001d;j_:\u0014V\r]8tSR|'/_\u0001\u000eo\u0016\u0014\u0007+^:i\u00072LWM\u001c;\u0011\u0005u\t\u0018B\u0001:\u0012\u000559VM\u0019)vg\"\u001cE.[3oi\u0006q\u0001/^:i'\u0016\u0014\u0018.\u00197ju\u0016\u0014\bCA;y\u001b\u00051(BA<\u0014\u0003\u0011Q7o\u001c8\n\u0005e4(A\u0004)vg\"\u001cVM]5bY&TXM\u001d\u000b\u0005wrlh\u0010\u0005\u0002\u001e\t!)q\r\u0003a\u0001Q\")q\u000e\u0003a\u0001a\")1\u000f\u0003a\u0001i\"\u001a\u0001\"!\u0001\u0011\t\u0005\r\u0011QB\u0007\u0003\u0003\u000bQA!a\u0002\u0002\n\u00051\u0011N\u001c6fGRT!!a\u0003\u0002\u000b)\fg/\u0019=\n\t\u0005=\u0011Q\u0001\u0002\u0007\u0013:TWm\u0019;\u0002\u001f\u001d,G\u000fR3gCVdGo\u0012:pkB$\"!!\u0006\u0011\t\u0005]\u0011\u0011D\u0007\u0002G&\u0019\u00111D2\u0003\u000b\u001d\u0013x.\u001e9\u0002\u001bI,\u0017m\u0019;jm\u0016,e/\u001a8u)\u0011\t\t#a\r\u0011\r\u0005\r\u0012\u0011FA\u0017\u001b\t\t)CC\u0002\u0002(e\tqB]3bGRLg/Z:ue\u0016\fWn]\u0005\u0005\u0003W\t)CA\u0005Qk\nd\u0017n\u001d5feB\u0019Q+a\f\n\u0007\u0005EbK\u0001\u0003W_&$\u0007bBA\u001b\u0015\u0001\u0007\u0011qG\u0001\u0006KZ,g\u000e\u001e\t\u0005\u0003/\tI$C\u0002\u0002<\r\u0014Q!\u0012<f]R\f!\"[:IC:$G.\u001b8h)\u0011\t\t%a\u0012\u0011\u0007\u0005\n\u0019%C\u0002\u0002F\t\u0012qAQ8pY\u0016\fg\u000eC\u0004\u00026-\u0001\r!a\u000e\u0002!M,g\u000e\u001a(pi&4\u0017nY1uS>tGCBA'\u0003+\n)\u0007\u0005\u0004\u0002$\u0005%\u0012q\n\t\u0004C\u0005E\u0013bAA*E\t!QK\\5u\u0011\u001d\t9\u0006\u0004a\u0001\u00033\n\u0001\u0003];tQN+(m]2sSB$\u0018n\u001c8\u0011\t\u0005m\u0013\u0011M\u0007\u0003\u0003;R1!a\u0018l\u0003\u0015iw\u000eZ3m\u0013\u0011\t\u0019'!\u0018\u0003!A+8\u000f[*vEN\u001c'/\u001b9uS>t\u0007bBA4\u0019\u0001\u0007\u0011\u0011N\u0001\u0011gR\fG/Z\"iC:<W-\u0012<f]R\u0004B!a\u001b\u0002r5\u0011\u0011Q\u000e\u0006\u0004\u0003_\u001a\u0012AB2iC:<W-\u0003\u0003\u0002t\u00055$\u0001E*uCR,7\t[1oO\u0016,e/\u001a8u\u00035\t7\u000fU;tQJ+\u0017/^3tiR1\u0011\u0011PA@\u0003\u0003\u00032!HA>\u0013\r\ti(\u0005\u0002\f!V\u001c\bNU3rk\u0016\u001cH\u000fC\u0003@\u001b\u0001\u0007\u0001\tC\u0004\u0002X5\u0001\r!!\u0017\u0002\u000f\u0005\u001c()\u001f;fgR1\u0011qQAJ\u0003+\u0003R!IAE\u0003\u001bK1!a##\u0005\u0015\t%O]1z!\r\t\u0013qR\u0005\u0004\u0003#\u0013#\u0001\u0002\"zi\u0016DQa\u0010\bA\u0002\u0001Cq!a\u0016\u000f\u0001\u0004\tI&A\u0004ve\u001e,gnY=\u0015\t\u0005m\u0015\u0011\u0015\t\u0004;\u0005u\u0015bAAP#\tY\u0001+^:i+J<WM\\2z\u0011\u0015yt\u00021\u0001A\u0001")
public class PushListener
implements EventListener.ReactiveGroupEventListener {
    private final PushSubscriptionRepository pushRepository;
    private final WebPushClient webPushClient;
    private final PushSerializer pushSerializer;

    @VisibleForTesting
    public static String extractTopic(StateChange stateChange) {
        return PushListener$.MODULE$.extractTopic(stateChange);
    }

    public void event(Event x$1) throws Exception {
        super.event(x$1);
    }

    public Group getDefaultGroup() {
        return new PushListenerGroup();
    }

    public Publisher<Void> reactiveEvent(Event event) {
        SMono sMono;
        Event event2 = event;
        if (event2 instanceof StateChangeEvent) {
            StateChangeEvent stateChangeEvent = (StateChangeEvent)event2;
            SFlux qual$1 = SFlux$.MODULE$.apply(this.pushRepository.list(stateChangeEvent.username())).filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.validated()));
            Function1 & Serializable x$12 = (Function1 & Serializable)x$2 -> this.sendNotification((PushSubscription)x$2, stateChangeEvent);
            int x$22 = 16;
            int x$3 = qual$1.flatMap$default$3();
            boolean x$4 = qual$1.flatMap$default$4();
            sMono = package$.MODULE$.publisherUnit2PublisherVoid((MapablePublisher)qual$1.flatMap((Function1)x$12, 16, x$3, x$4).then());
        } else {
            sMono = SMono$.MODULE$.empty();
        }
        return sMono;
    }

    public boolean isHandling(Event event) {
        return event instanceof StateChangeEvent;
    }

    private Publisher<BoxedUnit> sendNotification(PushSubscription pushSubscription, StateChangeEvent stateChangeEvent) {
        return (Publisher)stateChangeEvent.asStateChange().filter((Set<TypeName>)pushSubscription.types().toSet()).fold((Function0 & Serializable)() -> SMono$.MODULE$.empty(), (Function1 & Serializable)stateChange -> SMono$.MODULE$.apply($this.webPushClient.push(pushSubscription.url(), this.asPushRequest((StateChange)stateChange, pushSubscription))));
    }

    private PushRequest asPushRequest(StateChange stateChange, PushSubscription pushSubscription) {
        Long x$1 = PushTTL$.MODULE$.MAX();
        Some x$2 = new Some((Object)this.urgency(stateChange));
        Some x$32 = new Some((Object)new Refined((Object)PushListener$.MODULE$.extractTopic(stateChange)));
        Option x$4 = pushSubscription.keys().map((Function1 & Serializable)x$3 -> Aes128gcm$.MODULE$);
        byte[] x$5 = this.asBytes(stateChange, pushSubscription);
        return new PushRequest(x$1, x$4, (Option)x$32, (Option)x$2, x$5);
    }

    private byte[] asBytes(StateChange stateChange, PushSubscription pushSubscription) {
        byte[] clearTextPayload = Json$.MODULE$.stringify(this.pushSerializer.serializeSSE(stateChange)).getBytes(StandardCharsets.UTF_8);
        return (byte[])pushSubscription.keys().map((Function1 & Serializable)keys -> keys.encrypt(clearTextPayload)).getOrElse((Function0 & Serializable)() -> clearTextPayload);
    }

    private PushUrgency urgency(StateChange stateChange) {
        return ((IterableOnceOps)stateChange.changes().values().flatMap((Function1 & Serializable)x$4 -> x$4.changes().keys())).toList().contains((Object)EmailDeliveryTypeName$.MODULE$) ? High$.MODULE$ : Low$.MODULE$;
    }

    @Inject
    public PushListener(PushSubscriptionRepository pushRepository, WebPushClient webPushClient, PushSerializer pushSerializer) {
        this.pushRepository = pushRepository;
        this.webPushClient = webPushClient;
        this.pushSerializer = pushSerializer;
    }
}

