/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.method;

import eu.timepit.refined.api.RefType$;
import eu.timepit.refined.api.Refined;
import eu.timepit.refined.boolean;
import eu.timepit.refined.collection;
import java.io.Serializable;
import java.time.ZonedDateTime;
import java.util.Date;
import javax.inject.Inject;
import javax.mail.Flags;
import org.apache.james.jmap.JMAPConfiguration;
import org.apache.james.jmap.api.model.Size$;
import org.apache.james.jmap.core.Properties;
import org.apache.james.jmap.core.Properties$;
import org.apache.james.jmap.core.SetError;
import org.apache.james.jmap.core.SetError$;
import org.apache.james.jmap.core.UTCDate;
import org.apache.james.jmap.json.EmailSetSerializer;
import org.apache.james.jmap.mail.BlobId$;
import org.apache.james.jmap.mail.EmailCreationId;
import org.apache.james.jmap.mail.EmailCreationRequest;
import org.apache.james.jmap.mail.EmailCreationResponse;
import org.apache.james.jmap.mail.EmailSetRequest;
import org.apache.james.jmap.mail.ThreadId$;
import org.apache.james.jmap.method.EmailSetCreatePerformer$CreationResults$;
import org.apache.james.jmap.method.SizeExceededException;
import org.apache.james.jmap.routes.BlobNotFoundException;
import org.apache.james.jmap.routes.BlobResolvers;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.exception.MailboxNotFoundException;
import org.apache.james.mailbox.exception.OverQuotaException;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mime4j.dom.Message;
import org.apache.james.util.html.HtmlTextExtractor;
import play.api.libs.json.JsObject;
import play.api.libs.json.JsValue;
import reactor.core.scala.publisher.SFlux;
import reactor.core.scala.publisher.SFlux$;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import reactor.core.scheduler.Schedulers;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;

@ScalaSignature(bytes="\u0006\u0005\rUw!\u0002.\\\u0011\u00031g!\u00025\\\u0011\u0003I\u0007\"\u00029\u0002\t\u0003\th\u0001\u0002:\u0002\u0001ND!\"a\u0002\u0004\u0005+\u0007I\u0011AA\u0005\u0011)\tIb\u0001B\tB\u0003%\u00111\u0002\u0005\u0007a\u000e!\t!a\u0007\t\u000f\u0005\u00052\u0001\"\u0001\u0002$!9\u0011QJ\u0002\u0005\u0002\u0005=\u0003\"CA1\u0007\u0005\u0005I\u0011AA2\u0011%\t9gAI\u0001\n\u0003\tI\u0007C\u0005\u0002\u0000\r\t\t\u0011\"\u0011\u0002\u0002\"I\u00111S\u0002\u0002\u0002\u0013\u0005\u0011Q\u0013\u0005\n\u0003;\u001b\u0011\u0011!C\u0001\u0003?C\u0011\"a+\u0004\u0003\u0003%\t%!,\t\u0013\u0005m6!!A\u0005\u0002\u0005u\u0006\"CAd\u0007\u0005\u0005I\u0011IAe\u0011%\timAA\u0001\n\u0003\ny\rC\u0005\u0002R\u000e\t\t\u0011\"\u0011\u0002T\"I\u0011Q[\u0002\u0002\u0002\u0013\u0005\u0013q[\u0004\n\u00037\f\u0011\u0011!E\u0001\u0003;4\u0001B]\u0001\u0002\u0002#\u0005\u0011q\u001c\u0005\u0007aV!\t!a>\t\u0013\u0005EW#!A\u0005F\u0005M\u0007\"CA}+\u0005\u0005I\u0011QA~\u0011%\ty0FA\u0001\n\u0003\u0013\t\u0001C\u0005\u0003\nU\t\t\u0011\"\u0003\u0003\f\u0019I\u0011QC\u0001\u0011\u0002G\u0005\u0011q\u0003\u0004\u0007\u0005'\t\u0001I!\u0006\t\u0015\t]AD!f\u0001\n\u0003\u0011I\u0002\u0003\u0006\u0003\u001cq\u0011\t\u0012)A\u0005\u0003wA!B!\b\u001d\u0005+\u0007I\u0011\u0001B\u0010\u0011)\u0011\t\u0003\bB\tB\u0003%\u0011q\t\u0005\u0007ar!\tAa\t\t\u0013\u0005\u0005D$!A\u0005\u0002\t-\u0002\"CA49E\u0005I\u0011\u0001B\u0019\u0011%\u0011)\u0004HI\u0001\n\u0003\u00119\u0004C\u0005\u0002\u0000q\t\t\u0011\"\u0011\u0002\u0002\"I\u00111\u0013\u000f\u0002\u0002\u0013\u0005\u0011Q\u0013\u0005\n\u0003;c\u0012\u0011!C\u0001\u0005wA\u0011\"a+\u001d\u0003\u0003%\t%!,\t\u0013\u0005mF$!A\u0005\u0002\t}\u0002\"CAd9\u0005\u0005I\u0011\tB\"\u0011%\ti\rHA\u0001\n\u0003\ny\rC\u0005\u0002Rr\t\t\u0011\"\u0011\u0002T\"I\u0011Q\u001b\u000f\u0002\u0002\u0013\u0005#qI\u0004\n\u0005\u0017\n\u0011\u0011!E\u0001\u0005\u001b2\u0011Ba\u0005\u0002\u0003\u0003E\tAa\u0014\t\rA|C\u0011\u0001B,\u0011%\t\tnLA\u0001\n\u000b\n\u0019\u000eC\u0005\u0002z>\n\t\u0011\"!\u0003Z!I\u0011q`\u0018\u0002\u0002\u0013\u0005%q\f\u0005\n\u0005\u0013y\u0013\u0011!C\u0005\u0005\u00171aAa\u001b\u0002\u0001\n5\u0004B\u0003B\fk\tU\r\u0011\"\u0001\u0003\u001a!Q!1D\u001b\u0003\u0012\u0003\u0006I!a\u000f\t\u0015\t=TG!f\u0001\n\u0003\u0011\t\b\u0003\u0006\u0003zU\u0012\t\u0012)A\u0005\u0005gBa\u0001]\u001b\u0005\u0002\tm\u0004b\u0002BBk\u0011\u0005!Q\u0011\u0005\n\u0003C*\u0014\u0011!C\u0001\u0005\u000fC\u0011\"a\u001a6#\u0003%\tA!\r\t\u0013\tUR'%A\u0005\u0002\t5\u0005\"CA@k\u0005\u0005I\u0011IAA\u0011%\t\u0019*NA\u0001\n\u0003\t)\nC\u0005\u0002\u001eV\n\t\u0011\"\u0001\u0003\u0012\"I\u00111V\u001b\u0002\u0002\u0013\u0005\u0013Q\u0016\u0005\n\u0003w+\u0014\u0011!C\u0001\u0005+C\u0011\"a26\u0003\u0003%\tE!'\t\u0013\u00055W'!A\u0005B\u0005=\u0007\"CAik\u0005\u0005I\u0011IAj\u0011%\t).NA\u0001\n\u0003\u0012ijB\u0005\u0003\"\u0006\t\t\u0011#\u0001\u0003$\u001aI!1N\u0001\u0002\u0002#\u0005!Q\u0015\u0005\u0007a&#\tA!+\t\u0013\u0005E\u0017*!A\u0005F\u0005M\u0007\"CA}\u0013\u0006\u0005I\u0011\u0011BV\u0011%\ty0SA\u0001\n\u0003\u0013\t\fC\u0005\u0003\n%\u000b\t\u0011\"\u0003\u0003\f\u0019)\u0001n\u0017\u0001\u0003:\"Q!1X(\u0003\u0002\u0003\u0006IA!0\t\u0015\t%wJ!A!\u0002\u0013\u0011Y\r\u0003\u0006\u0003X>\u0013\t\u0011)A\u0005\u00053D!B!;P\u0005\u0003\u0005\u000b\u0011\u0002Bv\u0011)\u00119p\u0014B\u0001B\u0003%!\u0011 \u0005\u0007a>#\ta!\u0001\t\u000f\r\u0005r\n\"\u0001\u0004$!91\u0011E(\u0005\n\r\u0015\u0004bBB<\u001f\u0012%1\u0011\u0010\u0005\b\u0007_{E\u0011BBY\u0003])U.Y5m'\u0016$8I]3bi\u0016\u0004VM\u001d4pe6,'O\u0003\u0002];\u00061Q.\u001a;i_\u0012T!AX0\u0002\t)l\u0017\r\u001d\u0006\u0003A\u0006\fQA[1nKNT!AY2\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005!\u0017aA8sO\u000e\u0001\u0001CA4\u0002\u001b\u0005Y&aF#nC&d7+\u001a;De\u0016\fG/\u001a)fe\u001a|'/\\3s'\t\t!\u000e\u0005\u0002l]6\tANC\u0001n\u0003\u0015\u00198-\u00197b\u0013\tyGN\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0019\u0014qb\u0011:fCRLwN\u001c*fgVdGo]\n\u0005\u0007)$x\u000f\u0005\u0002lk&\u0011a\u000f\u001c\u0002\b!J|G-^2u!\rA\u0018\u0011\u0001\b\u0003szt!A_?\u000e\u0003mT!\u0001`3\u0002\rq\u0012xn\u001c;?\u0013\u0005i\u0017BA@m\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\u0001\u0002\u0006\ta1+\u001a:jC2L'0\u00192mK*\u0011q\u0010\\\u0001\be\u0016\u001cX\u000f\u001c;t+\t\tY\u0001E\u0003y\u0003\u001b\t\t\"\u0003\u0003\u0002\u0010\u0005\u0015!aA*fcB\u0019\u00111C\u000e\u000e\u0003\u0005\u0011ab\u0011:fCRLwN\u001c*fgVdGo\u0005\u0002\u001cU\u0006A!/Z:vYR\u001c\b\u0005\u0006\u0003\u0002\u001e\u0005}\u0001cAA\n\u0007!9\u0011q\u0001\u0004A\u0002\u0005-\u0011aB2sK\u0006$X\rZ\u000b\u0003\u0003K\u0001Ra[A\u0014\u0003WI1!!\u000bm\u0005\u0019y\u0005\u000f^5p]BA\u0011QFA\u001b\u0003w\t9E\u0004\u0003\u00020\u0005E\u0002C\u0001>m\u0013\r\t\u0019\u0004\\\u0001\u0007!J,G-\u001a4\n\t\u0005]\u0012\u0011\b\u0002\u0004\u001b\u0006\u0004(bAA\u001aYB!\u0011QHA\"\u001b\t\tyDC\u0002\u0002Bu\u000bA!\\1jY&!\u0011QIA \u0005=)U.Y5m\u0007J,\u0017\r^5p]&#\u0007\u0003BA\u001f\u0003\u0013JA!a\u0013\u0002@\t)R)\\1jY\u000e\u0013X-\u0019;j_:\u0014Vm\u001d9p]N,\u0017A\u00038pi\u000e\u0013X-\u0019;fIV\u0011\u0011\u0011\u000b\t\u0006W\u0006\u001d\u00121\u000b\t\t\u0003[\t)$a\u000f\u0002VA!\u0011qKA/\u001b\t\tIFC\u0002\u0002\\u\u000bAaY8sK&!\u0011qLA-\u0005!\u0019V\r^#se>\u0014\u0018\u0001B2paf$B!!\b\u0002f!I\u0011qA\u0005\u0011\u0002\u0003\u0007\u00111B\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\tYG\u000b\u0003\u0002\f\u000554FAA8!\u0011\t\t(a\u001f\u000e\u0005\u0005M$\u0002BA;\u0003o\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005eD.\u0001\u0006b]:|G/\u0019;j_:LA!! \u0002t\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\t\u0019\t\u0005\u0003\u0002\u0006\u0006=UBAAD\u0015\u0011\tI)a#\u0002\t1\fgn\u001a\u0006\u0003\u0003\u001b\u000bAA[1wC&!\u0011\u0011SAD\u0005\u0019\u0019FO]5oO\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011q\u0013\t\u0004W\u0006e\u0015bAANY\n\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011\u0011UAT!\rY\u00171U\u0005\u0004\u0003Kc'aA!os\"I\u0011\u0011V\u0007\u0002\u0002\u0003\u0007\u0011qS\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005=\u0006CBAY\u0003o\u000b\t+\u0004\u0002\u00024*\u0019\u0011Q\u00177\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002:\u0006M&\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!a0\u0002FB\u00191.!1\n\u0007\u0005\rGNA\u0004C_>dW-\u00198\t\u0013\u0005%v\"!AA\u0002\u0005\u0005\u0016A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$B!a!\u0002L\"I\u0011\u0011\u0016\t\u0002\u0002\u0003\u0007\u0011qS\u0001\tQ\u0006\u001c\bnQ8eKR\u0011\u0011qS\u0001\ti>\u001cFO]5oOR\u0011\u00111Q\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005}\u0016\u0011\u001c\u0005\n\u0003S\u001b\u0012\u0011!a\u0001\u0003C\u000bqb\u0011:fCRLwN\u001c*fgVdGo\u001d\t\u0004\u0003')2#B\u000b\u0002b\u00065\b\u0003CAr\u0003S\fY!!\b\u000e\u0005\u0005\u0015(bAAtY\u00069!/\u001e8uS6,\u0017\u0002BAv\u0003K\u0014\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c82!\u0011\ty/!>\u000e\u0005\u0005E(\u0002BAz\u0003\u0017\u000b!![8\n\t\u0005\r\u0011\u0011\u001f\u000b\u0003\u0003;\fQ!\u00199qYf$B!!\b\u0002~\"9\u0011q\u0001\rA\u0002\u0005-\u0011aB;oCB\u0004H.\u001f\u000b\u0005\u0005\u0007\u0011)\u0001E\u0003l\u0003O\tY\u0001C\u0005\u0003\be\t\t\u00111\u0001\u0002\u001e\u0005\u0019\u0001\u0010\n\u0019\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\t5\u0001\u0003BAC\u0005\u001fIAA!\u0005\u0002\b\n1qJ\u00196fGR\u0014qb\u0011:fCRLwN\\*vG\u000e,7o]\n\u00079)\f\t\u0002^<\u0002\u0011\rd\u0017.\u001a8u\u0013\u0012,\"!a\u000f\u0002\u0013\rd\u0017.\u001a8u\u0013\u0012\u0004\u0013\u0001\u0003:fgB|gn]3\u0016\u0005\u0005\u001d\u0013!\u0003:fgB|gn]3!)\u0019\u0011)Ca\n\u0003*A\u0019\u00111\u0003\u000f\t\u000f\t]\u0011\u00051\u0001\u0002<!9!QD\u0011A\u0002\u0005\u001dCC\u0002B\u0013\u0005[\u0011y\u0003C\u0005\u0003\u0018\t\u0002\n\u00111\u0001\u0002<!I!Q\u0004\u0012\u0011\u0002\u0003\u0007\u0011qI\u000b\u0003\u0005gQC!a\u000f\u0002n\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TC\u0001B\u001dU\u0011\t9%!\u001c\u0015\t\u0005\u0005&Q\b\u0005\n\u0003S;\u0013\u0011!a\u0001\u0003/#B!a0\u0003B!I\u0011\u0011V\u0015\u0002\u0002\u0003\u0007\u0011\u0011\u0015\u000b\u0005\u0003\u0007\u0013)\u0005C\u0005\u0002**\n\t\u00111\u0001\u0002\u0018R!\u0011q\u0018B%\u0011%\tI+LA\u0001\u0002\u0004\t\t+A\bDe\u0016\fG/[8o'V\u001c7-Z:t!\r\t\u0019bL\n\u0006_\tE\u0013Q\u001e\t\u000b\u0003G\u0014\u0019&a\u000f\u0002H\t\u0015\u0012\u0002\u0002B+\u0003K\u0014\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c83)\t\u0011i\u0005\u0006\u0004\u0003&\tm#Q\f\u0005\b\u0005/\u0011\u0004\u0019AA\u001e\u0011\u001d\u0011iB\ra\u0001\u0003\u000f\"BA!\u0019\u0003jA)1.a\n\u0003dA91N!\u001a\u0002<\u0005\u001d\u0013b\u0001B4Y\n1A+\u001e9mKJB\u0011Ba\u00024\u0003\u0003\u0005\rA!\n\u0003\u001f\r\u0013X-\u0019;j_:4\u0015-\u001b7ve\u0016\u001cb!\u000e6\u0002\u0012Q<\u0018!A3\u0016\u0005\tM\u0004c\u0001=\u0003v%!!qOA\u0003\u0005%!\u0006N]8xC\ndW-\u0001\u0002fAQ1!Q\u0010B@\u0005\u0003\u00032!a\u00056\u0011\u001d\u00119B\u000fa\u0001\u0003wAqAa\u001c;\u0001\u0004\u0011\u0019(A\tbg6+7o]1hKN+G/\u0012:s_J,\"!!\u0016\u0015\r\tu$\u0011\u0012BF\u0011%\u00119\u0002\u0010I\u0001\u0002\u0004\tY\u0004C\u0005\u0003pq\u0002\n\u00111\u0001\u0003tU\u0011!q\u0012\u0016\u0005\u0005g\ni\u0007\u0006\u0003\u0002\"\nM\u0005\"CAU\u0003\u0006\u0005\t\u0019AAL)\u0011\tyLa&\t\u0013\u0005%6)!AA\u0002\u0005\u0005F\u0003BAB\u00057C\u0011\"!+E\u0003\u0003\u0005\r!a&\u0015\t\u0005}&q\u0014\u0005\n\u0003S;\u0015\u0011!a\u0001\u0003C\u000bqb\u0011:fCRLwN\u001c$bS2,(/\u001a\t\u0004\u0003'I5#B%\u0003(\u00065\bCCAr\u0005'\nYDa\u001d\u0003~Q\u0011!1\u0015\u000b\u0007\u0005{\u0012iKa,\t\u000f\t]A\n1\u0001\u0002<!9!q\u000e'A\u0002\tMD\u0003\u0002BZ\u0005o\u0003Ra[A\u0014\u0005k\u0003ra\u001bB3\u0003w\u0011\u0019\bC\u0005\u0003\b5\u000b\t\u00111\u0001\u0003~M\u0011qJ[\u0001\u000bg\u0016\u0014\u0018.\u00197ju\u0016\u0014\b\u0003\u0002B`\u0005\u000bl!A!1\u000b\u0007\t\rW,\u0001\u0003kg>t\u0017\u0002\u0002Bd\u0005\u0003\u0014!#R7bS2\u001cV\r^*fe&\fG.\u001b>fe\u0006i!\r\\8c%\u0016\u001cx\u000e\u001c<feN\u0004BA!4\u0003T6\u0011!q\u001a\u0006\u0004\u0005#l\u0016A\u0002:pkR,7/\u0003\u0003\u0003V\n='!\u0004\"m_\n\u0014Vm]8mm\u0016\u00148/A\tii6dG+\u001a=u\u000bb$(/Y2u_J\u0004BAa7\u0003f6\u0011!Q\u001c\u0006\u0005\u0005?\u0014\t/\u0001\u0003ii6d'b\u0001Br?\u0006!Q\u000f^5m\u0013\u0011\u00119O!8\u0003#!#X\u000e\u001c+fqR,\u0005\u0010\u001e:bGR|'/\u0001\bnC&d'm\u001c=NC:\fw-\u001a:\u0011\t\t5(1_\u0007\u0003\u0005_T1A!=`\u0003\u001di\u0017-\u001b7c_bLAA!>\u0003p\nqQ*Y5mE>DX*\u00198bO\u0016\u0014\u0018!D2p]\u001aLw-\u001e:bi&|g\u000e\u0005\u0003\u0003|\nuX\"A/\n\u0007\t}XLA\tK\u001b\u0006\u00036i\u001c8gS\u001e,(/\u0019;j_:$Bba\u0001\u0004\u0006\r\u001d1\u0011BB\u0006\u0007\u001b\u0001\"aZ(\t\u000f\tmV\u000b1\u0001\u0003>\"9!\u0011Z+A\u0002\t-\u0007b\u0002Bl+\u0002\u0007!\u0011\u001c\u0005\b\u0005S,\u0006\u0019\u0001Bv\u0011\u001d\u001190\u0016a\u0001\u0005sD3!VB\t!\u0011\u0019\u0019b!\b\u000e\u0005\rU!\u0002BB\f\u00073\ta!\u001b8kK\u000e$(BAB\u000e\u0003\u0015Q\u0017M^1y\u0013\u0011\u0019yb!\u0006\u0003\r%s'.Z2u\u0003\u0019\u0019'/Z1uKR11QEB)\u00077\u0002baa\n\u00046\reRBAB\u0015\u0015\u0011\u0019Yc!\f\u0002\u0013A,(\r\\5tQ\u0016\u0014(bA7\u00040)!\u00111LB\u0019\u0015\t\u0019\u0019$A\u0004sK\u0006\u001cGo\u001c:\n\t\r]2\u0011\u0006\u0002\u0006'6{gn\u001c\t\u0004\u0007w\u0019abAB\u001f\u00019!1qHB(\u001d\u0011\u0019\te!\u0014\u000f\t\r\r31\n\b\u0005\u0007\u000b\u001aIED\u0002{\u0007\u000fJ\u0011\u0001Z\u0005\u0003E\u000eL!\u0001Y1\n\u0005y{\u0016B\u0001/^\u0011\u001d\u0019\u0019F\u0016a\u0001\u0007+\nqA]3rk\u0016\u001cH\u000f\u0005\u0003\u0002>\r]\u0013\u0002BB-\u0003\u007f\u0011q\"R7bS2\u001cV\r\u001e*fcV,7\u000f\u001e\u0005\b\u0007;2\u0006\u0019AB0\u00039i\u0017-\u001b7c_b\u001cVm]:j_:\u0004BA!<\u0004b%!11\rBx\u00059i\u0015-\u001b7c_b\u001cVm]:j_:$\u0002ba\u001a\u0004l\r54Q\u000f\t\u0007\u0007O\u0019)d!\u001b\u0011\u0007\rm2\u0004C\u0004\u0003\u0018]\u0003\r!a\u000f\t\u000f\rMs\u000b1\u0001\u0004pA!\u0011QHB9\u0013\u0011\u0019\u0019(a\u0010\u0003)\u0015k\u0017-\u001b7De\u0016\fG/[8o%\u0016\fX/Z:u\u0011\u001d\u0019if\u0016a\u0001\u0007?\na!\u00199qK:$GCCB>\u0007\u007f\u001a\tia&\u0004\u001aB11qEB\u001b\u0007{\u00022aa\u000f\u001d\u0011\u001d\u00119\u0002\u0017a\u0001\u0003wAqaa!Y\u0001\u0004\u0019))A\u0007baB,g\u000eZ\"p[6\fg\u000e\u001a\t\u0005\u0007\u000f\u001b\tJ\u0004\u0003\u0004\n\u000e5e\u0002BB!\u0007\u0017K1A!=`\u0013\u0011\u0019yIa<\u0002\u001d5+7o]1hK6\u000bg.Y4fe&!11SBK\u00055\t\u0005\u000f]3oI\u000e{W.\\1oI*!1q\u0012Bx\u0011\u001d\u0019i\u0006\u0017a\u0001\u0007?Bqaa'Y\u0001\u0004\u0019i*\u0001\u0006nC&d'm\u001c=JIN\u0004R\u0001_BP\u0007GKAa!)\u0002\u0006\t!A*[:u!\u0011\u0019)ka+\u000e\u0005\r\u001d&\u0002BBU\u0005_\fQ!\\8eK2LAa!,\u0004(\nIQ*Y5mE>D\u0018\nZ\u0001\u0010CN\f\u0005\u000f]3oI\u000e{W.\\1oIR111WB`\u0007\u0003\u0004r\u0001_B[\u0007s\u001b))\u0003\u0003\u00048\u0006\u0015!AB#ji\",'\u000fE\u0002y\u0007wKAa!0\u0002\u0006\tA\u0012\n\u001c7fO\u0006d\u0017I]4v[\u0016tG/\u0012=dKB$\u0018n\u001c8\t\u000f\rM\u0013\f1\u0001\u0004p!911Y-A\u0002\r\u0015\u0017aB7fgN\fw-\u001a\t\u0005\u0007\u000f\u001c\t.\u0004\u0002\u0004J*!11ZBg\u0003\r!w.\u001c\u0006\u0004\u0007\u001f|\u0016AB7j[\u0016$$.\u0003\u0003\u0004T\u000e%'aB'fgN\fw-\u001a")
public class EmailSetCreatePerformer {
    private final EmailSetSerializer serializer;
    private final BlobResolvers blobResolvers;
    private final HtmlTextExtractor htmlTextExtractor;
    private final MailboxManager mailboxManager;
    private final JMAPConfiguration configuration;

    public SMono<CreationResults> create(EmailSetRequest request, MailboxSession mailboxSession) {
        SFlux qual$1 = SFlux$.MODULE$.fromIterable((Iterable)request.create().getOrElse((Function0 & Serializable)() -> (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)));
        Function1 & Serializable x$1 = (Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            EmailCreationId clientId = (EmailCreationId)tuple2._1();
            JsObject json = (JsObject)tuple2._2();
            SMono sMono = (SMono)$this.serializer.deserializeCreationRequest((JsValue)json).fold((Function1 & Serializable)e -> SMono$.MODULE$.just((Object)new CreationFailure(clientId, new IllegalArgumentException(e.toString()))), (Function1 & Serializable)creationRequest -> this.create(clientId, (EmailCreationRequest)creationRequest, mailboxSession));
            return sMono;
        };
        int x$2 = qual$1.concatMap$default$2();
        return qual$1.concatMap((Function1)x$1, x$2).collectSeq().map((Function1)EmailSetCreatePerformer$CreationResults$.MODULE$);
    }

    private SMono<CreationResult> create(EmailCreationId clientId, EmailCreationRequest request, MailboxSession mailboxSession) {
        List<MailboxId> mailboxIds = request.mailboxIds().value();
        return mailboxIds.size() != 1 ? SMono$.MODULE$.just((Object)new CreationFailure(clientId, new IllegalArgumentException("mailboxIds need to have size 1"))) : SMono$.MODULE$.fromCallable(() -> request.toMime4JMessage($this.blobResolvers, $this.htmlTextExtractor, mailboxSession)).flatMap((Function1 & Serializable)either -> (SMono)either.fold((Function1 & Serializable)e -> SMono$.MODULE$.just((Object)new CreationFailure(clientId, (Throwable)e)), (Function1 & Serializable)message -> (SMono)this.asAppendCommand(request, (Message)message).fold((Function1 & Serializable)e -> SMono$.MODULE$.error((Throwable)e), (Function1 & Serializable)appendCommand -> this.append(clientId, (MessageManager.AppendCommand)appendCommand, mailboxSession, mailboxIds)))).onErrorResume((Function1 & Serializable)e -> SMono$.MODULE$.just((Object)new CreationFailure(clientId, (Throwable)e))).subscribeOn(Schedulers.elastic());
    }

    private SMono<CreationSuccess> append(EmailCreationId clientId, MessageManager.AppendCommand appendCommand, MailboxSession mailboxSession, List<MailboxId> mailboxIds) {
        return SMono$.MODULE$.apply(this.mailboxManager.getMailboxReactive((MailboxId)mailboxIds.head(), mailboxSession)).flatMap((Function1 & Serializable)mailbox -> SMono$.MODULE$.apply(mailbox.appendMessageReactive(appendCommand, mailboxSession)).map((Function1 & Serializable)appendResult -> {
            Option blobId = BlobId$.MODULE$.of(appendResult.getId().getMessageId()).toOption();
            String threadId = ThreadId$.MODULE$.fromJava(appendResult.getThreadId());
            return new CreationSuccess(clientId, new EmailCreationResponse(appendResult.getId().getMessageId(), blobId, threadId, Size$.MODULE$.sanitizeSize(Predef$.MODULE$.Long2long(appendResult.getSize()))));
        }));
    }

    private Either<IllegalArgumentException, MessageManager.AppendCommand> asAppendCommand(EmailCreationRequest request, Message message) {
        return package$.MODULE$.Right().apply((Object)MessageManager.AppendCommand.builder().recent().withFlags((Flags)request.keywords().map((Function1 & Serializable)x$3 -> x$3.asFlags()).getOrElse((Function0 & Serializable)() -> new Flags())).withInternalDate(Date.from(((UTCDate)request.receivedAt().getOrElse((Function0 & Serializable)() -> new UTCDate(ZonedDateTime.now()))).asUTC().toInstant())).build(message)).flatMap((Function1 & Serializable)appendCommand -> (Either)OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional($this.configuration.getMaximumSendSize())).filter((Function1 & Serializable)limit -> BoxesRunTime.boxToBoolean((boolean)EmailSetCreatePerformer.$anonfun$asAppendCommand$5(appendCommand, limit))).map((Function1 & Serializable)limit -> package$.MODULE$.Left().apply((Object)new SizeExceededException(appendCommand.getMsgIn().size(), Predef$.MODULE$.Long2long(limit)))).getOrElse((Function0 & Serializable)() -> package$.MODULE$.Right().apply(appendCommand)));
    }

    public static final /* synthetic */ boolean $anonfun$asAppendCommand$5(MessageManager.AppendCommand appendCommand$2, Long limit) {
        return appendCommand$2.getMsgIn().size() > Predef$.MODULE$.Long2long(limit);
    }

    @Inject
    public EmailSetCreatePerformer(EmailSetSerializer serializer, BlobResolvers blobResolvers, HtmlTextExtractor htmlTextExtractor, MailboxManager mailboxManager, JMAPConfiguration configuration) {
        this.serializer = serializer;
        this.blobResolvers = blobResolvers;
        this.htmlTextExtractor = htmlTextExtractor;
        this.mailboxManager = mailboxManager;
        this.configuration = configuration;
    }

    public static class CreationFailure
    implements CreationResult,
    Product,
    Serializable {
        private final EmailCreationId clientId;
        private final Throwable e;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public EmailCreationId clientId() {
            return this.clientId;
        }

        public Throwable e() {
            return this.e;
        }

        public SetError asMessageSetError() {
            SetError setError;
            Throwable throwable = this.e();
            if (throwable instanceof MailboxNotFoundException) {
                MailboxNotFoundException mailboxNotFoundException = (MailboxNotFoundException)throwable;
                setError = SetError$.MODULE$.notFound(new StringBuilder(8).append("Mailbox ").append(mailboxNotFoundException.getMessage()).toString());
            } else if (throwable instanceof BlobNotFoundException) {
                BlobNotFoundException blobNotFoundException = (BlobNotFoundException)throwable;
                setError = SetError$.MODULE$.invalidArguments(new StringBuilder(22).append("Attachment not found: ").append(new Refined((Object)blobNotFoundException.blobId().value())).toString(), (Option<Properties>)new Some((Object)Properties$.MODULE$.apply((Seq<Refined<String, boolean.Not<collection.Empty>>>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Refined[]{new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"attachments")).value()))}))));
            } else if (throwable instanceof IllegalArgumentException) {
                IllegalArgumentException illegalArgumentException = (IllegalArgumentException)throwable;
                setError = SetError$.MODULE$.invalidArguments(illegalArgumentException.getMessage(), SetError$.MODULE$.invalidArguments$default$2());
            } else if (throwable instanceof OverQuotaException) {
                OverQuotaException overQuotaException = (OverQuotaException)throwable;
                setError = SetError$.MODULE$.overQuota(overQuotaException.getMessage());
            } else {
                setError = SetError$.MODULE$.serverFail(this.e().getMessage());
            }
            return setError;
        }

        public CreationFailure copy(EmailCreationId clientId, Throwable e) {
            return new CreationFailure(clientId, e);
        }

        public EmailCreationId copy$default$1() {
            return this.clientId();
        }

        public Throwable copy$default$2() {
            return this.e();
        }

        public String productPrefix() {
            return "CreationFailure";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.clientId();
                    break;
                }
                case 1: {
                    object = this.e();
                    break;
                }
                default: {
                    object = Statics.ioobe((int)x$1);
                    break;
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof CreationFailure;
        }

        public String productElementName(int x$1) {
            String string2;
            int n = x$1;
            switch (n) {
                case 0: {
                    string2 = "clientId";
                    break;
                }
                case 1: {
                    string2 = "e";
                    break;
                }
                default: {
                    string2 = (String)Statics.ioobe((int)x$1);
                    break;
                }
            }
            return string2;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof CreationFailure)) return false;
            boolean bl = true;
            if (!bl) return false;
            CreationFailure creationFailure = (CreationFailure)x$1;
            EmailCreationId emailCreationId = this.clientId();
            EmailCreationId emailCreationId2 = creationFailure.clientId();
            if (emailCreationId == null) {
                if (emailCreationId2 != null) {
                    return false;
                }
            } else if (!((Object)emailCreationId).equals(emailCreationId2)) return false;
            Throwable throwable = this.e();
            Throwable throwable2 = creationFailure.e();
            if (throwable == null) {
                if (throwable2 != null) {
                    return false;
                }
            } else if (!throwable.equals(throwable2)) return false;
            if (!creationFailure.canEqual(this)) return false;
            return true;
        }

        public CreationFailure(EmailCreationId clientId, Throwable e) {
            this.clientId = clientId;
            this.e = e;
            Product.$init$((Product)this);
        }
    }

    public static interface CreationResult {
    }

    public static class CreationResults
    implements Product,
    Serializable {
        private final Seq<CreationResult> results;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public Seq<CreationResult> results() {
            return this.results;
        }

        public Option<Map<EmailCreationId, EmailCreationResponse>> created() {
            return Option$.MODULE$.apply((Object)((IterableOnceOps)this.results().flatMap((Function1 & Serializable)x0$1 -> {
                None$ none$;
                CreationResult creationResult = x0$1;
                if (creationResult instanceof CreationSuccess) {
                    CreationSuccess creationSuccess = (CreationSuccess)creationResult;
                    none$ = new Some((Object)new Tuple2((Object)creationSuccess.clientId(), (Object)creationSuccess.response()));
                } else {
                    none$ = None$.MODULE$;
                }
                return none$;
            })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.nonEmpty()));
        }

        public Option<Map<EmailCreationId, SetError>> notCreated() {
            return Option$.MODULE$.apply((Object)((IterableOnceOps)this.results().flatMap((Function1 & Serializable)x0$1 -> {
                None$ none$;
                CreationResult creationResult = x0$1;
                if (creationResult instanceof CreationFailure) {
                    CreationFailure creationFailure = (CreationFailure)creationResult;
                    none$ = new Some((Object)new Tuple2((Object)creationFailure.clientId(), (Object)creationFailure.asMessageSetError()));
                } else {
                    none$ = None$.MODULE$;
                }
                return none$;
            })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.nonEmpty()));
        }

        public CreationResults copy(Seq<CreationResult> results) {
            return new CreationResults(results);
        }

        public Seq<CreationResult> copy$default$1() {
            return this.results();
        }

        public String productPrefix() {
            return "CreationResults";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.results();
                    break;
                }
                default: {
                    object = Statics.ioobe((int)x$1);
                    break;
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof CreationResults;
        }

        public String productElementName(int x$1) {
            String string2;
            int n = x$1;
            switch (n) {
                case 0: {
                    string2 = "results";
                    break;
                }
                default: {
                    string2 = (String)Statics.ioobe((int)x$1);
                    break;
                }
            }
            return string2;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof CreationResults)) return false;
            boolean bl = true;
            if (!bl) return false;
            CreationResults creationResults = (CreationResults)x$1;
            Seq<CreationResult> seq = this.results();
            Seq<CreationResult> seq2 = creationResults.results();
            if (seq == null) {
                if (seq2 != null) {
                    return false;
                }
            } else if (!seq.equals(seq2)) return false;
            if (!creationResults.canEqual(this)) return false;
            return true;
        }

        public CreationResults(Seq<CreationResult> results) {
            this.results = results;
            Product.$init$((Product)this);
        }
    }

    public static class CreationSuccess
    implements CreationResult,
    Product,
    Serializable {
        private final EmailCreationId clientId;
        private final EmailCreationResponse response;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public EmailCreationId clientId() {
            return this.clientId;
        }

        public EmailCreationResponse response() {
            return this.response;
        }

        public CreationSuccess copy(EmailCreationId clientId, EmailCreationResponse response) {
            return new CreationSuccess(clientId, response);
        }

        public EmailCreationId copy$default$1() {
            return this.clientId();
        }

        public EmailCreationResponse copy$default$2() {
            return this.response();
        }

        public String productPrefix() {
            return "CreationSuccess";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.clientId();
                    break;
                }
                case 1: {
                    object = this.response();
                    break;
                }
                default: {
                    object = Statics.ioobe((int)x$1);
                    break;
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof CreationSuccess;
        }

        public String productElementName(int x$1) {
            String string2;
            int n = x$1;
            switch (n) {
                case 0: {
                    string2 = "clientId";
                    break;
                }
                case 1: {
                    string2 = "response";
                    break;
                }
                default: {
                    string2 = (String)Statics.ioobe((int)x$1);
                    break;
                }
            }
            return string2;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof CreationSuccess)) return false;
            boolean bl = true;
            if (!bl) return false;
            CreationSuccess creationSuccess = (CreationSuccess)x$1;
            EmailCreationId emailCreationId = this.clientId();
            EmailCreationId emailCreationId2 = creationSuccess.clientId();
            if (emailCreationId == null) {
                if (emailCreationId2 != null) {
                    return false;
                }
            } else if (!((Object)emailCreationId).equals(emailCreationId2)) return false;
            EmailCreationResponse emailCreationResponse = this.response();
            EmailCreationResponse emailCreationResponse2 = creationSuccess.response();
            if (emailCreationResponse == null) {
                if (emailCreationResponse2 != null) {
                    return false;
                }
            } else if (!((Object)emailCreationResponse).equals(emailCreationResponse2)) return false;
            if (!creationSuccess.canEqual(this)) return false;
            return true;
        }

        public CreationSuccess(EmailCreationId clientId, EmailCreationResponse response) {
            this.clientId = clientId;
            this.response = response;
            Product.$init$((Product)this);
        }
    }
}

