/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.task.eventsourcing;

import java.io.Serializable;
import org.apache.james.eventsourcing.Event;
import org.apache.james.eventsourcing.EventId;
import org.apache.james.eventsourcing.eventstore.History;
import org.apache.james.task.Hostname;
import org.apache.james.task.Task;
import org.apache.james.task.TaskExecutionDetails;
import org.apache.james.task.TaskManager;
import org.apache.james.task.eventsourcing.AdditionalInformationUpdated;
import org.apache.james.task.eventsourcing.CancelRequested;
import org.apache.james.task.eventsourcing.Cancelled;
import org.apache.james.task.eventsourcing.Completed;
import org.apache.james.task.eventsourcing.Created;
import org.apache.james.task.eventsourcing.DecisionProjection;
import org.apache.james.task.eventsourcing.DecisionProjection$;
import org.apache.james.task.eventsourcing.Failed;
import org.apache.james.task.eventsourcing.Started;
import org.apache.james.task.eventsourcing.TaskAggregate$;
import org.apache.james.task.eventsourcing.TaskAggregateId;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.LinearSeqOps;
import scala.collection.immutable.List;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005ud\u0001\u0002\r\u001a\u0001\u0011B\u0001b\u000b\u0001\u0003\u0006\u0004%\t\u0001\f\u0005\tc\u0001\u0011\t\u0011)A\u0005[!A!\u0007\u0001BC\u0002\u0013%1\u0007\u0003\u0005<\u0001\t\u0005\t\u0015!\u00035\u0011\u0015a\u0004\u0001\"\u0003>\u0011\u001d\t\u0005A1A\u0005\u0002\tCaA\u0012\u0001!\u0002\u0013\u0019\u0005bB$\u0001\u0005\u0004%I\u0001\u0013\u0005\u0007\u0019\u0002\u0001\u000b\u0011B%\t\u000b5\u0003A\u0011\u0002(\t\u000by\u0003A\u0011B0\t\u000b\u0005\u0004A\u0011\u00022\t\rA\u0004A\u0011A\rr\u0011\u0019A\b\u0001\"\u0001\u001as\"11\u0010\u0001C\u00013qD\u0001\"!\b\u0001\t\u0003I\u0012q\u0004\u0005\t\u0003o\u0001A\u0011A\r\u0002:!A\u0011q\u000b\u0001\u0005\u0002e\tIfB\u0004\u0002^eA\t!a\u0018\u0007\raI\u0002\u0012AA1\u0011\u0019aD\u0003\"\u0001\u0002d!9\u0011Q\r\u000b\u0005\u0002\u0005\u001d\u0004bBA7)\u0011\u0005\u0011q\u000e\u0002\u000e)\u0006\u001c8.Q4he\u0016<\u0017\r^3\u000b\u0005iY\u0012!D3wK:$8o\\;sG&twM\u0003\u0002\u001d;\u0005!A/Y:l\u0015\tqr$A\u0003kC6,7O\u0003\u0002!C\u00051\u0011\r]1dQ\u0016T\u0011AI\u0001\u0004_J<7\u0001A\n\u0003\u0001\u0015\u0002\"AJ\u0015\u000e\u0003\u001dR\u0011\u0001K\u0001\u0006g\u000e\fG.Y\u0005\u0003U\u001d\u0012a!\u00118z%\u00164\u0017aC1hOJ,w-\u0019;f\u0013\u0012,\u0012!\f\t\u0003]=j\u0011!G\u0005\u0003ae\u0011q\u0002V1tW\u0006;wM]3hCR,\u0017\nZ\u0001\rC\u001e<'/Z4bi\u0016LE\rI\u0001\bQ&\u001cHo\u001c:z+\u0005!\u0004CA\u001b:\u001b\u00051$BA\u001c9\u0003))g/\u001a8ugR|'/\u001a\u0006\u00035uI!A\u000f\u001c\u0003\u000f!K7\u000f^8ss\u0006A\u0001.[:u_JL\b%\u0001\u0004=S:LGO\u0010\u000b\u0004}}\u0002\u0005C\u0001\u0018\u0001\u0011\u0015YS\u00011\u0001.\u0011\u0015\u0011T\u00011\u00015\u00031Ig.\u001b;jC2,e/\u001a8u+\u0005\u0019\u0005C\u0001\u0018E\u0013\t)\u0015DA\u0004De\u0016\fG/\u001a3\u0002\u001b%t\u0017\u000e^5bY\u00163XM\u001c;!\u0003e\u0019WO\u001d:f]R$UmY5tS>t\u0007K]8kK\u000e$\u0018n\u001c8\u0016\u0003%\u0003\"A\f&\n\u0005-K\"A\u0005#fG&\u001c\u0018n\u001c8Qe>TWm\u0019;j_:\f!dY;se\u0016tG\u000fR3dSNLwN\u001c)s_*,7\r^5p]\u0002\n\u0001d\u0019:fCR,WI^3oi&3gj\u001c;GS:L7\u000f[3e)\tye\u000bE\u0002'!JK!!U\u0014\u0003\r=\u0003H/[8o!\t\u0019F+D\u00019\u0013\t)\u0006HA\u0003Fm\u0016tG\u000fC\u0003X\u0015\u0001\u0007\u0001,A\u0003fm\u0016tG\u000f\u0005\u0003'3n\u0013\u0016B\u0001.(\u0005%1UO\\2uS>t\u0017\u0007\u0005\u0002T9&\u0011Q\f\u000f\u0002\b\u000bZ,g\u000e^%e\u0003-\u0019'/Z1uK\u00163XM\u001c;\u0015\u0005=\u0003\u0007\"B,\f\u0001\u0004A\u0016AH2sK\u0006$X-\u0012<f]RLeMT8u\r&t\u0017n\u001d5fI\u0006\u001bH*[:u)\t\u0019w\u000eE\u0002eYJs!!\u001a6\u000f\u0005\u0019LW\"A4\u000b\u0005!\u001c\u0013A\u0002\u001fs_>$h(C\u0001)\u0013\tYw%A\u0004qC\u000e\\\u0017mZ3\n\u00055t'\u0001\u0002'jgRT!a[\u0014\t\u000b]c\u0001\u0019\u0001-\u0002\u000bM$\u0018M\u001d;\u0015\u0005\r\u0014\b\"B:\u000e\u0001\u0004!\u0018\u0001\u00035pgRt\u0017-\\3\u0011\u0005U4X\"A\u000e\n\u0005]\\\"\u0001\u0003%pgRt\u0017-\\3\u0002\u001bI,\u0017/^3ti\u000e\u000bgnY3m)\t\u0019'\u0010C\u0003t\u001d\u0001\u0007A/\u0001\u0004va\u0012\fG/\u001a\u000b\u0003GvDQA`\bA\u0002}\fQ#\u00193eSRLwN\\1m\u0013:4wN]7bi&|g\u000e\u0005\u0003\u0002\u0002\u0005]a\u0002BA\u0002\u0003'qA!!\u0002\u0002\u00129!\u0011qAA\b\u001d\u0011\tI!!\u0004\u000f\u0007\u0019\fY!C\u0001#\u0013\t\u0001\u0013%\u0003\u0002\u001f?%\u0011A$H\u0005\u0004\u0003+Y\u0012\u0001\u0006+bg.,\u00050Z2vi&|g\u000eR3uC&d7/\u0003\u0003\u0002\u001a\u0005m!!F!eI&$\u0018n\u001c8bY&sgm\u001c:nCRLwN\u001c\u0006\u0004\u0003+Y\u0012\u0001C2p[BdW\r^3\u0015\u000b\r\f\t#a\r\t\u000f\u0005\r\u0002\u00031\u0001\u0002&\u00051!/Z:vYR\u0004B!a\n\u0002.9!\u00111AA\u0015\u0013\r\tYcG\u0001\u0005)\u0006\u001c8.\u0003\u0003\u00020\u0005E\"A\u0002*fgVdGOC\u0002\u0002,mAaA \tA\u0002\u0005U\u0002c\u0001\u0014Q\u007f\u0006!a-Y5m)\u001d\u0019\u00171HA\u001f\u0003'BaA`\tA\u0002\u0005U\u0002bBA #\u0001\u0007\u0011\u0011I\u0001\rKJ\u0014xN]'fgN\fw-\u001a\t\u0005MA\u000b\u0019\u0005\u0005\u0003\u0002F\u00055c\u0002BA$\u0003\u0013\u0002\"AZ\u0014\n\u0007\u0005-s%\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u001f\n\tF\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003\u0017:\u0003bBA+#\u0001\u0007\u0011\u0011I\u0001\nKb\u001cW\r\u001d;j_:\faaY1oG\u0016dGcA2\u0002\\!1aP\u0005a\u0001\u0003k\tQ\u0002V1tW\u0006;wM]3hCR,\u0007C\u0001\u0018\u0015'\t!R\u0005\u0006\u0002\u0002`\u0005YaM]8n\u0011&\u001cHo\u001c:z)\u0015q\u0014\u0011NA6\u0011\u0015Yc\u00031\u0001.\u0011\u0015\u0011d\u00031\u00015\u0003\u0019\u0019'/Z1uKR91-!\u001d\u0002t\u0005m\u0004\"B\u0016\u0018\u0001\u0004i\u0003B\u0002\u000f\u0018\u0001\u0004\t)\bE\u0002v\u0003oJ1!!\u001f\u001c\u0005\u0011!\u0016m]6\t\u000bM<\u0002\u0019\u0001;")
public class TaskAggregate {
    private final TaskAggregateId aggregateId;
    private final History history;
    private final Created initialEvent;
    private final DecisionProjection currentDecisionProjection;

    public static List<Event> create(TaskAggregateId aggregateId, Task task, Hostname hostname) {
        return TaskAggregate$.MODULE$.create(aggregateId, task, hostname);
    }

    public static TaskAggregate fromHistory(TaskAggregateId aggregateId, History history) {
        return TaskAggregate$.MODULE$.fromHistory(aggregateId, history);
    }

    public TaskAggregateId aggregateId() {
        return this.aggregateId;
    }

    private History history() {
        return this.history;
    }

    public Created initialEvent() {
        return this.initialEvent;
    }

    private DecisionProjection currentDecisionProjection() {
        return this.currentDecisionProjection;
    }

    private Option<Event> createEventIfNotFinished(Function1<EventId, Event> event) {
        return !this.currentDecisionProjection().status().isFinished() ? new Some(event.apply((Object)this.history().getNextEventId())) : None$.MODULE$;
    }

    private Option<Event> createEvent(Function1<EventId, Event> event) {
        return new Some(event.apply((Object)this.history().getNextEventId()));
    }

    private List<Event> createEventIfNotFinishedAsList(Function1<EventId, Event> event) {
        return this.createEventIfNotFinished(event).toList();
    }

    public List<Event> start(Hostname hostname) {
        return this.createEventIfNotFinished((Function1<EventId, Event>)(Function1 & Serializable)x$1 -> new Started(this.aggregateId(), (EventId)x$1, hostname)).toList();
    }

    public List<Event> requestCancel(Hostname hostname) {
        return this.createEventIfNotFinishedAsList((Function1<EventId, Event>)(Function1 & Serializable)x$2 -> new CancelRequested(this.aggregateId(), (EventId)x$2, hostname));
    }

    public List<Event> update(TaskExecutionDetails.AdditionalInformation additionalInformation) {
        TaskManager.Status status = this.currentDecisionProjection().status();
        Option<Event> option = TaskManager.Status.IN_PROGRESS.equals(status) && this.currentDecisionProjection().additionalInformationIsOlderThan(additionalInformation.timestamp()) ? this.createEvent((Function1<EventId, Event>)(Function1 & Serializable)x$3 -> new AdditionalInformationUpdated(this.aggregateId(), (EventId)x$3, additionalInformation)) : (TaskManager.Status.CANCEL_REQUESTED.equals(status) && this.currentDecisionProjection().additionalInformationIsOlderThan(additionalInformation.timestamp()) ? this.createEvent((Function1<EventId, Event>)(Function1 & Serializable)x$4 -> new AdditionalInformationUpdated(this.aggregateId(), (EventId)x$4, additionalInformation)) : None$.MODULE$);
        return option.toList();
    }

    public List<Event> complete(Task.Result result, Option<TaskExecutionDetails.AdditionalInformation> additionalInformation) {
        return this.createEventIfNotFinishedAsList((Function1<EventId, Event>)(Function1 & Serializable)x$5 -> new Completed(this.aggregateId(), (EventId)x$5, result, additionalInformation));
    }

    public List<Event> fail(Option<TaskExecutionDetails.AdditionalInformation> additionalInformation, Option<String> errorMessage, Option<String> exception) {
        return this.createEventIfNotFinishedAsList((Function1<EventId, Event>)(Function1 & Serializable)x$6 -> new Failed(this.aggregateId(), (EventId)x$6, additionalInformation, errorMessage, exception));
    }

    public List<Event> cancel(Option<TaskExecutionDetails.AdditionalInformation> additionalInformation) {
        return this.createEventIfNotFinishedAsList((Function1<EventId, Event>)(Function1 & Serializable)x$7 -> new Cancelled(this.aggregateId(), (EventId)x$7, additionalInformation));
    }

    public TaskAggregate(TaskAggregateId aggregateId, History history) {
        Created created;
        Some some;
        Event created2;
        this.aggregateId = aggregateId;
        this.history = history;
        Option option = history.getEvents().headOption();
        if (!(option instanceof Some) || !((created2 = (Event)(some = (Some)option).value()) instanceof Created)) {
            throw new IllegalArgumentException("History must start with Created event");
        }
        Created created3 = created = (Created)created2;
        this.initialEvent = created3;
        this.currentDecisionProjection = (DecisionProjection)((LinearSeqOps)history.getEvents().tail()).foldLeft((Object)DecisionProjection$.MODULE$.initial(this.initialEvent()), (Function2 & Serializable)(decision, event) -> decision.update((Event)event));
    }
}

