/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imapserver.netty;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Optional;
import org.apache.james.core.Username;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.util.MDCBuilder;
import org.jboss.netty.channel.ChannelHandlerContext;

public class IMAPMDCContext {
    public static MDCBuilder boundMDC(ChannelHandlerContext ctx) {
        return MDCBuilder.create().addToContext("protocol", "IMAP").addToContext("ip", IMAPMDCContext.retrieveIp(ctx)).addToContext("host", IMAPMDCContext.retrieveHost(ctx));
    }

    private static String retrieveIp(ChannelHandlerContext ctx) {
        SocketAddress remoteAddress = ctx.getChannel().getRemoteAddress();
        if (remoteAddress instanceof InetSocketAddress) {
            InetSocketAddress address = (InetSocketAddress)remoteAddress;
            return address.getAddress().getHostAddress();
        }
        return remoteAddress.toString();
    }

    private static String retrieveHost(ChannelHandlerContext ctx) {
        SocketAddress remoteAddress = ctx.getChannel().getRemoteAddress();
        if (remoteAddress instanceof InetSocketAddress) {
            InetSocketAddress address = (InetSocketAddress)remoteAddress;
            return address.getHostName();
        }
        return remoteAddress.toString();
    }

    public static MDCBuilder from(ImapSession imapSession) {
        return MDCBuilder.create().addToContext("sessionId", imapSession.sessionId().asString()).addToContext("user", Optional.ofNullable(imapSession.getUserName()).map(Username::asString).orElse("")).addToContextIfPresent("selectedMailbox", Optional.ofNullable(imapSession.getSelected()).map(selectedMailbox -> selectedMailbox.getMailboxId().serialize()));
    }
}

