/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mailet;

import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.james.core.MailAddress;
import org.apache.james.core.MaybeSender;
import org.apache.mailet.Attribute;
import org.apache.mailet.AttributeName;
import org.apache.mailet.DsnParameters;
import org.apache.mailet.PerRecipientHeaders;

public interface Mail
extends Serializable,
Cloneable {
    public static final String GHOST = "ghost";
    public static final String DEFAULT = "root";
    public static final String ERROR = "error";
    public static final String TRANSPORT = "transport";
    public static final String LOCAL_DELIVERY = "local-delivery";
    public static final AttributeName SMTP_AUTH_USER = AttributeName.of("org.apache.james.SMTPAuthUser");
    public static final AttributeName MAILET_ERROR = AttributeName.of("org.apache.james.MailetError");
    public static final Attribute SENT_BY_MAILET_ATTRIBUTE = Attribute.convertToAttribute("org.apache.james.SentByMailet", true);
    @Deprecated
    public static final String SMTP_AUTH_USER_ATTRIBUTE_NAME = SMTP_AUTH_USER.asString();
    @Deprecated
    public static final String MAILET_ERROR_ATTRIBUTE_NAME = MAILET_ERROR.asString();
    @Deprecated
    public static final String SENT_BY_MAILET = SENT_BY_MAILET_ATTRIBUTE.getName().asString();

    public String getName();

    public void setName(String var1);

    public MimeMessage getMessage() throws MessagingException;

    public Collection<MailAddress> getRecipients();

    public void setRecipients(Collection<MailAddress> var1);

    @Deprecated
    public MailAddress getSender();

    default public MaybeSender getMaybeSender() {
        return MaybeSender.of((MailAddress)this.getSender());
    }

    default public boolean hasSender() {
        return !this.getMaybeSender().isNullSender();
    }

    public Mail duplicate() throws MessagingException;

    public String getState();

    public String getRemoteHost();

    public String getRemoteAddr();

    public String getErrorMessage();

    public void setErrorMessage(String var1);

    public void setMessage(MimeMessage var1) throws MessagingException;

    public void setState(String var1);

    public Stream<Attribute> attributes();

    @Deprecated
    public Serializable getAttribute(String var1);

    public Optional<Attribute> getAttribute(AttributeName var1);

    @Deprecated
    public Iterator<String> getAttributeNames();

    public Stream<AttributeName> attributeNames();

    public boolean hasAttributes();

    @Deprecated
    public Serializable removeAttribute(String var1);

    public Optional<Attribute> removeAttribute(AttributeName var1);

    public void removeAllAttributes();

    @Deprecated
    public Serializable setAttribute(String var1, Serializable var2);

    public Optional<Attribute> setAttribute(Attribute var1);

    public void addSpecificHeaderForRecipient(PerRecipientHeaders.Header var1, MailAddress var2);

    public PerRecipientHeaders getPerRecipientSpecificHeaders();

    public long getMessageSize() throws MessagingException;

    public Date getLastUpdated();

    public void setLastUpdated(Date var1);

    default public Map<AttributeName, Attribute> attributesMap() {
        return (Map)this.attributeNames().map(name -> this.getAttribute((AttributeName)name).map(attribute -> Pair.of((Object)name, (Object)attribute))).flatMap(Optional::stream).collect(ImmutableMap.toImmutableMap(Pair::getKey, Pair::getValue));
    }

    default public Optional<DsnParameters> dsnParameters() {
        return DsnParameters.fromAttributeValue(DsnParameters.DsnAttributeValues.extract(this.attributesMap()));
    }

    default public void setDsnParameters(DsnParameters dsnParameters) {
        dsnParameters.toAttributes().asAttributes().forEach(this::setAttribute);
    }
}

