/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules.data;

import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.multibindings.ProvidesIntoSet;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.james.domainlist.api.DomainList;
import org.apache.james.domainlist.jpa.JPADomainList;
import org.apache.james.domainlist.lib.DomainListConfiguration;
import org.apache.james.server.core.configuration.ConfigurationProvider;
import org.apache.james.utils.InitializationOperation;
import org.apache.james.utils.InitilizationOperationBuilder;

public class JPADomainListModule
extends AbstractModule {
    public void configure() {
        this.bind(JPADomainList.class).in(Scopes.SINGLETON);
        this.bind(DomainList.class).to(JPADomainList.class);
    }

    @Provides
    @Singleton
    public DomainListConfiguration provideDomainListConfiguration(ConfigurationProvider configurationProvider) throws ConfigurationException {
        return DomainListConfiguration.from((HierarchicalConfiguration)configurationProvider.getConfiguration("domainlist"));
    }

    @ProvidesIntoSet
    InitializationOperation configureDomainList(DomainListConfiguration configuration, JPADomainList jpaDomainList) {
        return InitilizationOperationBuilder.forClass(JPADomainList.class).init(() -> jpaDomainList.configure(configuration));
    }
}

