/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Date;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.mail.Flags;
import org.apache.james.core.Username;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.SubscriptionManager;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.ByteSourceContent;
import org.apache.james.mailbox.model.ComposedMessageId;
import org.apache.james.mailbox.model.Content;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MailboxMetaData;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.search.MailboxNameExpression;
import org.apache.james.mailbox.model.search.MailboxQuery;
import org.apache.james.mailbox.model.search.Wildcard;
import org.apache.james.mailbox.probe.MailboxProbe;
import org.apache.james.mailbox.store.MailboxReactorUtils;
import org.apache.james.utils.GuiceProbe;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class MailboxProbeImpl
implements GuiceProbe,
MailboxProbe {
    private final MailboxManager mailboxManager;
    private final SubscriptionManager subscriptionManager;

    @Inject
    private MailboxProbeImpl(MailboxManager mailboxManager, SubscriptionManager subscriptionManager) {
        this.mailboxManager = mailboxManager;
        this.subscriptionManager = subscriptionManager;
    }

    public MailboxId createMailbox(String namespace, String user, String name) {
        return this.createMailbox(new MailboxPath(namespace, Username.of((String)user), name));
    }

    public MailboxId createMailbox(MailboxPath mailboxPath) {
        MailboxSession mailboxSession = null;
        try {
            mailboxSession = this.mailboxManager.createSystemSession(mailboxPath.getUser());
            this.mailboxManager.startProcessingRequest(mailboxSession);
            MailboxId mailboxId = (MailboxId)this.mailboxManager.createMailbox(mailboxPath, mailboxSession).orElseThrow(() -> new MailboxException("mailbox name is probably empty"));
            this.closeSession(mailboxSession);
            return mailboxId;
        }
        catch (MailboxException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                this.closeSession(mailboxSession);
                throw throwable;
            }
        }
    }

    public MailboxId getMailboxId(String namespace, String user, String name) {
        Username username = Username.of((String)user);
        MailboxSession mailboxSession = null;
        try {
            mailboxSession = this.mailboxManager.createSystemSession(username);
            MailboxPath path = new MailboxPath(namespace, username, name);
            MailboxId mailboxId = this.mailboxManager.getMailbox(path, mailboxSession).getId();
            return mailboxId;
        }
        catch (MailboxException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.closeSession(mailboxSession);
        }
    }

    private void closeSession(MailboxSession session) {
        if (session != null) {
            this.mailboxManager.endProcessingRequest(session);
            this.mailboxManager.logout(session);
        }
    }

    public Collection<String> listUserMailboxes(String user) {
        MailboxSession mailboxSession = null;
        try {
            mailboxSession = this.mailboxManager.createSystemSession(Username.of((String)user));
            this.mailboxManager.startProcessingRequest(mailboxSession);
            Collection collection = (Collection)MailboxReactorUtils.block((Mono)this.searchUserMailboxes(mailboxSession).map(MailboxMetaData::getPath).map(MailboxPath::getName).collect(Collectors.toList()));
            this.closeSession(mailboxSession);
            return collection;
        }
        catch (MailboxException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                this.closeSession(mailboxSession);
                throw throwable;
            }
        }
    }

    private Flux<MailboxMetaData> searchUserMailboxes(MailboxSession session) {
        return this.mailboxManager.search(MailboxQuery.privateMailboxesBuilder((MailboxSession)session).expression((MailboxNameExpression)Wildcard.INSTANCE).build(), MailboxManager.MailboxSearchFetchType.Minimal, session);
    }

    public void deleteMailbox(String namespace, String user, String name) {
        MailboxSession mailboxSession = null;
        Username username = Username.of((String)user);
        try {
            mailboxSession = this.mailboxManager.createSystemSession(username);
            this.mailboxManager.startProcessingRequest(mailboxSession);
            this.mailboxManager.deleteMailbox(new MailboxPath(namespace, username, name), mailboxSession);
        }
        catch (MailboxException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.closeSession(mailboxSession);
        }
    }

    public ComposedMessageId appendMessage(String username, MailboxPath mailboxPath, InputStream message, Date internalDate, boolean isRecent, Flags flags) throws MailboxException {
        ComposedMessageId composedMessageId;
        block8: {
            MailboxSession mailboxSession = this.mailboxManager.createSystemSession(Username.of((String)username));
            MessageManager messageManager = this.mailboxManager.getMailbox(mailboxPath, mailboxSession);
            ByteSourceContent content = ByteSourceContent.of((InputStream)message);
            try {
                composedMessageId = messageManager.appendMessage(MessageManager.AppendCommand.builder().withInternalDate(internalDate).isRecent(isRecent).withFlags(flags).build((Content)content), mailboxSession).getId();
                if (content == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (content != null) {
                        try {
                            content.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new MailboxException("Failed appending message", (Throwable)e);
                }
            }
            content.close();
        }
        return composedMessageId;
    }

    public ComposedMessageId appendMessage(String username, MailboxPath mailboxPath, MessageManager.AppendCommand appendCommand) throws MailboxException {
        MailboxSession mailboxSession = this.mailboxManager.createSystemSession(Username.of((String)username));
        MessageManager messageManager = this.mailboxManager.getMailbox(mailboxPath, mailboxSession);
        return messageManager.appendMessage(appendCommand, mailboxSession).getId();
    }

    public Collection<String> listSubscriptions(String user) throws Exception {
        MailboxSession mailboxSession = this.mailboxManager.createSystemSession(Username.of((String)user));
        return this.subscriptionManager.subscriptions(mailboxSession);
    }
}

