/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.properties;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.properties.AbstractLocationPropertiesSource;
import org.apache.camel.component.properties.PropertiesComponent;
import org.apache.camel.component.properties.PropertiesLocation;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.OrderedProperties;

public class FilePropertiesSource
extends AbstractLocationPropertiesSource {
    protected FilePropertiesSource(PropertiesComponent propertiesComponent, PropertiesLocation location) {
        super(propertiesComponent, location);
    }

    public String getName() {
        return "FilePropertiesSource[" + this.getLocation().getPath() + "]";
    }

    /*
     * Loose catch block
     */
    @Override
    protected Properties loadPropertiesFromLocation(PropertiesComponent propertiesComponent, PropertiesLocation location) {
        BufferedReader reader;
        FileInputStream is;
        OrderedProperties answer;
        block7: {
            answer = new OrderedProperties();
            String path = location.getPath();
            is = null;
            reader = null;
            try {
                is = new FileInputStream(path);
                if (propertiesComponent.getEncoding() != null) {
                    reader = new BufferedReader(new InputStreamReader((InputStream)is, propertiesComponent.getEncoding()));
                    answer.load(reader);
                    break block7;
                }
                answer.load(is);
            }
            catch (FileNotFoundException e) {
                block8: {
                    if (propertiesComponent.isIgnoreMissingLocation() || location.isOptional()) break block8;
                    throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
                }
                IOHelper.close((Closeable[])new Closeable[]{reader, is});
            }
            catch (IOException e2) {
                throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e2);
                {
                    catch (Throwable throwable) {
                        IOHelper.close((Closeable[])new Closeable[]{reader, is});
                        throw throwable;
                    }
                }
            }
        }
        IOHelper.close((Closeable[])new Closeable[]{reader, is});
        return answer;
    }
}

