/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.jpa.quota;

import com.github.fge.lambdas.Throwing;
import com.github.steveash.guavate.Guavate;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.james.core.Domain;
import org.apache.james.core.quota.QuotaCountLimit;
import org.apache.james.core.quota.QuotaSizeLimit;
import org.apache.james.mailbox.jpa.quota.JPAPerUserMaxQuotaDAO;
import org.apache.james.mailbox.model.Quota;
import org.apache.james.mailbox.model.QuotaRoot;
import org.apache.james.mailbox.quota.MaxQuotaManager;

public class JPAPerUserMaxQuotaManager
implements MaxQuotaManager {
    private final JPAPerUserMaxQuotaDAO dao;

    @Inject
    public JPAPerUserMaxQuotaManager(JPAPerUserMaxQuotaDAO dao) {
        this.dao = dao;
    }

    public void setMaxStorage(QuotaRoot quotaRoot, QuotaSizeLimit maxStorageQuota) {
        this.dao.setMaxStorage(quotaRoot, Optional.of(maxStorageQuota));
    }

    public void setMaxMessage(QuotaRoot quotaRoot, QuotaCountLimit maxMessageCount) {
        this.dao.setMaxMessage(quotaRoot, Optional.of(maxMessageCount));
    }

    public void setDomainMaxMessage(Domain domain, QuotaCountLimit count) {
        this.dao.setDomainMaxMessage(domain, Optional.of(count));
    }

    public void setDomainMaxStorage(Domain domain, QuotaSizeLimit size) {
        this.dao.setDomainMaxStorage(domain, Optional.of(size));
    }

    public void removeDomainMaxMessage(Domain domain) {
        this.dao.setDomainMaxMessage(domain, Optional.empty());
    }

    public void removeDomainMaxStorage(Domain domain) {
        this.dao.setDomainMaxStorage(domain, Optional.empty());
    }

    public Optional<QuotaCountLimit> getDomainMaxMessage(Domain domain) {
        return this.dao.getDomainMaxMessage(domain);
    }

    public Optional<QuotaSizeLimit> getDomainMaxStorage(Domain domain) {
        return this.dao.getDomainMaxStorage(domain);
    }

    public void removeMaxMessage(QuotaRoot quotaRoot) {
        this.dao.setMaxMessage(quotaRoot, Optional.empty());
    }

    public void setGlobalMaxStorage(QuotaSizeLimit globalMaxStorage) {
        this.dao.setGlobalMaxStorage(Optional.of(globalMaxStorage));
    }

    public void removeGlobalMaxMessage() {
        this.dao.setGlobalMaxMessage(Optional.empty());
    }

    public void setGlobalMaxMessage(QuotaCountLimit globalMaxMessageCount) {
        this.dao.setGlobalMaxMessage(Optional.of(globalMaxMessageCount));
    }

    public Optional<QuotaSizeLimit> getGlobalMaxStorage() {
        return this.dao.getGlobalMaxStorage();
    }

    public Optional<QuotaCountLimit> getGlobalMaxMessage() {
        return this.dao.getGlobalMaxMessage();
    }

    public Map<Quota.Scope, QuotaCountLimit> listMaxMessagesDetails(QuotaRoot quotaRoot) {
        Function domainQuotaFunction = Throwing.function(this::getDomainMaxMessage).sneakyThrow();
        return (Map)Stream.of(Pair.of((Object)Quota.Scope.User, this.dao.getMaxMessage(quotaRoot)), Pair.of((Object)Quota.Scope.Domain, quotaRoot.getDomain().flatMap(domainQuotaFunction)), Pair.of((Object)Quota.Scope.Global, this.dao.getGlobalMaxMessage())).filter(pair -> ((Optional)pair.getValue()).isPresent()).collect(Guavate.toImmutableMap(Pair::getKey, value -> (QuotaCountLimit)((Optional)value.getValue()).get()));
    }

    public Map<Quota.Scope, QuotaSizeLimit> listMaxStorageDetails(QuotaRoot quotaRoot) {
        Function domainQuotaFunction = Throwing.function(this::getDomainMaxStorage).sneakyThrow();
        return (Map)Stream.of(Pair.of((Object)Quota.Scope.User, this.dao.getMaxStorage(quotaRoot)), Pair.of((Object)Quota.Scope.Domain, quotaRoot.getDomain().flatMap(domainQuotaFunction)), Pair.of((Object)Quota.Scope.Global, this.dao.getGlobalMaxStorage())).filter(pair -> ((Optional)pair.getValue()).isPresent()).collect(Guavate.toImmutableMap(Pair::getKey, value -> (QuotaSizeLimit)((Optional)value.getValue()).get()));
    }

    public void removeMaxStorage(QuotaRoot quotaRoot) {
        this.dao.setMaxStorage(quotaRoot, Optional.empty());
    }

    public void removeGlobalMaxStorage() {
        this.dao.setGlobalMaxStorage(Optional.empty());
    }
}

