/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.api;

import javax.net.ssl.SSLContext;

public final class Encryption {
    private final SSLContext context;
    private final boolean starttls;
    private final String[] enabledCipherSuites;

    private Encryption(SSLContext context, boolean starttls, String[] enabledCipherSuites) {
        this.context = context;
        this.starttls = starttls;
        this.enabledCipherSuites = enabledCipherSuites;
    }

    public static Encryption createTls(SSLContext context) {
        return Encryption.createTls(context, null);
    }

    public static Encryption createTls(SSLContext context, String[] enabledCipherSuites) {
        return new Encryption(context, false, enabledCipherSuites);
    }

    public static Encryption createStartTls(SSLContext context) {
        return Encryption.createStartTls(context, null);
    }

    public static Encryption createStartTls(SSLContext context, String[] enabledCipherSuites) {
        return new Encryption(context, true, enabledCipherSuites);
    }

    public SSLContext getContext() {
        return this.context;
    }

    public boolean isStartTLS() {
        return this.starttls;
    }

    public String[] getEnabledCipherSuites() {
        return this.enabledCipherSuites;
    }
}

