/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.routes;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.james.core.Domain;
import org.apache.james.core.Username;
import org.apache.james.core.quota.QuotaCountLimit;
import org.apache.james.core.quota.QuotaSizeLimit;
import org.apache.james.mailbox.quota.task.RecomputeCurrentQuotasService;
import org.apache.james.mailbox.quota.task.RecomputeCurrentQuotasTask;
import org.apache.james.quota.search.Limit;
import org.apache.james.quota.search.Offset;
import org.apache.james.quota.search.QuotaBoundary;
import org.apache.james.quota.search.QuotaQuery;
import org.apache.james.task.TaskManager;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.api.UsersRepositoryException;
import org.apache.james.webadmin.Routes;
import org.apache.james.webadmin.dto.QuotaDTO;
import org.apache.james.webadmin.dto.QuotaDetailsDTO;
import org.apache.james.webadmin.dto.ValidatedQuotaDTO;
import org.apache.james.webadmin.service.UserQuotaService;
import org.apache.james.webadmin.tasks.TaskFromRequestRegistry;
import org.apache.james.webadmin.tasks.TaskIdDto;
import org.apache.james.webadmin.tasks.TaskRegistrationKey;
import org.apache.james.webadmin.utils.ErrorResponder;
import org.apache.james.webadmin.utils.JsonExtractException;
import org.apache.james.webadmin.utils.JsonExtractor;
import org.apache.james.webadmin.utils.JsonTransformer;
import org.apache.james.webadmin.utils.JsonTransformerModule;
import org.apache.james.webadmin.utils.ParametersExtractor;
import org.apache.james.webadmin.utils.Responses;
import org.apache.james.webadmin.validation.QuotaDTOValidator;
import org.apache.james.webadmin.validation.Quotas;
import spark.Request;
import spark.Response;
import spark.ResponseTransformer;
import spark.Route;
import spark.Service;

@Api(tags={"UserQuota"})
@Path(value="/quota/users")
@Produces(value={"application/json"})
public class UserQuotaRoutes
implements Routes {
    public static final String USER_QUOTAS_OPERATIONS_INJECTION_KEY = "userQuotasOperations";
    private static final TaskRegistrationKey RECOMPUTE_CURRENT_QUOTAS = TaskRegistrationKey.of((String)"RecomputeCurrentQuotas");
    private static final String USER = "user";
    private static final String MIN_OCCUPATION_RATIO = "minOccupationRatio";
    private static final String MAX_OCCUPATION_RATIO = "maxOccupationRatio";
    private static final String DOMAIN = "domain";
    public static final String USERS_QUOTA_ENDPOINT = "/quota/users";
    private static final String QUOTA_ENDPOINT = "/quota/users/:user";
    private static final String COUNT_ENDPOINT = "/quota/users/:user/count";
    private static final String SIZE_ENDPOINT = "/quota/users/:user/size";
    private final UsersRepository usersRepository;
    private final UserQuotaService userQuotaService;
    private final JsonTransformer jsonTransformer;
    private final JsonExtractor<QuotaDTO> jsonExtractor;
    private final QuotaDTOValidator quotaDTOValidator;
    private final TaskManager taskManager;
    private final Set<TaskFromRequestRegistry.TaskRegistration> usersQuotasTaskRegistration;
    private Service service;

    @Inject
    public UserQuotaRoutes(UsersRepository usersRepository, UserQuotaService userQuotaService, JsonTransformer jsonTransformer, Set<JsonTransformerModule> modules, TaskManager taskManager, @Named(value="userQuotasOperations") Set<TaskFromRequestRegistry.TaskRegistration> usersQuotasTaskRegistration) {
        this.usersRepository = usersRepository;
        this.userQuotaService = userQuotaService;
        this.jsonTransformer = jsonTransformer;
        this.jsonExtractor = new JsonExtractor(QuotaDTO.class, modules.stream().map(JsonTransformerModule::asJacksonModule).collect(Collectors.toList()));
        this.quotaDTOValidator = new QuotaDTOValidator();
        this.taskManager = taskManager;
        this.usersQuotasTaskRegistration = usersQuotasTaskRegistration;
    }

    public String getBasePath() {
        return USERS_QUOTA_ENDPOINT;
    }

    public void define(Service service) {
        this.service = service;
        this.defineGetQuotaCount();
        this.defineDeleteQuotaCount();
        this.defineUpdateQuotaCount();
        this.defineGetQuotaSize();
        this.defineDeleteQuotaSize();
        this.defineUpdateQuotaSize();
        this.defineGetQuota();
        this.defineUpdateQuota();
        this.defineGetUsersQuota();
        this.definePostUsersQuota();
        this.definePostUsersQuota().ifPresent(route -> service.post(USERS_QUOTA_ENDPOINT, route, (ResponseTransformer)this.jsonTransformer));
    }

    @POST
    @ApiOperation(value="Recomputing current quotas of users")
    @ApiImplicitParams(value={@ApiImplicitParam(required=true, name="task", paramType="query parameter", dataType="String", defaultValue="none", example="?task=RecomputeCurrentQuotas", value="Compulsory. Only supported value is `RecomputeCurrentQuotas`")})
    @ApiResponses(value={@ApiResponse(code=201, message="Task is created", response=TaskIdDto.class), @ApiResponse(code=500, message="Internal server error - Something went bad on the server side."), @ApiResponse(code=400, message="Bad request - details in the returned error message")})
    public Optional<Route> definePostUsersQuota() {
        return TaskFromRequestRegistry.builder().parameterName("task").registrations(this.usersQuotasTaskRegistration).buildAsRouteOptional(this.taskManager);
    }

    @PUT
    @ApiOperation(value="Updating count and size at the same time")
    @ApiImplicitParams(value={@ApiImplicitParam(required=true, dataTypeClass=QuotaDTO.class, paramType="body")})
    @ApiResponses(value={@ApiResponse(code=204, message="OK. The value has been updated."), @ApiResponse(code=400, message="The body is not a positive integer or not unlimited value (-1)."), @ApiResponse(code=404, message="The user name does not exist."), @ApiResponse(code=500, message="Internal server error - Something went bad on the server side.")})
    public void defineUpdateQuota() {
        this.service.put(QUOTA_ENDPOINT, (request, response) -> {
            try {
                Username username = this.checkUserExist(request);
                QuotaDTO quotaDTO = (QuotaDTO)this.jsonExtractor.parse(request.body());
                ValidatedQuotaDTO validatedQuotaDTO = this.quotaDTOValidator.validatedQuotaDTO(quotaDTO);
                this.userQuotaService.defineQuota(username, validatedQuotaDTO);
                return Responses.returnNoContent((Response)response);
            }
            catch (IllegalArgumentException e) {
                throw ErrorResponder.builder().statusCode(400).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).message("Quota should be positive or unlimited (-1)").cause((Exception)e).haltError();
            }
        });
    }

    @GET
    @ApiOperation(value="Reading count and size at the same time", notes="If there is no limitation for count and/or size, the returned value will be -1")
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=QuotaDetailsDTO.class), @ApiResponse(code=404, message="The user name does not exist."), @ApiResponse(code=500, message="Internal server error - Something went bad on the server side.")})
    public void defineGetQuota() {
        this.service.get(QUOTA_ENDPOINT, (request, response) -> {
            Username username = this.checkUserExist(request);
            return this.userQuotaService.getQuota(username);
        }, (ResponseTransformer)this.jsonTransformer);
    }

    @GET
    @ApiOperation(value="Reading count and size at the same time", notes="If there is no limitation for count and/or size, the returned value will be -1")
    @ApiImplicitParams(value={@ApiImplicitParam(required=false, name="minOccuptationRatio", paramType="query parameter", dataType="Double", example="?minOccuptationRatio=0.8", value="If present, filter the users with occupation ratio lesser than this value."), @ApiImplicitParam(required=false, name="maxOccupationRatio", paramType="query parameter", dataType="Double", example="?maxOccupationRatio=0.99", value="If present, filter the users with occupation ratio greater than this value."), @ApiImplicitParam(required=false, paramType="query parameter", name="limit", dataType="Integer", example="?limit=100", value="If present, fixes the maximal number of key returned in that call. Must be more than zero if specified."), @ApiImplicitParam(required=false, name="offset", paramType="query parameter", dataType="Integer", example="?offset=100", value="If present, skips the given number of key in the output."), @ApiImplicitParam(required=false, name="domain", paramType="query parameter", dataType="String", example="?domain=james.org", value="If present, filter the users by this domain.")})
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=QuotaDetailsDTO.class), @ApiResponse(code=400, message="Validation issues with parameters"), @ApiResponse(code=500, message="Internal server error - Something went bad on the server side.")})
    public void defineGetUsersQuota() {
        this.service.get(USERS_QUOTA_ENDPOINT, (request, response) -> {
            QuotaQuery quotaQuery = QuotaQuery.builder().lessThan(this.extractQuotaBoundary(request, MAX_OCCUPATION_RATIO)).moreThan(this.extractQuotaBoundary(request, MIN_OCCUPATION_RATIO)).hasDomain(this.extractDomain(request, DOMAIN)).withLimit(this.extractLimit(request)).withOffset(this.extractOffset(request)).build();
            return this.userQuotaService.getUsersQuota(quotaQuery);
        }, (ResponseTransformer)this.jsonTransformer);
    }

    public Optional<Domain> extractDomain(Request request, String parameterName) {
        return Optional.ofNullable(request.queryParams(parameterName)).map(Domain::of);
    }

    public Optional<QuotaBoundary> extractQuotaBoundary(Request request, String parameterName) {
        return ParametersExtractor.extractPositiveDouble((Request)request, (String)parameterName).map(QuotaBoundary::new);
    }

    public Limit extractLimit(Request request) {
        return ParametersExtractor.extractLimit((Request)request).getLimit().map(Limit::of).orElse(Limit.unlimited());
    }

    public Offset extractOffset(Request request) {
        return Offset.of((int)ParametersExtractor.extractOffset((Request)request).getOffset());
    }

    @DELETE
    @Path(value="/size")
    @ApiOperation(value="Removing per user mail size limitation by updating to unlimited value")
    @ApiResponses(value={@ApiResponse(code=204, message="The value is updated to unlimited value."), @ApiResponse(code=404, message="The user name does not exist."), @ApiResponse(code=500, message="Internal server error - Something went bad on the server side.")})
    public void defineDeleteQuotaSize() {
        this.service.delete(SIZE_ENDPOINT, (request, response) -> {
            Username username = this.checkUserExist(request);
            this.userQuotaService.deleteMaxSizeQuota(username);
            return Responses.returnNoContent((Response)response);
        });
    }

    @PUT
    @Path(value="/size")
    @ApiOperation(value="Updating per user mail size limitation")
    @ApiImplicitParams(value={@ApiImplicitParam(required=true, dataType="integer", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=204, message="OK. The value has been updated."), @ApiResponse(code=400, message="The body is not a positive integer nor -1."), @ApiResponse(code=404, message="The user name does not exist."), @ApiResponse(code=500, message="Internal server error - Something went bad on the server side.")})
    public void defineUpdateQuotaSize() {
        this.service.put(SIZE_ENDPOINT, (request, response) -> {
            Username username = this.checkUserExist(request);
            QuotaSizeLimit quotaSize = Quotas.quotaSize(request.body());
            this.userQuotaService.defineMaxSizeQuota(username, quotaSize);
            return Responses.returnNoContent((Response)response);
        });
    }

    @GET
    @Path(value="/size")
    @ApiOperation(value="Reading per user mail size limitation")
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=Long.class), @ApiResponse(code=204, message="No value defined"), @ApiResponse(code=404, message="The user name does not exist."), @ApiResponse(code=500, message="Internal server error - Something went bad on the server side.")})
    public void defineGetQuotaSize() {
        this.service.get(SIZE_ENDPOINT, (request, response) -> {
            Username username = this.checkUserExist(request);
            Optional<QuotaSizeLimit> maxSizeQuota = this.userQuotaService.getMaxSizeQuota(username);
            if (maxSizeQuota.isPresent()) {
                return maxSizeQuota;
            }
            return Responses.returnNoContent((Response)response);
        }, (ResponseTransformer)this.jsonTransformer);
    }

    @DELETE
    @Path(value="/count")
    @ApiOperation(value="Removing per user mail count limitation by updating to unlimited value")
    @ApiResponses(value={@ApiResponse(code=204, message="The value is updated to unlimited value."), @ApiResponse(code=404, message="The user name does not exist."), @ApiResponse(code=500, message="Internal server error - Something went bad on the server side.")})
    public void defineDeleteQuotaCount() {
        this.service.delete(COUNT_ENDPOINT, (request, response) -> {
            Username username = this.checkUserExist(request);
            this.userQuotaService.deleteMaxCountQuota(username);
            return Responses.returnNoContent((Response)response);
        });
    }

    @PUT
    @Path(value="/count")
    @ApiOperation(value="Updating per user mail count limitation")
    @ApiImplicitParams(value={@ApiImplicitParam(required=true, dataType="integer", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=204, message="OK. The value has been updated."), @ApiResponse(code=400, message="The body is not a positive integer nor -1."), @ApiResponse(code=404, message="The user name does not exist."), @ApiResponse(code=500, message="Internal server error - Something went bad on the server side.")})
    public void defineUpdateQuotaCount() {
        this.service.put(COUNT_ENDPOINT, (request, response) -> {
            Username username = this.checkUserExist(request);
            QuotaCountLimit quotaCount = Quotas.quotaCount(request.body());
            this.userQuotaService.defineMaxCountQuota(username, quotaCount);
            return Responses.returnNoContent((Response)response);
        });
    }

    @GET
    @Path(value="/count")
    @ApiOperation(value="Reading per user mail count limitation")
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=Long.class), @ApiResponse(code=204, message="No value defined"), @ApiResponse(code=404, message="The user name does not exist."), @ApiResponse(code=500, message="Internal server error - Something went bad on the server side.")})
    public void defineGetQuotaCount() {
        this.service.get(COUNT_ENDPOINT, (request, response) -> {
            Username username = this.checkUserExist(request);
            Optional<QuotaCountLimit> maxCountQuota = this.userQuotaService.getMaxCountQuota(username);
            if (maxCountQuota.isPresent()) {
                return maxCountQuota;
            }
            return Responses.returnNoContent((Response)response);
        }, (ResponseTransformer)this.jsonTransformer);
    }

    private Username checkUserExist(Request request) throws UsersRepositoryException, UnsupportedEncodingException {
        String user = URLDecoder.decode(request.params(USER), StandardCharsets.UTF_8.displayName());
        Username username = Username.of((String)user);
        if (!this.usersRepository.contains(username)) {
            throw ErrorResponder.builder().statusCode(404).type(ErrorResponder.ErrorType.NOT_FOUND).message("User not found").haltError();
        }
        return username;
    }

    private QuotaDTO parseQuotaDTO(Request request) {
        try {
            return (QuotaDTO)this.jsonExtractor.parse(request.body());
        }
        catch (IllegalArgumentException e) {
            throw ErrorResponder.builder().statusCode(400).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).message("Quota should be positive or unlimited (-1)").cause((Exception)e).haltError();
        }
        catch (JsonExtractException e) {
            throw ErrorResponder.builder().statusCode(400).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).message("Malformed JSON input").cause((Exception)((Object)e)).haltError();
        }
    }

    public static class RecomputeCurrentQuotasRequestToTask
    extends TaskFromRequestRegistry.TaskRegistration {
        private static final String USERS_PER_SECOND = "usersPerSecond";

        @Inject
        public RecomputeCurrentQuotasRequestToTask(RecomputeCurrentQuotasService service) {
            super(RECOMPUTE_CURRENT_QUOTAS, request -> new RecomputeCurrentQuotasTask(service, RecomputeCurrentQuotasRequestToTask.parseRunningOptions(request)));
        }

        private static RecomputeCurrentQuotasService.RunningOptions parseRunningOptions(Request request) {
            return RecomputeCurrentQuotasRequestToTask.intQueryParameter(request).map(RecomputeCurrentQuotasService.RunningOptions::withUsersPerSecond).orElse(RecomputeCurrentQuotasService.RunningOptions.DEFAULT);
        }

        private static Optional<Integer> intQueryParameter(Request request) {
            try {
                return Optional.ofNullable(request.queryParams(USERS_PER_SECOND)).map(Integer::parseInt);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(String.format("Illegal value supplied for query parameter '%s', expecting a strictly positive optional integer", USERS_PER_SECOND), e);
            }
        }
    }
}

