/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.dto;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.steveash.guavate.Guavate;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import org.apache.james.dlp.api.DLPRules;
import org.apache.james.util.streams.Iterables;
import org.apache.james.webadmin.dto.DLPConfigurationItemDTO;

public class DLPConfigurationDTO {
    private final ImmutableList<DLPConfigurationItemDTO> rules;

    public static DLPConfigurationDTO toDTO(DLPRules dlpConfigurations) {
        Preconditions.checkNotNull((Object)dlpConfigurations);
        return new DLPConfigurationDTO((ImmutableList<DLPConfigurationItemDTO>)((ImmutableList)Iterables.toStream((Iterable)dlpConfigurations).map(DLPConfigurationItemDTO::toDTO).collect(Guavate.toImmutableList())));
    }

    @JsonCreator
    public DLPConfigurationDTO(@JsonProperty(value="rules") ImmutableList<DLPConfigurationItemDTO> rules) {
        this.rules = rules;
    }

    public ImmutableList<DLPConfigurationItemDTO> getRules() {
        return this.rules;
    }

    @JsonIgnore
    public DLPRules toDLPConfiguration() throws DLPRules.DuplicateRulesIdsException {
        return new DLPRules((ImmutableList)this.rules.stream().map(DLPConfigurationItemDTO::toDLPConfiguration).collect(Guavate.toImmutableList()));
    }
}

