/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james;

import com.google.inject.Module;
import com.google.inject.util.Modules;
import java.util.Collection;
import org.apache.james.CassandraJamesServerMain;
import org.apache.james.CassandraRabbitMQJamesConfiguration;
import org.apache.james.GuiceJamesServer;
import org.apache.james.JamesServerMain;
import org.apache.james.SearchConfiguration;
import org.apache.james.SearchModuleChooser;
import org.apache.james.data.UsersRepositoryModuleChooser;
import org.apache.james.modules.DistributedTaskManagerModule;
import org.apache.james.modules.DistributedTaskSerializationModule;
import org.apache.james.modules.blobstore.BlobStoreCacheModulesChooser;
import org.apache.james.modules.blobstore.BlobStoreConfiguration;
import org.apache.james.modules.blobstore.BlobStoreModulesChooser;
import org.apache.james.modules.data.CassandraUsersRepositoryModule;
import org.apache.james.modules.event.JMAPEventBusModule;
import org.apache.james.modules.event.RabbitMQEventBusModule;
import org.apache.james.modules.queue.rabbitmq.RabbitMQModule;
import org.apache.james.modules.server.JMXServerModule;
import org.apache.james.modules.server.RabbitMailQueueRoutesModule;
import org.apache.james.server.core.configuration.Configuration;

public class CassandraRabbitMQJamesServerMain
implements JamesServerMain {
    protected static final Module MODULES = Modules.override((Module[])new Module[]{Modules.combine((Module[])new Module[]{CassandraJamesServerMain.REQUIRE_TASK_MANAGER_MODULE, new DistributedTaskManagerModule()})}).with(new Module[]{new RabbitMQModule(), new RabbitMailQueueRoutesModule(), new JMAPEventBusModule(), new RabbitMQEventBusModule(), new DistributedTaskSerializationModule()});

    public static void main(String[] args) throws Exception {
        CassandraRabbitMQJamesConfiguration configuration = CassandraRabbitMQJamesConfiguration.builder().useWorkingDirectoryEnvProperty().build();
        LOGGER.info("Loading configuration {}", (Object)configuration.toString());
        GuiceJamesServer server = CassandraRabbitMQJamesServerMain.createServer(configuration).combineWith(new Module[]{new JMXServerModule()});
        JamesServerMain.main((GuiceJamesServer)server);
    }

    public static GuiceJamesServer createServer(CassandraRabbitMQJamesConfiguration configuration) {
        BlobStoreConfiguration blobStoreConfiguration = configuration.blobStoreConfiguration();
        SearchConfiguration searchConfiguration = configuration.searchConfiguration();
        return GuiceJamesServer.forConfiguration((Configuration)configuration).combineWith(new Module[]{MODULES}).combineWith((Collection)BlobStoreModulesChooser.chooseModules((BlobStoreConfiguration)blobStoreConfiguration)).combineWith((Collection)BlobStoreCacheModulesChooser.chooseModules((BlobStoreConfiguration)blobStoreConfiguration)).combineWith((Collection)SearchModuleChooser.chooseModules((SearchConfiguration)searchConfiguration)).combineWith((Collection)new UsersRepositoryModuleChooser((Module)new CassandraUsersRepositoryModule()).chooseModules(configuration.getUsersRepositoryImplementation()));
    }
}

