/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.blob.api;

import com.google.common.io.ByteSource;
import java.io.InputStream;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.james.blob.api.BlobId;
import org.apache.james.blob.api.BlobStore;
import org.apache.james.blob.api.BucketName;
import org.apache.james.metrics.api.MetricFactory;
import org.reactivestreams.Publisher;

public class MetricableBlobStore
implements BlobStore {
    public static final String BLOB_STORE_IMPLEMENTATION = "blobStoreImplementation";
    static final String BLOB_STORE_METRIC_PREFIX = "blobStore:";
    static final String SAVE_BYTES_TIMER_NAME = "blobStore:saveBytes";
    static final String SAVE_INPUT_STREAM_TIMER_NAME = "blobStore:saveInputStream";
    static final String READ_BYTES_TIMER_NAME = "blobStore:readBytes";
    static final String READ_TIMER_NAME = "blobStore:read";
    static final String DELETE_TIMER_NAME = "blobStore:delete";
    static final String DELETE_BUCKET_TIMER_NAME = "blobStore:deleteBucket";
    private final MetricFactory metricFactory;
    private final BlobStore blobStoreImpl;

    @Inject
    public MetricableBlobStore(MetricFactory metricFactory, @Named(value="blobStoreImplementation") BlobStore blobStoreImpl) {
        this.metricFactory = metricFactory;
        this.blobStoreImpl = blobStoreImpl;
    }

    @Override
    public Publisher<BlobId> save(BucketName bucketName, byte[] data, BlobStore.StoragePolicy storagePolicy) {
        return this.metricFactory.decoratePublisherWithTimerMetric(SAVE_BYTES_TIMER_NAME, this.blobStoreImpl.save(bucketName, data, storagePolicy));
    }

    @Override
    public Publisher<BlobId> save(BucketName bucketName, InputStream data, BlobStore.StoragePolicy storagePolicy) {
        return this.metricFactory.decoratePublisherWithTimerMetric(SAVE_INPUT_STREAM_TIMER_NAME, this.blobStoreImpl.save(bucketName, data, storagePolicy));
    }

    @Override
    public Publisher<BlobId> save(BucketName bucketName, ByteSource data, BlobStore.StoragePolicy storagePolicy) {
        return this.metricFactory.decoratePublisherWithTimerMetric(SAVE_INPUT_STREAM_TIMER_NAME, this.blobStoreImpl.save(bucketName, data, storagePolicy));
    }

    @Override
    public Publisher<byte[]> readBytes(BucketName bucketName, BlobId blobId) {
        return this.metricFactory.decoratePublisherWithTimerMetric(READ_BYTES_TIMER_NAME, this.blobStoreImpl.readBytes(bucketName, blobId));
    }

    @Override
    public InputStream read(BucketName bucketName, BlobId blobId) {
        return (InputStream)this.metricFactory.decorateSupplierWithTimerMetric(READ_TIMER_NAME, () -> this.blobStoreImpl.read(bucketName, blobId));
    }

    @Override
    public Publisher<byte[]> readBytes(BucketName bucketName, BlobId blobId, BlobStore.StoragePolicy storagePolicy) {
        return this.metricFactory.decoratePublisherWithTimerMetric(READ_BYTES_TIMER_NAME, this.blobStoreImpl.readBytes(bucketName, blobId, storagePolicy));
    }

    @Override
    public InputStream read(BucketName bucketName, BlobId blobId, BlobStore.StoragePolicy storagePolicy) {
        return (InputStream)this.metricFactory.decorateSupplierWithTimerMetric(READ_TIMER_NAME, () -> this.blobStoreImpl.read(bucketName, blobId, storagePolicy));
    }

    @Override
    public Publisher<Void> deleteBucket(BucketName bucketName) {
        return this.metricFactory.decoratePublisherWithTimerMetric(DELETE_BUCKET_TIMER_NAME, this.blobStoreImpl.deleteBucket(bucketName));
    }

    @Override
    public BucketName getDefaultBucketName() {
        return this.blobStoreImpl.getDefaultBucketName();
    }

    @Override
    public Publisher<Boolean> delete(BucketName bucketName, BlobId blobId) {
        return this.metricFactory.decoratePublisherWithTimerMetric(DELETE_TIMER_NAME, this.blobStoreImpl.delete(bucketName, blobId));
    }
}

