/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spi;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;

public interface Resource {
    public String getLocation();

    public InputStream getInputStream() throws IOException;

    public static Resource fromClasspath(String location) {
        return Resource.fromClasspath(Resource.class, location);
    }

    public static Resource fromClasspath(final Class<?> type, final String location) {
        return new Resource(){

            @Override
            public String getLocation() {
                return location;
            }

            @Override
            public InputStream getInputStream() throws IOException {
                return type.getResourceAsStream(location);
            }
        };
    }

    public static Resource fromBytes(final String location, final byte[] content) {
        return new Resource(){

            @Override
            public String getLocation() {
                return location;
            }

            @Override
            public InputStream getInputStream() throws IOException {
                return new ByteArrayInputStream(content);
            }
        };
    }

    public static Resource fromString(String location, String content) {
        return Resource.fromBytes(location, content.getBytes(StandardCharsets.UTF_8));
    }
}

