/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.utils;

import com.github.steveash.guavate.Guavate;
import com.google.inject.Inject;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.mail.MessagingException;
import org.apache.james.mailetcontainer.api.MailetLoader;
import org.apache.james.utils.ClassName;
import org.apache.james.utils.GuiceGenericLoader;
import org.apache.james.utils.MailetConfigurationOverride;
import org.apache.james.utils.NamingScheme;
import org.apache.james.utils.PackageName;
import org.apache.mailet.Mailet;
import org.apache.mailet.MailetConfig;

public class GuiceMailetLoader
implements MailetLoader {
    private static final PackageName STANDARD_PACKAGE = PackageName.of((String)"org.apache.james.transport.mailets.");
    private static final NamingScheme MAILET_NAMING_SCHEME = new NamingScheme.OptionalPackagePrefix(STANDARD_PACKAGE);
    private final GuiceGenericLoader genericLoader;
    private final Map<Class<? extends Mailet>, MailetConfig> configurationOverrides;

    @Inject
    public GuiceMailetLoader(GuiceGenericLoader genericLoader, Set<MailetConfigurationOverride> mailetConfigurationOverrides) {
        this.genericLoader = genericLoader;
        this.configurationOverrides = (Map)mailetConfigurationOverrides.stream().collect(Guavate.toImmutableMap(MailetConfigurationOverride::getClazz, MailetConfigurationOverride::getNewConfiguration));
    }

    public Mailet getMailet(MailetConfig config) throws MessagingException {
        try {
            ClassName className = new ClassName(config.getMailetName());
            Mailet result = (Mailet)this.genericLoader.withNamingSheme(MAILET_NAMING_SCHEME).instantiate(className);
            result.init(this.resolveConfiguration(result, config));
            return result;
        }
        catch (Exception e) {
            throw new MessagingException("Can not load mailet " + config.getMailetName(), e);
        }
    }

    private MailetConfig resolveConfiguration(Mailet result, MailetConfig providedConfiguration) {
        return Optional.ofNullable(this.configurationOverrides.get(result.getClass())).orElse(providedConfiguration);
    }
}

