/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.pop3.core;

import com.github.fge.lambdas.Throwing;
import java.util.Optional;
import org.apache.james.protocols.api.Request;
import org.apache.james.protocols.pop3.POP3Session;
import org.apache.james.protocols.pop3.mailbox.Mailbox;
import org.apache.james.util.MDCBuilder;

public interface MDCConstants {
    public static final String MAILBOX = "mailbox";
    public static final String ARGUMENT = "argument";
    public static final String STATE = "state";

    public static MDCBuilder withMailbox(POP3Session session) {
        return Optional.ofNullable(session.getUserMailbox()).map(Throwing.function(Mailbox::getIdentifier).sneakyThrow()).map(id -> MDCBuilder.create().addContext(MAILBOX, id)).orElse(MDCBuilder.create());
    }

    public static MDCBuilder forRequest(Request request) {
        return Optional.ofNullable(request.getArgument()).map(argument -> MDCBuilder.create().addContext(ARGUMENT, argument)).orElse(MDCBuilder.create());
    }

    public static MDCBuilder withSession(POP3Session session) {
        return MDCBuilder.create().addContext(MDCConstants.withMailbox(session)).addContext(STATE, (Object)session.getHandlerState());
    }
}

