/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.pop3.core;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Optional;
import org.apache.james.core.Username;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.protocols.api.Request;
import org.apache.james.protocols.api.Response;
import org.apache.james.protocols.pop3.POP3Response;
import org.apache.james.protocols.pop3.POP3Session;
import org.apache.james.protocols.pop3.core.MDCConstants;
import org.apache.james.protocols.pop3.core.RsetCmdHandler;
import org.apache.james.protocols.pop3.mailbox.Mailbox;
import org.apache.james.util.MDCBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPassCmdHandler
extends RsetCmdHandler {
    private static final Collection<String> COMMANDS = ImmutableSet.of((Object)"PASS");
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractPassCmdHandler.class);
    private static final Response UNEXPECTED_ERROR = new POP3Response("-ERR", "Unexpected error accessing mailbox").immutable();
    protected static final Response AUTH_FAILED = new POP3Response("-ERR", "Authentication failed.").immutable();
    private final MetricFactory metricFactory;

    public AbstractPassCmdHandler(MetricFactory metricFactory) {
        super(metricFactory);
        this.metricFactory = metricFactory;
    }

    @Override
    public Response onCommand(POP3Session session, Request request) {
        return (Response)this.metricFactory.decorateSupplierWithTimerMetric("pop3-pass", () -> (Response)MDCBuilder.withMdc((MDCBuilder)MDCBuilder.create().addContext("action", (Object)"AUTH").addContext(MDCConstants.withSession(session)), () -> this.doAuth(session, request)));
    }

    private Response doAuth(POP3Session session, Request request) {
        LOGGER.trace("PASS command received");
        String parameters = request.getArgument();
        if (session.getHandlerState() == 1 && parameters != null) {
            return this.doAuth(session, session.getUsername(), parameters);
        }
        session.setHandlerState(0);
        return AUTH_FAILED;
    }

    protected final Response doAuth(POP3Session session, Username user, String pass) {
        try {
            Mailbox mailbox = this.auth(session, user, pass);
            if (mailbox != null) {
                session.setUserMailbox(mailbox);
                this.stat(session);
                session.setHandlerState(2);
                StringBuilder responseBuffer = new StringBuilder(64).append("Welcome ").append((String)Optional.ofNullable(session.getUsername()).map(Username::asString).orElse(null));
                return new POP3Response("+OK", responseBuffer.toString());
            }
            session.setHandlerState(0);
            return AUTH_FAILED;
        }
        catch (Exception e) {
            LOGGER.error("Unexpected error accessing mailbox for {}", (Object)session.getUsername(), (Object)e);
            session.setHandlerState(0);
            return UNEXPECTED_ERROR;
        }
    }

    @Override
    public Collection<String> getImplCommands() {
        return COMMANDS;
    }

    protected abstract Mailbox auth(POP3Session var1, Username var2, String var3) throws Exception;
}

