/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.routes;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.james.mailbox.indexer.MessageIdReIndexer;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.task.TaskManager;
import org.apache.james.webadmin.Routes;
import org.apache.james.webadmin.routes.MailboxesRoutes;
import org.apache.james.webadmin.tasks.TaskFromRequestRegistry;
import org.apache.james.webadmin.tasks.TaskIdDto;
import org.apache.james.webadmin.utils.ErrorResponder;
import org.apache.james.webadmin.utils.JsonTransformer;
import spark.Request;
import spark.ResponseTransformer;
import spark.Route;
import spark.Service;

@Api(tags={"MessageIdReIndexing"})
@Path(value="/messages")
@Produces(value={"application/json"})
public class MessagesRoutes
implements Routes {
    private static final String MESSAGE_ID_PARAM = ":messageId";
    private static final String BASE_PATH = "/messages";
    private static final String MESSAGE_PATH = "/messages/:messageId";
    private final TaskManager taskManager;
    private final MessageId.Factory messageIdFactory;
    private final MessageIdReIndexer reIndexer;
    private final JsonTransformer jsonTransformer;
    private final Set<TaskFromRequestRegistry.TaskRegistration> allMessagesTaskRegistration;
    public static final String ALL_MESSAGES_TASKS = "allMessagesTasks";

    @Inject
    MessagesRoutes(TaskManager taskManager, MessageId.Factory messageIdFactory, MessageIdReIndexer reIndexer, JsonTransformer jsonTransformer, @Named(value="allMessagesTasks") Set<TaskFromRequestRegistry.TaskRegistration> allMessagesTaskRegistration) {
        this.taskManager = taskManager;
        this.messageIdFactory = messageIdFactory;
        this.reIndexer = reIndexer;
        this.jsonTransformer = jsonTransformer;
        this.allMessagesTaskRegistration = allMessagesTaskRegistration;
    }

    public String getBasePath() {
        return BASE_PATH;
    }

    public void define(Service service) {
        service.post(MESSAGE_PATH, this.reIndexMessage(), (ResponseTransformer)this.jsonTransformer);
        this.allMessagesOperations().ifPresent(route -> service.post(BASE_PATH, route, (ResponseTransformer)this.jsonTransformer));
    }

    @POST
    @Path(value="/{messageId}")
    @ApiOperation(value="Re-indexes one email in the different mailboxes containing it")
    @ApiImplicitParams(value={@ApiImplicitParam(required=true, name="task", paramType="query parameter", dataType="String", defaultValue="none", example="?task=reIndex", value="Compulsory. Only supported value is `reIndex`"), @ApiImplicitParam(required=true, name="messageId", paramType="path parameter", dataType="String", defaultValue="none", value="Compulsory. Needs to be a valid messageId (format depends on the mailbox implementation)")})
    @ApiResponses(value={@ApiResponse(code=201, message="Task is created", response=TaskIdDto.class), @ApiResponse(code=500, message="Internal server error - Something went bad on the server side."), @ApiResponse(code=400, message="Bad request - details in the returned error message")})
    private Route reIndexMessage() {
        return TaskFromRequestRegistry.builder().parameterName("task").register(MailboxesRoutes.RE_INDEX, request -> this.reIndexer.reIndex(this.extractMessageId(request))).buildAsRoute(this.taskManager);
    }

    private MessageId extractMessageId(Request request) {
        try {
            return this.messageIdFactory.fromString(request.params(MESSAGE_ID_PARAM));
        }
        catch (Exception e) {
            throw ErrorResponder.builder().statusCode(400).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).message("Error while parsing 'messageId'").cause(e).haltError();
        }
    }

    @POST
    @Path(value="/")
    @ApiOperation(value="Operation on messages")
    @ApiImplicitParams(value={@ApiImplicitParam(required=true, name="task", paramType="query parameter", dataType="String", defaultValue="none", example="?task=SolveInconsistencies", value="Compulsory. Depends on the tasks handled by the product")})
    @ApiResponses(value={@ApiResponse(code=201, message="Task is created", response=TaskIdDto.class), @ApiResponse(code=500, message="Internal server error - Something went bad on the server side."), @ApiResponse(code=400, message="Bad request - details in the returned error message")})
    private Optional<Route> allMessagesOperations() {
        return TaskFromRequestRegistry.builder().parameterName("task").registrations(this.allMessagesTaskRegistration).buildAsRouteOptional(this.taskManager);
    }
}

